// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * PodResourceClaimStatus is stored in the PodStatus for each PodResourceClaim which references a ResourceClaimTemplate. It stores the generated name for the corresponding ResourceClaim.
 * 
 */
public final class PodResourceClaimStatusArgs extends com.pulumi.resources.ResourceArgs {

    public static final PodResourceClaimStatusArgs Empty = new PodResourceClaimStatusArgs();

    /**
     * Name uniquely identifies this resource claim inside the pod. This must match the name of an entry in pod.spec.resourceClaims, which implies that the string must be a DNS_LABEL.
     * 
     */
    @Import(name="name", required=true)
    private Output<String> name;

    /**
     * @return Name uniquely identifies this resource claim inside the pod. This must match the name of an entry in pod.spec.resourceClaims, which implies that the string must be a DNS_LABEL.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     * ResourceClaimName is the name of the ResourceClaim that was generated for the Pod in the namespace of the Pod. If this is unset, then generating a ResourceClaim was not necessary. The pod.spec.resourceClaims entry can be ignored in this case.
     * 
     */
    @Import(name="resourceClaimName")
    private @Nullable Output<String> resourceClaimName;

    /**
     * @return ResourceClaimName is the name of the ResourceClaim that was generated for the Pod in the namespace of the Pod. If this is unset, then generating a ResourceClaim was not necessary. The pod.spec.resourceClaims entry can be ignored in this case.
     * 
     */
    public Optional<Output<String>> resourceClaimName() {
        return Optional.ofNullable(this.resourceClaimName);
    }

    private PodResourceClaimStatusArgs() {}

    private PodResourceClaimStatusArgs(PodResourceClaimStatusArgs $) {
        this.name = $.name;
        this.resourceClaimName = $.resourceClaimName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PodResourceClaimStatusArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PodResourceClaimStatusArgs $;

        public Builder() {
            $ = new PodResourceClaimStatusArgs();
        }

        public Builder(PodResourceClaimStatusArgs defaults) {
            $ = new PodResourceClaimStatusArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param name Name uniquely identifies this resource claim inside the pod. This must match the name of an entry in pod.spec.resourceClaims, which implies that the string must be a DNS_LABEL.
         * 
         * @return builder
         * 
         */
        public Builder name(Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name uniquely identifies this resource claim inside the pod. This must match the name of an entry in pod.spec.resourceClaims, which implies that the string must be a DNS_LABEL.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param resourceClaimName ResourceClaimName is the name of the ResourceClaim that was generated for the Pod in the namespace of the Pod. If this is unset, then generating a ResourceClaim was not necessary. The pod.spec.resourceClaims entry can be ignored in this case.
         * 
         * @return builder
         * 
         */
        public Builder resourceClaimName(@Nullable Output<String> resourceClaimName) {
            $.resourceClaimName = resourceClaimName;
            return this;
        }

        /**
         * @param resourceClaimName ResourceClaimName is the name of the ResourceClaim that was generated for the Pod in the namespace of the Pod. If this is unset, then generating a ResourceClaim was not necessary. The pod.spec.resourceClaims entry can be ignored in this case.
         * 
         * @return builder
         * 
         */
        public Builder resourceClaimName(String resourceClaimName) {
            return resourceClaimName(Output.of(resourceClaimName));
        }

        public PodResourceClaimStatusArgs build() {
            if ($.name == null) {
                throw new MissingRequiredPropertyException("PodResourceClaimStatusArgs", "name");
            }
            return $;
        }
    }

}
