// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * ResourceHealth represents the health of a resource. It has the latest device health information. This is a part of KEP https://kep.k8s.io/4680 and historical health changes are planned to be added in future iterations of a KEP.
 * 
 */
public final class ResourceHealthArgs extends com.pulumi.resources.ResourceArgs {

    public static final ResourceHealthArgs Empty = new ResourceHealthArgs();

    /**
     * Health of the resource. can be one of:
     *  - Healthy: operates as normal
     *  - Unhealthy: reported unhealthy. We consider this a temporary health issue
     *               since we do not have a mechanism today to distinguish
     *               temporary and permanent issues.
     *  - Unknown: The status cannot be determined.
     *             For example, Device Plugin got unregistered and hasn&#39;t been re-registered since.
     * 
     * In future we may want to introduce the PermanentlyUnhealthy Status.
     * 
     */
    @Import(name="health")
    private @Nullable Output<String> health;

    /**
     * @return Health of the resource. can be one of:
     *  - Healthy: operates as normal
     *  - Unhealthy: reported unhealthy. We consider this a temporary health issue
     *               since we do not have a mechanism today to distinguish
     *               temporary and permanent issues.
     *  - Unknown: The status cannot be determined.
     *             For example, Device Plugin got unregistered and hasn&#39;t been re-registered since.
     * 
     * In future we may want to introduce the PermanentlyUnhealthy Status.
     * 
     */
    public Optional<Output<String>> health() {
        return Optional.ofNullable(this.health);
    }

    /**
     * ResourceID is the unique identifier of the resource. See the ResourceID type for more information.
     * 
     */
    @Import(name="resourceID", required=true)
    private Output<String> resourceID;

    /**
     * @return ResourceID is the unique identifier of the resource. See the ResourceID type for more information.
     * 
     */
    public Output<String> resourceID() {
        return this.resourceID;
    }

    private ResourceHealthArgs() {}

    private ResourceHealthArgs(ResourceHealthArgs $) {
        this.health = $.health;
        this.resourceID = $.resourceID;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ResourceHealthArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ResourceHealthArgs $;

        public Builder() {
            $ = new ResourceHealthArgs();
        }

        public Builder(ResourceHealthArgs defaults) {
            $ = new ResourceHealthArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param health Health of the resource. can be one of:
         *  - Healthy: operates as normal
         *  - Unhealthy: reported unhealthy. We consider this a temporary health issue
         *               since we do not have a mechanism today to distinguish
         *               temporary and permanent issues.
         *  - Unknown: The status cannot be determined.
         *             For example, Device Plugin got unregistered and hasn&#39;t been re-registered since.
         * 
         * In future we may want to introduce the PermanentlyUnhealthy Status.
         * 
         * @return builder
         * 
         */
        public Builder health(@Nullable Output<String> health) {
            $.health = health;
            return this;
        }

        /**
         * @param health Health of the resource. can be one of:
         *  - Healthy: operates as normal
         *  - Unhealthy: reported unhealthy. We consider this a temporary health issue
         *               since we do not have a mechanism today to distinguish
         *               temporary and permanent issues.
         *  - Unknown: The status cannot be determined.
         *             For example, Device Plugin got unregistered and hasn&#39;t been re-registered since.
         * 
         * In future we may want to introduce the PermanentlyUnhealthy Status.
         * 
         * @return builder
         * 
         */
        public Builder health(String health) {
            return health(Output.of(health));
        }

        /**
         * @param resourceID ResourceID is the unique identifier of the resource. See the ResourceID type for more information.
         * 
         * @return builder
         * 
         */
        public Builder resourceID(Output<String> resourceID) {
            $.resourceID = resourceID;
            return this;
        }

        /**
         * @param resourceID ResourceID is the unique identifier of the resource. See the ResourceID type for more information.
         * 
         * @return builder
         * 
         */
        public Builder resourceID(String resourceID) {
            return resourceID(Output.of(resourceID));
        }

        public ResourceHealthArgs build() {
            if ($.resourceID == null) {
                throw new MissingRequiredPropertyException("ResourceHealthArgs", "resourceID");
            }
            return $;
        }
    }

}
