// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.inputs.SecretReferenceArgs;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume
 * 
 */
public final class ScaleIOPersistentVolumeSourceArgs extends com.pulumi.resources.ResourceArgs {

    public static final ScaleIOPersistentVolumeSourceArgs Empty = new ScaleIOPersistentVolumeSourceArgs();

    /**
     * fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. &#34;ext4&#34;, &#34;xfs&#34;, &#34;ntfs&#34;. Default is &#34;xfs&#34;
     * 
     */
    @Import(name="fsType")
    private @Nullable Output<String> fsType;

    /**
     * @return fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. &#34;ext4&#34;, &#34;xfs&#34;, &#34;ntfs&#34;. Default is &#34;xfs&#34;
     * 
     */
    public Optional<Output<String>> fsType() {
        return Optional.ofNullable(this.fsType);
    }

    /**
     * gateway is the host address of the ScaleIO API Gateway.
     * 
     */
    @Import(name="gateway", required=true)
    private Output<String> gateway;

    /**
     * @return gateway is the host address of the ScaleIO API Gateway.
     * 
     */
    public Output<String> gateway() {
        return this.gateway;
    }

    /**
     * protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
     * 
     */
    @Import(name="protectionDomain")
    private @Nullable Output<String> protectionDomain;

    /**
     * @return protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
     * 
     */
    public Optional<Output<String>> protectionDomain() {
        return Optional.ofNullable(this.protectionDomain);
    }

    /**
     * readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * 
     */
    @Import(name="readOnly")
    private @Nullable Output<Boolean> readOnly;

    /**
     * @return readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * 
     */
    public Optional<Output<Boolean>> readOnly() {
        return Optional.ofNullable(this.readOnly);
    }

    /**
     * secretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
     * 
     */
    @Import(name="secretRef", required=true)
    private Output<SecretReferenceArgs> secretRef;

    /**
     * @return secretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
     * 
     */
    public Output<SecretReferenceArgs> secretRef() {
        return this.secretRef;
    }

    /**
     * sslEnabled is the flag to enable/disable SSL communication with Gateway, default false
     * 
     */
    @Import(name="sslEnabled")
    private @Nullable Output<Boolean> sslEnabled;

    /**
     * @return sslEnabled is the flag to enable/disable SSL communication with Gateway, default false
     * 
     */
    public Optional<Output<Boolean>> sslEnabled() {
        return Optional.ofNullable(this.sslEnabled);
    }

    /**
     * storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
     * 
     */
    @Import(name="storageMode")
    private @Nullable Output<String> storageMode;

    /**
     * @return storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
     * 
     */
    public Optional<Output<String>> storageMode() {
        return Optional.ofNullable(this.storageMode);
    }

    /**
     * storagePool is the ScaleIO Storage Pool associated with the protection domain.
     * 
     */
    @Import(name="storagePool")
    private @Nullable Output<String> storagePool;

    /**
     * @return storagePool is the ScaleIO Storage Pool associated with the protection domain.
     * 
     */
    public Optional<Output<String>> storagePool() {
        return Optional.ofNullable(this.storagePool);
    }

    /**
     * system is the name of the storage system as configured in ScaleIO.
     * 
     */
    @Import(name="system", required=true)
    private Output<String> system;

    /**
     * @return system is the name of the storage system as configured in ScaleIO.
     * 
     */
    public Output<String> system() {
        return this.system;
    }

    /**
     * volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.
     * 
     */
    @Import(name="volumeName")
    private @Nullable Output<String> volumeName;

    /**
     * @return volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.
     * 
     */
    public Optional<Output<String>> volumeName() {
        return Optional.ofNullable(this.volumeName);
    }

    private ScaleIOPersistentVolumeSourceArgs() {}

    private ScaleIOPersistentVolumeSourceArgs(ScaleIOPersistentVolumeSourceArgs $) {
        this.fsType = $.fsType;
        this.gateway = $.gateway;
        this.protectionDomain = $.protectionDomain;
        this.readOnly = $.readOnly;
        this.secretRef = $.secretRef;
        this.sslEnabled = $.sslEnabled;
        this.storageMode = $.storageMode;
        this.storagePool = $.storagePool;
        this.system = $.system;
        this.volumeName = $.volumeName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ScaleIOPersistentVolumeSourceArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ScaleIOPersistentVolumeSourceArgs $;

        public Builder() {
            $ = new ScaleIOPersistentVolumeSourceArgs();
        }

        public Builder(ScaleIOPersistentVolumeSourceArgs defaults) {
            $ = new ScaleIOPersistentVolumeSourceArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param fsType fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. &#34;ext4&#34;, &#34;xfs&#34;, &#34;ntfs&#34;. Default is &#34;xfs&#34;
         * 
         * @return builder
         * 
         */
        public Builder fsType(@Nullable Output<String> fsType) {
            $.fsType = fsType;
            return this;
        }

        /**
         * @param fsType fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. &#34;ext4&#34;, &#34;xfs&#34;, &#34;ntfs&#34;. Default is &#34;xfs&#34;
         * 
         * @return builder
         * 
         */
        public Builder fsType(String fsType) {
            return fsType(Output.of(fsType));
        }

        /**
         * @param gateway gateway is the host address of the ScaleIO API Gateway.
         * 
         * @return builder
         * 
         */
        public Builder gateway(Output<String> gateway) {
            $.gateway = gateway;
            return this;
        }

        /**
         * @param gateway gateway is the host address of the ScaleIO API Gateway.
         * 
         * @return builder
         * 
         */
        public Builder gateway(String gateway) {
            return gateway(Output.of(gateway));
        }

        /**
         * @param protectionDomain protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
         * 
         * @return builder
         * 
         */
        public Builder protectionDomain(@Nullable Output<String> protectionDomain) {
            $.protectionDomain = protectionDomain;
            return this;
        }

        /**
         * @param protectionDomain protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
         * 
         * @return builder
         * 
         */
        public Builder protectionDomain(String protectionDomain) {
            return protectionDomain(Output.of(protectionDomain));
        }

        /**
         * @param readOnly readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
         * 
         * @return builder
         * 
         */
        public Builder readOnly(@Nullable Output<Boolean> readOnly) {
            $.readOnly = readOnly;
            return this;
        }

        /**
         * @param readOnly readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
         * 
         * @return builder
         * 
         */
        public Builder readOnly(Boolean readOnly) {
            return readOnly(Output.of(readOnly));
        }

        /**
         * @param secretRef secretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
         * 
         * @return builder
         * 
         */
        public Builder secretRef(Output<SecretReferenceArgs> secretRef) {
            $.secretRef = secretRef;
            return this;
        }

        /**
         * @param secretRef secretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
         * 
         * @return builder
         * 
         */
        public Builder secretRef(SecretReferenceArgs secretRef) {
            return secretRef(Output.of(secretRef));
        }

        /**
         * @param sslEnabled sslEnabled is the flag to enable/disable SSL communication with Gateway, default false
         * 
         * @return builder
         * 
         */
        public Builder sslEnabled(@Nullable Output<Boolean> sslEnabled) {
            $.sslEnabled = sslEnabled;
            return this;
        }

        /**
         * @param sslEnabled sslEnabled is the flag to enable/disable SSL communication with Gateway, default false
         * 
         * @return builder
         * 
         */
        public Builder sslEnabled(Boolean sslEnabled) {
            return sslEnabled(Output.of(sslEnabled));
        }

        /**
         * @param storageMode storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
         * 
         * @return builder
         * 
         */
        public Builder storageMode(@Nullable Output<String> storageMode) {
            $.storageMode = storageMode;
            return this;
        }

        /**
         * @param storageMode storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
         * 
         * @return builder
         * 
         */
        public Builder storageMode(String storageMode) {
            return storageMode(Output.of(storageMode));
        }

        /**
         * @param storagePool storagePool is the ScaleIO Storage Pool associated with the protection domain.
         * 
         * @return builder
         * 
         */
        public Builder storagePool(@Nullable Output<String> storagePool) {
            $.storagePool = storagePool;
            return this;
        }

        /**
         * @param storagePool storagePool is the ScaleIO Storage Pool associated with the protection domain.
         * 
         * @return builder
         * 
         */
        public Builder storagePool(String storagePool) {
            return storagePool(Output.of(storagePool));
        }

        /**
         * @param system system is the name of the storage system as configured in ScaleIO.
         * 
         * @return builder
         * 
         */
        public Builder system(Output<String> system) {
            $.system = system;
            return this;
        }

        /**
         * @param system system is the name of the storage system as configured in ScaleIO.
         * 
         * @return builder
         * 
         */
        public Builder system(String system) {
            return system(Output.of(system));
        }

        /**
         * @param volumeName volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.
         * 
         * @return builder
         * 
         */
        public Builder volumeName(@Nullable Output<String> volumeName) {
            $.volumeName = volumeName;
            return this;
        }

        /**
         * @param volumeName volumeName is the name of a volume already created in the ScaleIO system that is associated with this volume source.
         * 
         * @return builder
         * 
         */
        public Builder volumeName(String volumeName) {
            return volumeName(Output.of(volumeName));
        }

        public ScaleIOPersistentVolumeSourceArgs build() {
            if ($.gateway == null) {
                throw new MissingRequiredPropertyException("ScaleIOPersistentVolumeSourceArgs", "gateway");
            }
            if ($.secretRef == null) {
                throw new MissingRequiredPropertyException("ScaleIOPersistentVolumeSourceArgs", "secretRef");
            }
            if ($.system == null) {
                throw new MissingRequiredPropertyException("ScaleIOPersistentVolumeSourceArgs", "system");
            }
            return $;
        }
    }

}
