// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values.
 * 
 */
public final class ScopedResourceSelectorRequirementArgs extends com.pulumi.resources.ResourceArgs {

    public static final ScopedResourceSelectorRequirementArgs Empty = new ScopedResourceSelectorRequirementArgs();

    /**
     * Represents a scope&#39;s relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.
     * 
     */
    @Import(name="operator", required=true)
    private Output<String> operator;

    /**
     * @return Represents a scope&#39;s relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.
     * 
     */
    public Output<String> operator() {
        return this.operator;
    }

    /**
     * The name of the scope that the selector applies to.
     * 
     */
    @Import(name="scopeName", required=true)
    private Output<String> scopeName;

    /**
     * @return The name of the scope that the selector applies to.
     * 
     */
    public Output<String> scopeName() {
        return this.scopeName;
    }

    /**
     * An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
     * 
     */
    @Import(name="values")
    private @Nullable Output<List<String>> values;

    /**
     * @return An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
     * 
     */
    public Optional<Output<List<String>>> values() {
        return Optional.ofNullable(this.values);
    }

    private ScopedResourceSelectorRequirementArgs() {}

    private ScopedResourceSelectorRequirementArgs(ScopedResourceSelectorRequirementArgs $) {
        this.operator = $.operator;
        this.scopeName = $.scopeName;
        this.values = $.values;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ScopedResourceSelectorRequirementArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ScopedResourceSelectorRequirementArgs $;

        public Builder() {
            $ = new ScopedResourceSelectorRequirementArgs();
        }

        public Builder(ScopedResourceSelectorRequirementArgs defaults) {
            $ = new ScopedResourceSelectorRequirementArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param operator Represents a scope&#39;s relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.
         * 
         * @return builder
         * 
         */
        public Builder operator(Output<String> operator) {
            $.operator = operator;
            return this;
        }

        /**
         * @param operator Represents a scope&#39;s relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.
         * 
         * @return builder
         * 
         */
        public Builder operator(String operator) {
            return operator(Output.of(operator));
        }

        /**
         * @param scopeName The name of the scope that the selector applies to.
         * 
         * @return builder
         * 
         */
        public Builder scopeName(Output<String> scopeName) {
            $.scopeName = scopeName;
            return this;
        }

        /**
         * @param scopeName The name of the scope that the selector applies to.
         * 
         * @return builder
         * 
         */
        public Builder scopeName(String scopeName) {
            return scopeName(Output.of(scopeName));
        }

        /**
         * @param values An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
         * 
         * @return builder
         * 
         */
        public Builder values(@Nullable Output<List<String>> values) {
            $.values = values;
            return this;
        }

        /**
         * @param values An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
         * 
         * @return builder
         * 
         */
        public Builder values(List<String> values) {
            return values(Output.of(values));
        }

        /**
         * @param values An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
         * 
         * @return builder
         * 
         */
        public Builder values(String... values) {
            return values(List.of(values));
        }

        public ScopedResourceSelectorRequirementArgs build() {
            if ($.operator == null) {
                throw new MissingRequiredPropertyException("ScopedResourceSelectorRequirementArgs", "operator");
            }
            if ($.scopeName == null) {
                throw new MissingRequiredPropertyException("ScopedResourceSelectorRequirementArgs", "scopeName");
            }
            return $;
        }
    }

}
