// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Either;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.core.v1.enums.ServiceSpecType;
import com.pulumi.kubernetes.core.v1.inputs.ServicePortPatchArgs;
import com.pulumi.kubernetes.core.v1.inputs.SessionAffinityConfigPatchArgs;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * ServiceSpec describes the attributes that a user creates on a service.
 * 
 */
public final class ServiceSpecPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final ServiceSpecPatchArgs Empty = new ServiceSpecPatchArgs();

    /**
     * allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is &#34;true&#34;. It may be set to &#34;false&#34; if the cluster load-balancer does not rely on NodePorts.  If the caller requests specific NodePorts (by specifying a value), those requests will be respected, regardless of this field. This field may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type.
     * 
     */
    @Import(name="allocateLoadBalancerNodePorts")
    private @Nullable Output<Boolean> allocateLoadBalancerNodePorts;

    /**
     * @return allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is &#34;true&#34;. It may be set to &#34;false&#34; if the cluster load-balancer does not rely on NodePorts.  If the caller requests specific NodePorts (by specifying a value), those requests will be respected, regardless of this field. This field may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type.
     * 
     */
    public Optional<Output<Boolean>> allocateLoadBalancerNodePorts() {
        return Optional.ofNullable(this.allocateLoadBalancerNodePorts);
    }

    /**
     * clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address. Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    @Import(name="clusterIP")
    private @Nullable Output<String> clusterIP;

    /**
     * @return clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address. Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    public Optional<Output<String>> clusterIP() {
        return Optional.ofNullable(this.clusterIP);
    }

    /**
     * ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address.  Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.
     * 
     * This field may hold a maximum of two entries (dual-stack IPs, in either order). These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    @Import(name="clusterIPs")
    private @Nullable Output<List<String>> clusterIPs;

    /**
     * @return ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address.  Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.
     * 
     * This field may hold a maximum of two entries (dual-stack IPs, in either order). These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    public Optional<Output<List<String>>> clusterIPs() {
        return Optional.ofNullable(this.clusterIPs);
    }

    /**
     * externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
     * 
     */
    @Import(name="externalIPs")
    private @Nullable Output<List<String>> externalIPs;

    /**
     * @return externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
     * 
     */
    public Optional<Output<List<String>>> externalIPs() {
        return Optional.ofNullable(this.externalIPs);
    }

    /**
     * externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be &#34;ExternalName&#34;.
     * 
     */
    @Import(name="externalName")
    private @Nullable Output<String> externalName;

    /**
     * @return externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be &#34;ExternalName&#34;.
     * 
     */
    public Optional<Output<String>> externalName() {
        return Optional.ofNullable(this.externalName);
    }

    /**
     * externalTrafficPolicy describes how nodes distribute service traffic they receive on one of the Service&#39;s &#34;externally-facing&#34; addresses (NodePorts, ExternalIPs, and LoadBalancer IPs). If set to &#34;Local&#34;, the proxy will configure the service in a way that assumes that external load balancers will take care of balancing the service traffic between nodes, and so each node will deliver traffic only to the node-local endpoints of the service, without masquerading the client source IP. (Traffic mistakenly sent to a node with no endpoints will be dropped.) The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features). Note that traffic sent to an External IP or LoadBalancer IP from within the cluster will always get &#34;Cluster&#34; semantics, but clients sending to a NodePort from within the cluster may need to take traffic policy into account when picking a node.
     * 
     */
    @Import(name="externalTrafficPolicy")
    private @Nullable Output<String> externalTrafficPolicy;

    /**
     * @return externalTrafficPolicy describes how nodes distribute service traffic they receive on one of the Service&#39;s &#34;externally-facing&#34; addresses (NodePorts, ExternalIPs, and LoadBalancer IPs). If set to &#34;Local&#34;, the proxy will configure the service in a way that assumes that external load balancers will take care of balancing the service traffic between nodes, and so each node will deliver traffic only to the node-local endpoints of the service, without masquerading the client source IP. (Traffic mistakenly sent to a node with no endpoints will be dropped.) The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features). Note that traffic sent to an External IP or LoadBalancer IP from within the cluster will always get &#34;Cluster&#34; semantics, but clients sending to a NodePort from within the cluster may need to take traffic policy into account when picking a node.
     * 
     */
    public Optional<Output<String>> externalTrafficPolicy() {
        return Optional.ofNullable(this.externalTrafficPolicy);
    }

    /**
     * healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type). This field cannot be updated once set.
     * 
     */
    @Import(name="healthCheckNodePort")
    private @Nullable Output<Integer> healthCheckNodePort;

    /**
     * @return healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type). This field cannot be updated once set.
     * 
     */
    public Optional<Output<Integer>> healthCheckNodePort() {
        return Optional.ofNullable(this.healthCheckNodePort);
    }

    /**
     * InternalTrafficPolicy describes how nodes distribute service traffic they receive on the ClusterIP. If set to &#34;Local&#34;, the proxy will assume that pods only want to talk to endpoints of the service on the same node as the pod, dropping the traffic if there are no local endpoints. The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features).
     * 
     */
    @Import(name="internalTrafficPolicy")
    private @Nullable Output<String> internalTrafficPolicy;

    /**
     * @return InternalTrafficPolicy describes how nodes distribute service traffic they receive on the ClusterIP. If set to &#34;Local&#34;, the proxy will assume that pods only want to talk to endpoints of the service on the same node as the pod, dropping the traffic if there are no local endpoints. The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features).
     * 
     */
    public Optional<Output<String>> internalTrafficPolicy() {
        return Optional.ofNullable(this.internalTrafficPolicy);
    }

    /**
     * IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service. This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail. This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service. Valid values are &#34;IPv4&#34; and &#34;IPv6&#34;.  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to &#34;headless&#34; services. This field will be wiped when updating a Service to type ExternalName.
     * 
     * This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
     * 
     */
    @Import(name="ipFamilies")
    private @Nullable Output<List<String>> ipFamilies;

    /**
     * @return IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service. This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail. This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service. Valid values are &#34;IPv4&#34; and &#34;IPv6&#34;.  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to &#34;headless&#34; services. This field will be wiped when updating a Service to type ExternalName.
     * 
     * This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
     * 
     */
    public Optional<Output<List<String>>> ipFamilies() {
        return Optional.ofNullable(this.ipFamilies);
    }

    /**
     * ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is available in the cluster.  If no IP family is requested, the cluster&#39;s primary IP family will be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.
     * 
     */
    @Import(name="ipFamily")
    private @Nullable Output<String> ipFamily;

    /**
     * @return ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is available in the cluster.  If no IP family is requested, the cluster&#39;s primary IP family will be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.
     * 
     */
    public Optional<Output<String>> ipFamily() {
        return Optional.ofNullable(this.ipFamily);
    }

    /**
     * IPFamilyPolicy represents the dual-stack-ness requested or required by this Service. If there is no value provided, then this field will be set to SingleStack. Services can be &#34;SingleStack&#34; (a single IP family), &#34;PreferDualStack&#34; (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or &#34;RequireDualStack&#34; (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field. This field will be wiped when updating a service to type ExternalName.
     * 
     */
    @Import(name="ipFamilyPolicy")
    private @Nullable Output<String> ipFamilyPolicy;

    /**
     * @return IPFamilyPolicy represents the dual-stack-ness requested or required by this Service. If there is no value provided, then this field will be set to SingleStack. Services can be &#34;SingleStack&#34; (a single IP family), &#34;PreferDualStack&#34; (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or &#34;RequireDualStack&#34; (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field. This field will be wiped when updating a service to type ExternalName.
     * 
     */
    public Optional<Output<String>> ipFamilyPolicy() {
        return Optional.ofNullable(this.ipFamilyPolicy);
    }

    /**
     * loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. &#34;internal-vip&#34; or &#34;example.com/internal-vip&#34;. Unprefixed names are reserved for end-users. This field can only be set when the Service type is &#39;LoadBalancer&#39;. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type &#39;LoadBalancer&#39;. Once set, it can not be changed. This field will be wiped when a service is updated to a non &#39;LoadBalancer&#39; type.
     * 
     */
    @Import(name="loadBalancerClass")
    private @Nullable Output<String> loadBalancerClass;

    /**
     * @return loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. &#34;internal-vip&#34; or &#34;example.com/internal-vip&#34;. Unprefixed names are reserved for end-users. This field can only be set when the Service type is &#39;LoadBalancer&#39;. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type &#39;LoadBalancer&#39;. Once set, it can not be changed. This field will be wiped when a service is updated to a non &#39;LoadBalancer&#39; type.
     * 
     */
    public Optional<Output<String>> loadBalancerClass() {
        return Optional.ofNullable(this.loadBalancerClass);
    }

    /**
     * Only applies to Service Type: LoadBalancer. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature. Deprecated: This field was under-specified and its meaning varies across implementations. Using it is non-portable and it may not support dual-stack. Users are encouraged to use implementation-specific annotations when available.
     * 
     */
    @Import(name="loadBalancerIP")
    private @Nullable Output<String> loadBalancerIP;

    /**
     * @return Only applies to Service Type: LoadBalancer. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature. Deprecated: This field was under-specified and its meaning varies across implementations. Using it is non-portable and it may not support dual-stack. Users are encouraged to use implementation-specific annotations when available.
     * 
     */
    public Optional<Output<String>> loadBalancerIP() {
        return Optional.ofNullable(this.loadBalancerIP);
    }

    /**
     * If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.&#34; More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
     * 
     */
    @Import(name="loadBalancerSourceRanges")
    private @Nullable Output<List<String>> loadBalancerSourceRanges;

    /**
     * @return If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.&#34; More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
     * 
     */
    public Optional<Output<List<String>>> loadBalancerSourceRanges() {
        return Optional.ofNullable(this.loadBalancerSourceRanges);
    }

    /**
     * The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    @Import(name="ports")
    private @Nullable Output<List<ServicePortPatchArgs>> ports;

    /**
     * @return The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    public Optional<Output<List<ServicePortPatchArgs>>> ports() {
        return Optional.ofNullable(this.ports);
    }

    /**
     * publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet&#39;s Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered &#34;ready&#34; even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
     * 
     */
    @Import(name="publishNotReadyAddresses")
    private @Nullable Output<Boolean> publishNotReadyAddresses;

    /**
     * @return publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet&#39;s Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered &#34;ready&#34; even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
     * 
     */
    public Optional<Output<Boolean>> publishNotReadyAddresses() {
        return Optional.ofNullable(this.publishNotReadyAddresses);
    }

    /**
     * Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
     * 
     */
    @Import(name="selector")
    private @Nullable Output<Map<String,String>> selector;

    /**
     * @return Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
     * 
     */
    public Optional<Output<Map<String,String>>> selector() {
        return Optional.ofNullable(this.selector);
    }

    /**
     * Supports &#34;ClientIP&#34; and &#34;None&#34;. Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    @Import(name="sessionAffinity")
    private @Nullable Output<String> sessionAffinity;

    /**
     * @return Supports &#34;ClientIP&#34; and &#34;None&#34;. Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    public Optional<Output<String>> sessionAffinity() {
        return Optional.ofNullable(this.sessionAffinity);
    }

    /**
     * sessionAffinityConfig contains the configurations of session affinity.
     * 
     */
    @Import(name="sessionAffinityConfig")
    private @Nullable Output<SessionAffinityConfigPatchArgs> sessionAffinityConfig;

    /**
     * @return sessionAffinityConfig contains the configurations of session affinity.
     * 
     */
    public Optional<Output<SessionAffinityConfigPatchArgs>> sessionAffinityConfig() {
        return Optional.ofNullable(this.sessionAffinityConfig);
    }

    /**
     * topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value &#34;*&#34; may be used to mean &#34;any topology&#34;. This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied.
     * 
     */
    @Import(name="topologyKeys")
    private @Nullable Output<List<String>> topologyKeys;

    /**
     * @return topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value &#34;*&#34; may be used to mean &#34;any topology&#34;. This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied.
     * 
     */
    public Optional<Output<List<String>>> topologyKeys() {
        return Optional.ofNullable(this.topologyKeys);
    }

    /**
     * TrafficDistribution offers a way to express preferences for how traffic is distributed to Service endpoints. Implementations can use this field as a hint, but are not required to guarantee strict adherence. If the field is not set, the implementation will apply its default routing strategy. If set to &#34;PreferClose&#34;, implementations should prioritize endpoints that are topologically close (e.g., same zone). This is an alpha field and requires enabling ServiceTrafficDistribution feature.
     * 
     */
    @Import(name="trafficDistribution")
    private @Nullable Output<String> trafficDistribution;

    /**
     * @return TrafficDistribution offers a way to express preferences for how traffic is distributed to Service endpoints. Implementations can use this field as a hint, but are not required to guarantee strict adherence. If the field is not set, the implementation will apply its default routing strategy. If set to &#34;PreferClose&#34;, implementations should prioritize endpoints that are topologically close (e.g., same zone). This is an alpha field and requires enabling ServiceTrafficDistribution feature.
     * 
     */
    public Optional<Output<String>> trafficDistribution() {
        return Optional.ofNullable(this.trafficDistribution);
    }

    /**
     * type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. &#34;ClusterIP&#34; allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is &#34;None&#34;, no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. &#34;NodePort&#34; builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. &#34;LoadBalancer&#34; builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. &#34;ExternalName&#34; aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
     * 
     */
    @Import(name="type")
    private @Nullable Output<Either<String,ServiceSpecType>> type;

    /**
     * @return type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. &#34;ClusterIP&#34; allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is &#34;None&#34;, no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. &#34;NodePort&#34; builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. &#34;LoadBalancer&#34; builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. &#34;ExternalName&#34; aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
     * 
     */
    public Optional<Output<Either<String,ServiceSpecType>>> type() {
        return Optional.ofNullable(this.type);
    }

    private ServiceSpecPatchArgs() {}

    private ServiceSpecPatchArgs(ServiceSpecPatchArgs $) {
        this.allocateLoadBalancerNodePorts = $.allocateLoadBalancerNodePorts;
        this.clusterIP = $.clusterIP;
        this.clusterIPs = $.clusterIPs;
        this.externalIPs = $.externalIPs;
        this.externalName = $.externalName;
        this.externalTrafficPolicy = $.externalTrafficPolicy;
        this.healthCheckNodePort = $.healthCheckNodePort;
        this.internalTrafficPolicy = $.internalTrafficPolicy;
        this.ipFamilies = $.ipFamilies;
        this.ipFamily = $.ipFamily;
        this.ipFamilyPolicy = $.ipFamilyPolicy;
        this.loadBalancerClass = $.loadBalancerClass;
        this.loadBalancerIP = $.loadBalancerIP;
        this.loadBalancerSourceRanges = $.loadBalancerSourceRanges;
        this.ports = $.ports;
        this.publishNotReadyAddresses = $.publishNotReadyAddresses;
        this.selector = $.selector;
        this.sessionAffinity = $.sessionAffinity;
        this.sessionAffinityConfig = $.sessionAffinityConfig;
        this.topologyKeys = $.topologyKeys;
        this.trafficDistribution = $.trafficDistribution;
        this.type = $.type;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ServiceSpecPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ServiceSpecPatchArgs $;

        public Builder() {
            $ = new ServiceSpecPatchArgs();
        }

        public Builder(ServiceSpecPatchArgs defaults) {
            $ = new ServiceSpecPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allocateLoadBalancerNodePorts allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is &#34;true&#34;. It may be set to &#34;false&#34; if the cluster load-balancer does not rely on NodePorts.  If the caller requests specific NodePorts (by specifying a value), those requests will be respected, regardless of this field. This field may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type.
         * 
         * @return builder
         * 
         */
        public Builder allocateLoadBalancerNodePorts(@Nullable Output<Boolean> allocateLoadBalancerNodePorts) {
            $.allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts;
            return this;
        }

        /**
         * @param allocateLoadBalancerNodePorts allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is &#34;true&#34;. It may be set to &#34;false&#34; if the cluster load-balancer does not rely on NodePorts.  If the caller requests specific NodePorts (by specifying a value), those requests will be respected, regardless of this field. This field may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type.
         * 
         * @return builder
         * 
         */
        public Builder allocateLoadBalancerNodePorts(Boolean allocateLoadBalancerNodePorts) {
            return allocateLoadBalancerNodePorts(Output.of(allocateLoadBalancerNodePorts));
        }

        /**
         * @param clusterIP clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address. Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * 
         * @return builder
         * 
         */
        public Builder clusterIP(@Nullable Output<String> clusterIP) {
            $.clusterIP = clusterIP;
            return this;
        }

        /**
         * @param clusterIP clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address. Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * 
         * @return builder
         * 
         */
        public Builder clusterIP(String clusterIP) {
            return clusterIP(Output.of(clusterIP));
        }

        /**
         * @param clusterIPs ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address.  Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.
         * 
         * This field may hold a maximum of two entries (dual-stack IPs, in either order). These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * 
         * @return builder
         * 
         */
        public Builder clusterIPs(@Nullable Output<List<String>> clusterIPs) {
            $.clusterIPs = clusterIPs;
            return this;
        }

        /**
         * @param clusterIPs ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address.  Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.
         * 
         * This field may hold a maximum of two entries (dual-stack IPs, in either order). These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * 
         * @return builder
         * 
         */
        public Builder clusterIPs(List<String> clusterIPs) {
            return clusterIPs(Output.of(clusterIPs));
        }

        /**
         * @param clusterIPs ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address.  Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.
         * 
         * This field may hold a maximum of two entries (dual-stack IPs, in either order). These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * 
         * @return builder
         * 
         */
        public Builder clusterIPs(String... clusterIPs) {
            return clusterIPs(List.of(clusterIPs));
        }

        /**
         * @param externalIPs externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
         * 
         * @return builder
         * 
         */
        public Builder externalIPs(@Nullable Output<List<String>> externalIPs) {
            $.externalIPs = externalIPs;
            return this;
        }

        /**
         * @param externalIPs externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
         * 
         * @return builder
         * 
         */
        public Builder externalIPs(List<String> externalIPs) {
            return externalIPs(Output.of(externalIPs));
        }

        /**
         * @param externalIPs externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
         * 
         * @return builder
         * 
         */
        public Builder externalIPs(String... externalIPs) {
            return externalIPs(List.of(externalIPs));
        }

        /**
         * @param externalName externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be &#34;ExternalName&#34;.
         * 
         * @return builder
         * 
         */
        public Builder externalName(@Nullable Output<String> externalName) {
            $.externalName = externalName;
            return this;
        }

        /**
         * @param externalName externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be &#34;ExternalName&#34;.
         * 
         * @return builder
         * 
         */
        public Builder externalName(String externalName) {
            return externalName(Output.of(externalName));
        }

        /**
         * @param externalTrafficPolicy externalTrafficPolicy describes how nodes distribute service traffic they receive on one of the Service&#39;s &#34;externally-facing&#34; addresses (NodePorts, ExternalIPs, and LoadBalancer IPs). If set to &#34;Local&#34;, the proxy will configure the service in a way that assumes that external load balancers will take care of balancing the service traffic between nodes, and so each node will deliver traffic only to the node-local endpoints of the service, without masquerading the client source IP. (Traffic mistakenly sent to a node with no endpoints will be dropped.) The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features). Note that traffic sent to an External IP or LoadBalancer IP from within the cluster will always get &#34;Cluster&#34; semantics, but clients sending to a NodePort from within the cluster may need to take traffic policy into account when picking a node.
         * 
         * @return builder
         * 
         */
        public Builder externalTrafficPolicy(@Nullable Output<String> externalTrafficPolicy) {
            $.externalTrafficPolicy = externalTrafficPolicy;
            return this;
        }

        /**
         * @param externalTrafficPolicy externalTrafficPolicy describes how nodes distribute service traffic they receive on one of the Service&#39;s &#34;externally-facing&#34; addresses (NodePorts, ExternalIPs, and LoadBalancer IPs). If set to &#34;Local&#34;, the proxy will configure the service in a way that assumes that external load balancers will take care of balancing the service traffic between nodes, and so each node will deliver traffic only to the node-local endpoints of the service, without masquerading the client source IP. (Traffic mistakenly sent to a node with no endpoints will be dropped.) The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features). Note that traffic sent to an External IP or LoadBalancer IP from within the cluster will always get &#34;Cluster&#34; semantics, but clients sending to a NodePort from within the cluster may need to take traffic policy into account when picking a node.
         * 
         * @return builder
         * 
         */
        public Builder externalTrafficPolicy(String externalTrafficPolicy) {
            return externalTrafficPolicy(Output.of(externalTrafficPolicy));
        }

        /**
         * @param healthCheckNodePort healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type). This field cannot be updated once set.
         * 
         * @return builder
         * 
         */
        public Builder healthCheckNodePort(@Nullable Output<Integer> healthCheckNodePort) {
            $.healthCheckNodePort = healthCheckNodePort;
            return this;
        }

        /**
         * @param healthCheckNodePort healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type). This field cannot be updated once set.
         * 
         * @return builder
         * 
         */
        public Builder healthCheckNodePort(Integer healthCheckNodePort) {
            return healthCheckNodePort(Output.of(healthCheckNodePort));
        }

        /**
         * @param internalTrafficPolicy InternalTrafficPolicy describes how nodes distribute service traffic they receive on the ClusterIP. If set to &#34;Local&#34;, the proxy will assume that pods only want to talk to endpoints of the service on the same node as the pod, dropping the traffic if there are no local endpoints. The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features).
         * 
         * @return builder
         * 
         */
        public Builder internalTrafficPolicy(@Nullable Output<String> internalTrafficPolicy) {
            $.internalTrafficPolicy = internalTrafficPolicy;
            return this;
        }

        /**
         * @param internalTrafficPolicy InternalTrafficPolicy describes how nodes distribute service traffic they receive on the ClusterIP. If set to &#34;Local&#34;, the proxy will assume that pods only want to talk to endpoints of the service on the same node as the pod, dropping the traffic if there are no local endpoints. The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features).
         * 
         * @return builder
         * 
         */
        public Builder internalTrafficPolicy(String internalTrafficPolicy) {
            return internalTrafficPolicy(Output.of(internalTrafficPolicy));
        }

        /**
         * @param ipFamilies IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service. This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail. This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service. Valid values are &#34;IPv4&#34; and &#34;IPv6&#34;.  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to &#34;headless&#34; services. This field will be wiped when updating a Service to type ExternalName.
         * 
         * This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
         * 
         * @return builder
         * 
         */
        public Builder ipFamilies(@Nullable Output<List<String>> ipFamilies) {
            $.ipFamilies = ipFamilies;
            return this;
        }

        /**
         * @param ipFamilies IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service. This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail. This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service. Valid values are &#34;IPv4&#34; and &#34;IPv6&#34;.  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to &#34;headless&#34; services. This field will be wiped when updating a Service to type ExternalName.
         * 
         * This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
         * 
         * @return builder
         * 
         */
        public Builder ipFamilies(List<String> ipFamilies) {
            return ipFamilies(Output.of(ipFamilies));
        }

        /**
         * @param ipFamilies IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service. This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail. This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service. Valid values are &#34;IPv4&#34; and &#34;IPv6&#34;.  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to &#34;headless&#34; services. This field will be wiped when updating a Service to type ExternalName.
         * 
         * This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
         * 
         * @return builder
         * 
         */
        public Builder ipFamilies(String... ipFamilies) {
            return ipFamilies(List.of(ipFamilies));
        }

        /**
         * @param ipFamily ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is available in the cluster.  If no IP family is requested, the cluster&#39;s primary IP family will be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.
         * 
         * @return builder
         * 
         */
        public Builder ipFamily(@Nullable Output<String> ipFamily) {
            $.ipFamily = ipFamily;
            return this;
        }

        /**
         * @param ipFamily ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is available in the cluster.  If no IP family is requested, the cluster&#39;s primary IP family will be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.
         * 
         * @return builder
         * 
         */
        public Builder ipFamily(String ipFamily) {
            return ipFamily(Output.of(ipFamily));
        }

        /**
         * @param ipFamilyPolicy IPFamilyPolicy represents the dual-stack-ness requested or required by this Service. If there is no value provided, then this field will be set to SingleStack. Services can be &#34;SingleStack&#34; (a single IP family), &#34;PreferDualStack&#34; (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or &#34;RequireDualStack&#34; (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field. This field will be wiped when updating a service to type ExternalName.
         * 
         * @return builder
         * 
         */
        public Builder ipFamilyPolicy(@Nullable Output<String> ipFamilyPolicy) {
            $.ipFamilyPolicy = ipFamilyPolicy;
            return this;
        }

        /**
         * @param ipFamilyPolicy IPFamilyPolicy represents the dual-stack-ness requested or required by this Service. If there is no value provided, then this field will be set to SingleStack. Services can be &#34;SingleStack&#34; (a single IP family), &#34;PreferDualStack&#34; (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or &#34;RequireDualStack&#34; (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field. This field will be wiped when updating a service to type ExternalName.
         * 
         * @return builder
         * 
         */
        public Builder ipFamilyPolicy(String ipFamilyPolicy) {
            return ipFamilyPolicy(Output.of(ipFamilyPolicy));
        }

        /**
         * @param loadBalancerClass loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. &#34;internal-vip&#34; or &#34;example.com/internal-vip&#34;. Unprefixed names are reserved for end-users. This field can only be set when the Service type is &#39;LoadBalancer&#39;. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type &#39;LoadBalancer&#39;. Once set, it can not be changed. This field will be wiped when a service is updated to a non &#39;LoadBalancer&#39; type.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancerClass(@Nullable Output<String> loadBalancerClass) {
            $.loadBalancerClass = loadBalancerClass;
            return this;
        }

        /**
         * @param loadBalancerClass loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. &#34;internal-vip&#34; or &#34;example.com/internal-vip&#34;. Unprefixed names are reserved for end-users. This field can only be set when the Service type is &#39;LoadBalancer&#39;. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type &#39;LoadBalancer&#39;. Once set, it can not be changed. This field will be wiped when a service is updated to a non &#39;LoadBalancer&#39; type.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancerClass(String loadBalancerClass) {
            return loadBalancerClass(Output.of(loadBalancerClass));
        }

        /**
         * @param loadBalancerIP Only applies to Service Type: LoadBalancer. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature. Deprecated: This field was under-specified and its meaning varies across implementations. Using it is non-portable and it may not support dual-stack. Users are encouraged to use implementation-specific annotations when available.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancerIP(@Nullable Output<String> loadBalancerIP) {
            $.loadBalancerIP = loadBalancerIP;
            return this;
        }

        /**
         * @param loadBalancerIP Only applies to Service Type: LoadBalancer. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature. Deprecated: This field was under-specified and its meaning varies across implementations. Using it is non-portable and it may not support dual-stack. Users are encouraged to use implementation-specific annotations when available.
         * 
         * @return builder
         * 
         */
        public Builder loadBalancerIP(String loadBalancerIP) {
            return loadBalancerIP(Output.of(loadBalancerIP));
        }

        /**
         * @param loadBalancerSourceRanges If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.&#34; More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
         * 
         * @return builder
         * 
         */
        public Builder loadBalancerSourceRanges(@Nullable Output<List<String>> loadBalancerSourceRanges) {
            $.loadBalancerSourceRanges = loadBalancerSourceRanges;
            return this;
        }

        /**
         * @param loadBalancerSourceRanges If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.&#34; More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
         * 
         * @return builder
         * 
         */
        public Builder loadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
            return loadBalancerSourceRanges(Output.of(loadBalancerSourceRanges));
        }

        /**
         * @param loadBalancerSourceRanges If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.&#34; More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
         * 
         * @return builder
         * 
         */
        public Builder loadBalancerSourceRanges(String... loadBalancerSourceRanges) {
            return loadBalancerSourceRanges(List.of(loadBalancerSourceRanges));
        }

        /**
         * @param ports The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * 
         * @return builder
         * 
         */
        public Builder ports(@Nullable Output<List<ServicePortPatchArgs>> ports) {
            $.ports = ports;
            return this;
        }

        /**
         * @param ports The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * 
         * @return builder
         * 
         */
        public Builder ports(List<ServicePortPatchArgs> ports) {
            return ports(Output.of(ports));
        }

        /**
         * @param ports The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * 
         * @return builder
         * 
         */
        public Builder ports(ServicePortPatchArgs... ports) {
            return ports(List.of(ports));
        }

        /**
         * @param publishNotReadyAddresses publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet&#39;s Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered &#34;ready&#34; even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
         * 
         * @return builder
         * 
         */
        public Builder publishNotReadyAddresses(@Nullable Output<Boolean> publishNotReadyAddresses) {
            $.publishNotReadyAddresses = publishNotReadyAddresses;
            return this;
        }

        /**
         * @param publishNotReadyAddresses publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet&#39;s Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered &#34;ready&#34; even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
         * 
         * @return builder
         * 
         */
        public Builder publishNotReadyAddresses(Boolean publishNotReadyAddresses) {
            return publishNotReadyAddresses(Output.of(publishNotReadyAddresses));
        }

        /**
         * @param selector Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
         * 
         * @return builder
         * 
         */
        public Builder selector(@Nullable Output<Map<String,String>> selector) {
            $.selector = selector;
            return this;
        }

        /**
         * @param selector Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
         * 
         * @return builder
         * 
         */
        public Builder selector(Map<String,String> selector) {
            return selector(Output.of(selector));
        }

        /**
         * @param sessionAffinity Supports &#34;ClientIP&#34; and &#34;None&#34;. Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * 
         * @return builder
         * 
         */
        public Builder sessionAffinity(@Nullable Output<String> sessionAffinity) {
            $.sessionAffinity = sessionAffinity;
            return this;
        }

        /**
         * @param sessionAffinity Supports &#34;ClientIP&#34; and &#34;None&#34;. Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
         * 
         * @return builder
         * 
         */
        public Builder sessionAffinity(String sessionAffinity) {
            return sessionAffinity(Output.of(sessionAffinity));
        }

        /**
         * @param sessionAffinityConfig sessionAffinityConfig contains the configurations of session affinity.
         * 
         * @return builder
         * 
         */
        public Builder sessionAffinityConfig(@Nullable Output<SessionAffinityConfigPatchArgs> sessionAffinityConfig) {
            $.sessionAffinityConfig = sessionAffinityConfig;
            return this;
        }

        /**
         * @param sessionAffinityConfig sessionAffinityConfig contains the configurations of session affinity.
         * 
         * @return builder
         * 
         */
        public Builder sessionAffinityConfig(SessionAffinityConfigPatchArgs sessionAffinityConfig) {
            return sessionAffinityConfig(Output.of(sessionAffinityConfig));
        }

        /**
         * @param topologyKeys topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value &#34;*&#34; may be used to mean &#34;any topology&#34;. This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied.
         * 
         * @return builder
         * 
         */
        public Builder topologyKeys(@Nullable Output<List<String>> topologyKeys) {
            $.topologyKeys = topologyKeys;
            return this;
        }

        /**
         * @param topologyKeys topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value &#34;*&#34; may be used to mean &#34;any topology&#34;. This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied.
         * 
         * @return builder
         * 
         */
        public Builder topologyKeys(List<String> topologyKeys) {
            return topologyKeys(Output.of(topologyKeys));
        }

        /**
         * @param topologyKeys topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value &#34;*&#34; may be used to mean &#34;any topology&#34;. This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied.
         * 
         * @return builder
         * 
         */
        public Builder topologyKeys(String... topologyKeys) {
            return topologyKeys(List.of(topologyKeys));
        }

        /**
         * @param trafficDistribution TrafficDistribution offers a way to express preferences for how traffic is distributed to Service endpoints. Implementations can use this field as a hint, but are not required to guarantee strict adherence. If the field is not set, the implementation will apply its default routing strategy. If set to &#34;PreferClose&#34;, implementations should prioritize endpoints that are topologically close (e.g., same zone). This is an alpha field and requires enabling ServiceTrafficDistribution feature.
         * 
         * @return builder
         * 
         */
        public Builder trafficDistribution(@Nullable Output<String> trafficDistribution) {
            $.trafficDistribution = trafficDistribution;
            return this;
        }

        /**
         * @param trafficDistribution TrafficDistribution offers a way to express preferences for how traffic is distributed to Service endpoints. Implementations can use this field as a hint, but are not required to guarantee strict adherence. If the field is not set, the implementation will apply its default routing strategy. If set to &#34;PreferClose&#34;, implementations should prioritize endpoints that are topologically close (e.g., same zone). This is an alpha field and requires enabling ServiceTrafficDistribution feature.
         * 
         * @return builder
         * 
         */
        public Builder trafficDistribution(String trafficDistribution) {
            return trafficDistribution(Output.of(trafficDistribution));
        }

        /**
         * @param type type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. &#34;ClusterIP&#34; allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is &#34;None&#34;, no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. &#34;NodePort&#34; builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. &#34;LoadBalancer&#34; builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. &#34;ExternalName&#34; aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
         * 
         * @return builder
         * 
         */
        public Builder type(@Nullable Output<Either<String,ServiceSpecType>> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. &#34;ClusterIP&#34; allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is &#34;None&#34;, no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. &#34;NodePort&#34; builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. &#34;LoadBalancer&#34; builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. &#34;ExternalName&#34; aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
         * 
         * @return builder
         * 
         */
        public Builder type(Either<String,ServiceSpecType> type) {
            return type(Output.of(type));
        }

        /**
         * @param type type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. &#34;ClusterIP&#34; allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is &#34;None&#34;, no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. &#34;NodePort&#34; builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. &#34;LoadBalancer&#34; builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. &#34;ExternalName&#34; aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Either.ofLeft(type));
        }

        /**
         * @param type type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. &#34;ClusterIP&#34; allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is &#34;None&#34;, no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. &#34;NodePort&#34; builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. &#34;LoadBalancer&#34; builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. &#34;ExternalName&#34; aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
         * 
         * @return builder
         * 
         */
        public Builder type(ServiceSpecType type) {
            return type(Either.ofRight(type));
        }

        public ServiceSpecPatchArgs build() {
            return $;
        }
    }

}
