// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.inputs.AWSElasticBlockStoreVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.AzureDiskVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.AzureFileVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.CSIVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.CephFSVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.CinderVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.ConfigMapVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.DownwardAPIVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.EmptyDirVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.EphemeralVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.FCVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.FlexVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.FlockerVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.GCEPersistentDiskVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.GitRepoVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.GlusterfsVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.HostPathVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.ISCSIVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.ImageVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.NFSVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.PersistentVolumeClaimVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.PhotonPersistentDiskVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.PortworxVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.ProjectedVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.QuobyteVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.RBDVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.ScaleIOVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.SecretVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.StorageOSVolumeSourceArgs;
import com.pulumi.kubernetes.core.v1.inputs.VsphereVirtualDiskVolumeSourceArgs;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * Volume represents a named volume in a pod that may be accessed by any container in the pod.
 * 
 */
public final class VolumeArgs extends com.pulumi.resources.ResourceArgs {

    public static final VolumeArgs Empty = new VolumeArgs();

    /**
     * awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
     * 
     */
    @Import(name="awsElasticBlockStore")
    private @Nullable Output<AWSElasticBlockStoreVolumeSourceArgs> awsElasticBlockStore;

    /**
     * @return awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
     * 
     */
    public Optional<Output<AWSElasticBlockStoreVolumeSourceArgs>> awsElasticBlockStore() {
        return Optional.ofNullable(this.awsElasticBlockStore);
    }

    /**
     * azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
     * 
     */
    @Import(name="azureDisk")
    private @Nullable Output<AzureDiskVolumeSourceArgs> azureDisk;

    /**
     * @return azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
     * 
     */
    public Optional<Output<AzureDiskVolumeSourceArgs>> azureDisk() {
        return Optional.ofNullable(this.azureDisk);
    }

    /**
     * azureFile represents an Azure File Service mount on the host and bind mount to the pod.
     * 
     */
    @Import(name="azureFile")
    private @Nullable Output<AzureFileVolumeSourceArgs> azureFile;

    /**
     * @return azureFile represents an Azure File Service mount on the host and bind mount to the pod.
     * 
     */
    public Optional<Output<AzureFileVolumeSourceArgs>> azureFile() {
        return Optional.ofNullable(this.azureFile);
    }

    /**
     * cephFS represents a Ceph FS mount on the host that shares a pod&#39;s lifetime
     * 
     */
    @Import(name="cephfs")
    private @Nullable Output<CephFSVolumeSourceArgs> cephfs;

    /**
     * @return cephFS represents a Ceph FS mount on the host that shares a pod&#39;s lifetime
     * 
     */
    public Optional<Output<CephFSVolumeSourceArgs>> cephfs() {
        return Optional.ofNullable(this.cephfs);
    }

    /**
     * cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     * 
     */
    @Import(name="cinder")
    private @Nullable Output<CinderVolumeSourceArgs> cinder;

    /**
     * @return cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     * 
     */
    public Optional<Output<CinderVolumeSourceArgs>> cinder() {
        return Optional.ofNullable(this.cinder);
    }

    /**
     * configMap represents a configMap that should populate this volume
     * 
     */
    @Import(name="configMap")
    private @Nullable Output<ConfigMapVolumeSourceArgs> configMap;

    /**
     * @return configMap represents a configMap that should populate this volume
     * 
     */
    public Optional<Output<ConfigMapVolumeSourceArgs>> configMap() {
        return Optional.ofNullable(this.configMap);
    }

    /**
     * csi (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).
     * 
     */
    @Import(name="csi")
    private @Nullable Output<CSIVolumeSourceArgs> csi;

    /**
     * @return csi (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).
     * 
     */
    public Optional<Output<CSIVolumeSourceArgs>> csi() {
        return Optional.ofNullable(this.csi);
    }

    /**
     * downwardAPI represents downward API about the pod that should populate this volume
     * 
     */
    @Import(name="downwardAPI")
    private @Nullable Output<DownwardAPIVolumeSourceArgs> downwardAPI;

    /**
     * @return downwardAPI represents downward API about the pod that should populate this volume
     * 
     */
    public Optional<Output<DownwardAPIVolumeSourceArgs>> downwardAPI() {
        return Optional.ofNullable(this.downwardAPI);
    }

    /**
     * emptyDir represents a temporary directory that shares a pod&#39;s lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
     * 
     */
    @Import(name="emptyDir")
    private @Nullable Output<EmptyDirVolumeSourceArgs> emptyDir;

    /**
     * @return emptyDir represents a temporary directory that shares a pod&#39;s lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
     * 
     */
    public Optional<Output<EmptyDirVolumeSourceArgs>> emptyDir() {
        return Optional.ofNullable(this.emptyDir);
    }

    /**
     * ephemeral represents a volume that is handled by a cluster storage driver. The volume&#39;s lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.
     * 
     * Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity
     *    tracking are needed,
     * c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through
     *    a PersistentVolumeClaim (see EphemeralVolumeSource for more
     *    information on the connection between this volume type
     *    and PersistentVolumeClaim).
     * 
     * Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.
     * 
     * Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.
     * 
     * A pod can use both types of ephemeral volumes and persistent volumes at the same time.
     * 
     */
    @Import(name="ephemeral")
    private @Nullable Output<EphemeralVolumeSourceArgs> ephemeral;

    /**
     * @return ephemeral represents a volume that is handled by a cluster storage driver. The volume&#39;s lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.
     * 
     * Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity
     *    tracking are needed,
     * c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through
     *    a PersistentVolumeClaim (see EphemeralVolumeSource for more
     *    information on the connection between this volume type
     *    and PersistentVolumeClaim).
     * 
     * Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.
     * 
     * Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.
     * 
     * A pod can use both types of ephemeral volumes and persistent volumes at the same time.
     * 
     */
    public Optional<Output<EphemeralVolumeSourceArgs>> ephemeral() {
        return Optional.ofNullable(this.ephemeral);
    }

    /**
     * fc represents a Fibre Channel resource that is attached to a kubelet&#39;s host machine and then exposed to the pod.
     * 
     */
    @Import(name="fc")
    private @Nullable Output<FCVolumeSourceArgs> fc;

    /**
     * @return fc represents a Fibre Channel resource that is attached to a kubelet&#39;s host machine and then exposed to the pod.
     * 
     */
    public Optional<Output<FCVolumeSourceArgs>> fc() {
        return Optional.ofNullable(this.fc);
    }

    /**
     * flexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
     * 
     */
    @Import(name="flexVolume")
    private @Nullable Output<FlexVolumeSourceArgs> flexVolume;

    /**
     * @return flexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
     * 
     */
    public Optional<Output<FlexVolumeSourceArgs>> flexVolume() {
        return Optional.ofNullable(this.flexVolume);
    }

    /**
     * flocker represents a Flocker volume attached to a kubelet&#39;s host machine. This depends on the Flocker control service being running
     * 
     */
    @Import(name="flocker")
    private @Nullable Output<FlockerVolumeSourceArgs> flocker;

    /**
     * @return flocker represents a Flocker volume attached to a kubelet&#39;s host machine. This depends on the Flocker control service being running
     * 
     */
    public Optional<Output<FlockerVolumeSourceArgs>> flocker() {
        return Optional.ofNullable(this.flocker);
    }

    /**
     * gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     * 
     */
    @Import(name="gcePersistentDisk")
    private @Nullable Output<GCEPersistentDiskVolumeSourceArgs> gcePersistentDisk;

    /**
     * @return gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     * 
     */
    public Optional<Output<GCEPersistentDiskVolumeSourceArgs>> gcePersistentDisk() {
        return Optional.ofNullable(this.gcePersistentDisk);
    }

    /**
     * gitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod&#39;s container.
     * 
     */
    @Import(name="gitRepo")
    private @Nullable Output<GitRepoVolumeSourceArgs> gitRepo;

    /**
     * @return gitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod&#39;s container.
     * 
     */
    public Optional<Output<GitRepoVolumeSourceArgs>> gitRepo() {
        return Optional.ofNullable(this.gitRepo);
    }

    /**
     * glusterfs represents a Glusterfs mount on the host that shares a pod&#39;s lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md
     * 
     */
    @Import(name="glusterfs")
    private @Nullable Output<GlusterfsVolumeSourceArgs> glusterfs;

    /**
     * @return glusterfs represents a Glusterfs mount on the host that shares a pod&#39;s lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md
     * 
     */
    public Optional<Output<GlusterfsVolumeSourceArgs>> glusterfs() {
        return Optional.ofNullable(this.glusterfs);
    }

    /**
     * hostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
     * 
     */
    @Import(name="hostPath")
    private @Nullable Output<HostPathVolumeSourceArgs> hostPath;

    /**
     * @return hostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
     * 
     */
    public Optional<Output<HostPathVolumeSourceArgs>> hostPath() {
        return Optional.ofNullable(this.hostPath);
    }

    /**
     * image represents an OCI object (a container image or artifact) pulled and mounted on the kubelet&#39;s host machine. The volume is resolved at pod startup depending on which PullPolicy value is provided:
     * 
     * - Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. - Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn&#39;t present. - IfNotPresent: the kubelet pulls if the reference isn&#39;t already present on disk. Container creation will fail if the reference isn&#39;t present and the pull fails.
     * 
     * The volume gets re-resolved if the pod gets deleted and recreated, which means that new remote content will become available on pod recreation. A failure to resolve or pull the image during pod startup will block containers from starting and may add significant latency. Failures will be retried using normal volume backoff and will be reported on the pod reason and message. The types of objects that may be mounted by this volume are defined by the container runtime implementation on a host machine and at minimum must include all valid types supported by the container image field. The OCI object gets mounted in a single directory (spec.containers[*].volumeMounts.mountPath) by merging the manifest layers in the same way as for container images. The volume will be mounted read-only (ro) and non-executable files (noexec). Sub path mounts for containers are not supported (spec.containers[*].volumeMounts.subpath). The field spec.securityContext.fsGroupChangePolicy has no effect on this volume type.
     * 
     */
    @Import(name="image")
    private @Nullable Output<ImageVolumeSourceArgs> image;

    /**
     * @return image represents an OCI object (a container image or artifact) pulled and mounted on the kubelet&#39;s host machine. The volume is resolved at pod startup depending on which PullPolicy value is provided:
     * 
     * - Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. - Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn&#39;t present. - IfNotPresent: the kubelet pulls if the reference isn&#39;t already present on disk. Container creation will fail if the reference isn&#39;t present and the pull fails.
     * 
     * The volume gets re-resolved if the pod gets deleted and recreated, which means that new remote content will become available on pod recreation. A failure to resolve or pull the image during pod startup will block containers from starting and may add significant latency. Failures will be retried using normal volume backoff and will be reported on the pod reason and message. The types of objects that may be mounted by this volume are defined by the container runtime implementation on a host machine and at minimum must include all valid types supported by the container image field. The OCI object gets mounted in a single directory (spec.containers[*].volumeMounts.mountPath) by merging the manifest layers in the same way as for container images. The volume will be mounted read-only (ro) and non-executable files (noexec). Sub path mounts for containers are not supported (spec.containers[*].volumeMounts.subpath). The field spec.securityContext.fsGroupChangePolicy has no effect on this volume type.
     * 
     */
    public Optional<Output<ImageVolumeSourceArgs>> image() {
        return Optional.ofNullable(this.image);
    }

    /**
     * iscsi represents an ISCSI Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md
     * 
     */
    @Import(name="iscsi")
    private @Nullable Output<ISCSIVolumeSourceArgs> iscsi;

    /**
     * @return iscsi represents an ISCSI Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md
     * 
     */
    public Optional<Output<ISCSIVolumeSourceArgs>> iscsi() {
        return Optional.ofNullable(this.iscsi);
    }

    /**
     * name of the volume. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
     * 
     */
    @Import(name="name", required=true)
    private Output<String> name;

    /**
     * @return name of the volume. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     * nfs represents an NFS mount on the host that shares a pod&#39;s lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     * 
     */
    @Import(name="nfs")
    private @Nullable Output<NFSVolumeSourceArgs> nfs;

    /**
     * @return nfs represents an NFS mount on the host that shares a pod&#39;s lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     * 
     */
    public Optional<Output<NFSVolumeSourceArgs>> nfs() {
        return Optional.ofNullable(this.nfs);
    }

    /**
     * persistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
     * 
     */
    @Import(name="persistentVolumeClaim")
    private @Nullable Output<PersistentVolumeClaimVolumeSourceArgs> persistentVolumeClaim;

    /**
     * @return persistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
     * 
     */
    public Optional<Output<PersistentVolumeClaimVolumeSourceArgs>> persistentVolumeClaim() {
        return Optional.ofNullable(this.persistentVolumeClaim);
    }

    /**
     * photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
     * 
     */
    @Import(name="photonPersistentDisk")
    private @Nullable Output<PhotonPersistentDiskVolumeSourceArgs> photonPersistentDisk;

    /**
     * @return photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
     * 
     */
    public Optional<Output<PhotonPersistentDiskVolumeSourceArgs>> photonPersistentDisk() {
        return Optional.ofNullable(this.photonPersistentDisk);
    }

    /**
     * portworxVolume represents a portworx volume attached and mounted on kubelets host machine
     * 
     */
    @Import(name="portworxVolume")
    private @Nullable Output<PortworxVolumeSourceArgs> portworxVolume;

    /**
     * @return portworxVolume represents a portworx volume attached and mounted on kubelets host machine
     * 
     */
    public Optional<Output<PortworxVolumeSourceArgs>> portworxVolume() {
        return Optional.ofNullable(this.portworxVolume);
    }

    /**
     * projected items for all in one resources secrets, configmaps, and downward API
     * 
     */
    @Import(name="projected")
    private @Nullable Output<ProjectedVolumeSourceArgs> projected;

    /**
     * @return projected items for all in one resources secrets, configmaps, and downward API
     * 
     */
    public Optional<Output<ProjectedVolumeSourceArgs>> projected() {
        return Optional.ofNullable(this.projected);
    }

    /**
     * quobyte represents a Quobyte mount on the host that shares a pod&#39;s lifetime
     * 
     */
    @Import(name="quobyte")
    private @Nullable Output<QuobyteVolumeSourceArgs> quobyte;

    /**
     * @return quobyte represents a Quobyte mount on the host that shares a pod&#39;s lifetime
     * 
     */
    public Optional<Output<QuobyteVolumeSourceArgs>> quobyte() {
        return Optional.ofNullable(this.quobyte);
    }

    /**
     * rbd represents a Rados Block Device mount on the host that shares a pod&#39;s lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
     * 
     */
    @Import(name="rbd")
    private @Nullable Output<RBDVolumeSourceArgs> rbd;

    /**
     * @return rbd represents a Rados Block Device mount on the host that shares a pod&#39;s lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
     * 
     */
    public Optional<Output<RBDVolumeSourceArgs>> rbd() {
        return Optional.ofNullable(this.rbd);
    }

    /**
     * scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
     * 
     */
    @Import(name="scaleIO")
    private @Nullable Output<ScaleIOVolumeSourceArgs> scaleIO;

    /**
     * @return scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
     * 
     */
    public Optional<Output<ScaleIOVolumeSourceArgs>> scaleIO() {
        return Optional.ofNullable(this.scaleIO);
    }

    /**
     * secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
     * 
     */
    @Import(name="secret")
    private @Nullable Output<SecretVolumeSourceArgs> secret;

    /**
     * @return secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
     * 
     */
    public Optional<Output<SecretVolumeSourceArgs>> secret() {
        return Optional.ofNullable(this.secret);
    }

    /**
     * storageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
     * 
     */
    @Import(name="storageos")
    private @Nullable Output<StorageOSVolumeSourceArgs> storageos;

    /**
     * @return storageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
     * 
     */
    public Optional<Output<StorageOSVolumeSourceArgs>> storageos() {
        return Optional.ofNullable(this.storageos);
    }

    /**
     * vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
     * 
     */
    @Import(name="vsphereVolume")
    private @Nullable Output<VsphereVirtualDiskVolumeSourceArgs> vsphereVolume;

    /**
     * @return vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
     * 
     */
    public Optional<Output<VsphereVirtualDiskVolumeSourceArgs>> vsphereVolume() {
        return Optional.ofNullable(this.vsphereVolume);
    }

    private VolumeArgs() {}

    private VolumeArgs(VolumeArgs $) {
        this.awsElasticBlockStore = $.awsElasticBlockStore;
        this.azureDisk = $.azureDisk;
        this.azureFile = $.azureFile;
        this.cephfs = $.cephfs;
        this.cinder = $.cinder;
        this.configMap = $.configMap;
        this.csi = $.csi;
        this.downwardAPI = $.downwardAPI;
        this.emptyDir = $.emptyDir;
        this.ephemeral = $.ephemeral;
        this.fc = $.fc;
        this.flexVolume = $.flexVolume;
        this.flocker = $.flocker;
        this.gcePersistentDisk = $.gcePersistentDisk;
        this.gitRepo = $.gitRepo;
        this.glusterfs = $.glusterfs;
        this.hostPath = $.hostPath;
        this.image = $.image;
        this.iscsi = $.iscsi;
        this.name = $.name;
        this.nfs = $.nfs;
        this.persistentVolumeClaim = $.persistentVolumeClaim;
        this.photonPersistentDisk = $.photonPersistentDisk;
        this.portworxVolume = $.portworxVolume;
        this.projected = $.projected;
        this.quobyte = $.quobyte;
        this.rbd = $.rbd;
        this.scaleIO = $.scaleIO;
        this.secret = $.secret;
        this.storageos = $.storageos;
        this.vsphereVolume = $.vsphereVolume;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(VolumeArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VolumeArgs $;

        public Builder() {
            $ = new VolumeArgs();
        }

        public Builder(VolumeArgs defaults) {
            $ = new VolumeArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param awsElasticBlockStore awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
         * 
         * @return builder
         * 
         */
        public Builder awsElasticBlockStore(@Nullable Output<AWSElasticBlockStoreVolumeSourceArgs> awsElasticBlockStore) {
            $.awsElasticBlockStore = awsElasticBlockStore;
            return this;
        }

        /**
         * @param awsElasticBlockStore awsElasticBlockStore represents an AWS Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
         * 
         * @return builder
         * 
         */
        public Builder awsElasticBlockStore(AWSElasticBlockStoreVolumeSourceArgs awsElasticBlockStore) {
            return awsElasticBlockStore(Output.of(awsElasticBlockStore));
        }

        /**
         * @param azureDisk azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
         * 
         * @return builder
         * 
         */
        public Builder azureDisk(@Nullable Output<AzureDiskVolumeSourceArgs> azureDisk) {
            $.azureDisk = azureDisk;
            return this;
        }

        /**
         * @param azureDisk azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
         * 
         * @return builder
         * 
         */
        public Builder azureDisk(AzureDiskVolumeSourceArgs azureDisk) {
            return azureDisk(Output.of(azureDisk));
        }

        /**
         * @param azureFile azureFile represents an Azure File Service mount on the host and bind mount to the pod.
         * 
         * @return builder
         * 
         */
        public Builder azureFile(@Nullable Output<AzureFileVolumeSourceArgs> azureFile) {
            $.azureFile = azureFile;
            return this;
        }

        /**
         * @param azureFile azureFile represents an Azure File Service mount on the host and bind mount to the pod.
         * 
         * @return builder
         * 
         */
        public Builder azureFile(AzureFileVolumeSourceArgs azureFile) {
            return azureFile(Output.of(azureFile));
        }

        /**
         * @param cephfs cephFS represents a Ceph FS mount on the host that shares a pod&#39;s lifetime
         * 
         * @return builder
         * 
         */
        public Builder cephfs(@Nullable Output<CephFSVolumeSourceArgs> cephfs) {
            $.cephfs = cephfs;
            return this;
        }

        /**
         * @param cephfs cephFS represents a Ceph FS mount on the host that shares a pod&#39;s lifetime
         * 
         * @return builder
         * 
         */
        public Builder cephfs(CephFSVolumeSourceArgs cephfs) {
            return cephfs(Output.of(cephfs));
        }

        /**
         * @param cinder cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
         * 
         * @return builder
         * 
         */
        public Builder cinder(@Nullable Output<CinderVolumeSourceArgs> cinder) {
            $.cinder = cinder;
            return this;
        }

        /**
         * @param cinder cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
         * 
         * @return builder
         * 
         */
        public Builder cinder(CinderVolumeSourceArgs cinder) {
            return cinder(Output.of(cinder));
        }

        /**
         * @param configMap configMap represents a configMap that should populate this volume
         * 
         * @return builder
         * 
         */
        public Builder configMap(@Nullable Output<ConfigMapVolumeSourceArgs> configMap) {
            $.configMap = configMap;
            return this;
        }

        /**
         * @param configMap configMap represents a configMap that should populate this volume
         * 
         * @return builder
         * 
         */
        public Builder configMap(ConfigMapVolumeSourceArgs configMap) {
            return configMap(Output.of(configMap));
        }

        /**
         * @param csi csi (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).
         * 
         * @return builder
         * 
         */
        public Builder csi(@Nullable Output<CSIVolumeSourceArgs> csi) {
            $.csi = csi;
            return this;
        }

        /**
         * @param csi csi (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).
         * 
         * @return builder
         * 
         */
        public Builder csi(CSIVolumeSourceArgs csi) {
            return csi(Output.of(csi));
        }

        /**
         * @param downwardAPI downwardAPI represents downward API about the pod that should populate this volume
         * 
         * @return builder
         * 
         */
        public Builder downwardAPI(@Nullable Output<DownwardAPIVolumeSourceArgs> downwardAPI) {
            $.downwardAPI = downwardAPI;
            return this;
        }

        /**
         * @param downwardAPI downwardAPI represents downward API about the pod that should populate this volume
         * 
         * @return builder
         * 
         */
        public Builder downwardAPI(DownwardAPIVolumeSourceArgs downwardAPI) {
            return downwardAPI(Output.of(downwardAPI));
        }

        /**
         * @param emptyDir emptyDir represents a temporary directory that shares a pod&#39;s lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
         * 
         * @return builder
         * 
         */
        public Builder emptyDir(@Nullable Output<EmptyDirVolumeSourceArgs> emptyDir) {
            $.emptyDir = emptyDir;
            return this;
        }

        /**
         * @param emptyDir emptyDir represents a temporary directory that shares a pod&#39;s lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
         * 
         * @return builder
         * 
         */
        public Builder emptyDir(EmptyDirVolumeSourceArgs emptyDir) {
            return emptyDir(Output.of(emptyDir));
        }

        /**
         * @param ephemeral ephemeral represents a volume that is handled by a cluster storage driver. The volume&#39;s lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.
         * 
         * Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity
         *    tracking are needed,
         * c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through
         *    a PersistentVolumeClaim (see EphemeralVolumeSource for more
         *    information on the connection between this volume type
         *    and PersistentVolumeClaim).
         * 
         * Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.
         * 
         * Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.
         * 
         * A pod can use both types of ephemeral volumes and persistent volumes at the same time.
         * 
         * @return builder
         * 
         */
        public Builder ephemeral(@Nullable Output<EphemeralVolumeSourceArgs> ephemeral) {
            $.ephemeral = ephemeral;
            return this;
        }

        /**
         * @param ephemeral ephemeral represents a volume that is handled by a cluster storage driver. The volume&#39;s lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.
         * 
         * Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity
         *    tracking are needed,
         * c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through
         *    a PersistentVolumeClaim (see EphemeralVolumeSource for more
         *    information on the connection between this volume type
         *    and PersistentVolumeClaim).
         * 
         * Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.
         * 
         * Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.
         * 
         * A pod can use both types of ephemeral volumes and persistent volumes at the same time.
         * 
         * @return builder
         * 
         */
        public Builder ephemeral(EphemeralVolumeSourceArgs ephemeral) {
            return ephemeral(Output.of(ephemeral));
        }

        /**
         * @param fc fc represents a Fibre Channel resource that is attached to a kubelet&#39;s host machine and then exposed to the pod.
         * 
         * @return builder
         * 
         */
        public Builder fc(@Nullable Output<FCVolumeSourceArgs> fc) {
            $.fc = fc;
            return this;
        }

        /**
         * @param fc fc represents a Fibre Channel resource that is attached to a kubelet&#39;s host machine and then exposed to the pod.
         * 
         * @return builder
         * 
         */
        public Builder fc(FCVolumeSourceArgs fc) {
            return fc(Output.of(fc));
        }

        /**
         * @param flexVolume flexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
         * 
         * @return builder
         * 
         */
        public Builder flexVolume(@Nullable Output<FlexVolumeSourceArgs> flexVolume) {
            $.flexVolume = flexVolume;
            return this;
        }

        /**
         * @param flexVolume flexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
         * 
         * @return builder
         * 
         */
        public Builder flexVolume(FlexVolumeSourceArgs flexVolume) {
            return flexVolume(Output.of(flexVolume));
        }

        /**
         * @param flocker flocker represents a Flocker volume attached to a kubelet&#39;s host machine. This depends on the Flocker control service being running
         * 
         * @return builder
         * 
         */
        public Builder flocker(@Nullable Output<FlockerVolumeSourceArgs> flocker) {
            $.flocker = flocker;
            return this;
        }

        /**
         * @param flocker flocker represents a Flocker volume attached to a kubelet&#39;s host machine. This depends on the Flocker control service being running
         * 
         * @return builder
         * 
         */
        public Builder flocker(FlockerVolumeSourceArgs flocker) {
            return flocker(Output.of(flocker));
        }

        /**
         * @param gcePersistentDisk gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
         * 
         * @return builder
         * 
         */
        public Builder gcePersistentDisk(@Nullable Output<GCEPersistentDiskVolumeSourceArgs> gcePersistentDisk) {
            $.gcePersistentDisk = gcePersistentDisk;
            return this;
        }

        /**
         * @param gcePersistentDisk gcePersistentDisk represents a GCE Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
         * 
         * @return builder
         * 
         */
        public Builder gcePersistentDisk(GCEPersistentDiskVolumeSourceArgs gcePersistentDisk) {
            return gcePersistentDisk(Output.of(gcePersistentDisk));
        }

        /**
         * @param gitRepo gitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod&#39;s container.
         * 
         * @return builder
         * 
         */
        public Builder gitRepo(@Nullable Output<GitRepoVolumeSourceArgs> gitRepo) {
            $.gitRepo = gitRepo;
            return this;
        }

        /**
         * @param gitRepo gitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod&#39;s container.
         * 
         * @return builder
         * 
         */
        public Builder gitRepo(GitRepoVolumeSourceArgs gitRepo) {
            return gitRepo(Output.of(gitRepo));
        }

        /**
         * @param glusterfs glusterfs represents a Glusterfs mount on the host that shares a pod&#39;s lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md
         * 
         * @return builder
         * 
         */
        public Builder glusterfs(@Nullable Output<GlusterfsVolumeSourceArgs> glusterfs) {
            $.glusterfs = glusterfs;
            return this;
        }

        /**
         * @param glusterfs glusterfs represents a Glusterfs mount on the host that shares a pod&#39;s lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md
         * 
         * @return builder
         * 
         */
        public Builder glusterfs(GlusterfsVolumeSourceArgs glusterfs) {
            return glusterfs(Output.of(glusterfs));
        }

        /**
         * @param hostPath hostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
         * 
         * @return builder
         * 
         */
        public Builder hostPath(@Nullable Output<HostPathVolumeSourceArgs> hostPath) {
            $.hostPath = hostPath;
            return this;
        }

        /**
         * @param hostPath hostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
         * 
         * @return builder
         * 
         */
        public Builder hostPath(HostPathVolumeSourceArgs hostPath) {
            return hostPath(Output.of(hostPath));
        }

        /**
         * @param image image represents an OCI object (a container image or artifact) pulled and mounted on the kubelet&#39;s host machine. The volume is resolved at pod startup depending on which PullPolicy value is provided:
         * 
         * - Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. - Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn&#39;t present. - IfNotPresent: the kubelet pulls if the reference isn&#39;t already present on disk. Container creation will fail if the reference isn&#39;t present and the pull fails.
         * 
         * The volume gets re-resolved if the pod gets deleted and recreated, which means that new remote content will become available on pod recreation. A failure to resolve or pull the image during pod startup will block containers from starting and may add significant latency. Failures will be retried using normal volume backoff and will be reported on the pod reason and message. The types of objects that may be mounted by this volume are defined by the container runtime implementation on a host machine and at minimum must include all valid types supported by the container image field. The OCI object gets mounted in a single directory (spec.containers[*].volumeMounts.mountPath) by merging the manifest layers in the same way as for container images. The volume will be mounted read-only (ro) and non-executable files (noexec). Sub path mounts for containers are not supported (spec.containers[*].volumeMounts.subpath). The field spec.securityContext.fsGroupChangePolicy has no effect on this volume type.
         * 
         * @return builder
         * 
         */
        public Builder image(@Nullable Output<ImageVolumeSourceArgs> image) {
            $.image = image;
            return this;
        }

        /**
         * @param image image represents an OCI object (a container image or artifact) pulled and mounted on the kubelet&#39;s host machine. The volume is resolved at pod startup depending on which PullPolicy value is provided:
         * 
         * - Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. - Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn&#39;t present. - IfNotPresent: the kubelet pulls if the reference isn&#39;t already present on disk. Container creation will fail if the reference isn&#39;t present and the pull fails.
         * 
         * The volume gets re-resolved if the pod gets deleted and recreated, which means that new remote content will become available on pod recreation. A failure to resolve or pull the image during pod startup will block containers from starting and may add significant latency. Failures will be retried using normal volume backoff and will be reported on the pod reason and message. The types of objects that may be mounted by this volume are defined by the container runtime implementation on a host machine and at minimum must include all valid types supported by the container image field. The OCI object gets mounted in a single directory (spec.containers[*].volumeMounts.mountPath) by merging the manifest layers in the same way as for container images. The volume will be mounted read-only (ro) and non-executable files (noexec). Sub path mounts for containers are not supported (spec.containers[*].volumeMounts.subpath). The field spec.securityContext.fsGroupChangePolicy has no effect on this volume type.
         * 
         * @return builder
         * 
         */
        public Builder image(ImageVolumeSourceArgs image) {
            return image(Output.of(image));
        }

        /**
         * @param iscsi iscsi represents an ISCSI Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md
         * 
         * @return builder
         * 
         */
        public Builder iscsi(@Nullable Output<ISCSIVolumeSourceArgs> iscsi) {
            $.iscsi = iscsi;
            return this;
        }

        /**
         * @param iscsi iscsi represents an ISCSI Disk resource that is attached to a kubelet&#39;s host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md
         * 
         * @return builder
         * 
         */
        public Builder iscsi(ISCSIVolumeSourceArgs iscsi) {
            return iscsi(Output.of(iscsi));
        }

        /**
         * @param name name of the volume. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
         * 
         * @return builder
         * 
         */
        public Builder name(Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name name of the volume. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param nfs nfs represents an NFS mount on the host that shares a pod&#39;s lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
         * 
         * @return builder
         * 
         */
        public Builder nfs(@Nullable Output<NFSVolumeSourceArgs> nfs) {
            $.nfs = nfs;
            return this;
        }

        /**
         * @param nfs nfs represents an NFS mount on the host that shares a pod&#39;s lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
         * 
         * @return builder
         * 
         */
        public Builder nfs(NFSVolumeSourceArgs nfs) {
            return nfs(Output.of(nfs));
        }

        /**
         * @param persistentVolumeClaim persistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
         * 
         * @return builder
         * 
         */
        public Builder persistentVolumeClaim(@Nullable Output<PersistentVolumeClaimVolumeSourceArgs> persistentVolumeClaim) {
            $.persistentVolumeClaim = persistentVolumeClaim;
            return this;
        }

        /**
         * @param persistentVolumeClaim persistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
         * 
         * @return builder
         * 
         */
        public Builder persistentVolumeClaim(PersistentVolumeClaimVolumeSourceArgs persistentVolumeClaim) {
            return persistentVolumeClaim(Output.of(persistentVolumeClaim));
        }

        /**
         * @param photonPersistentDisk photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
         * 
         * @return builder
         * 
         */
        public Builder photonPersistentDisk(@Nullable Output<PhotonPersistentDiskVolumeSourceArgs> photonPersistentDisk) {
            $.photonPersistentDisk = photonPersistentDisk;
            return this;
        }

        /**
         * @param photonPersistentDisk photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
         * 
         * @return builder
         * 
         */
        public Builder photonPersistentDisk(PhotonPersistentDiskVolumeSourceArgs photonPersistentDisk) {
            return photonPersistentDisk(Output.of(photonPersistentDisk));
        }

        /**
         * @param portworxVolume portworxVolume represents a portworx volume attached and mounted on kubelets host machine
         * 
         * @return builder
         * 
         */
        public Builder portworxVolume(@Nullable Output<PortworxVolumeSourceArgs> portworxVolume) {
            $.portworxVolume = portworxVolume;
            return this;
        }

        /**
         * @param portworxVolume portworxVolume represents a portworx volume attached and mounted on kubelets host machine
         * 
         * @return builder
         * 
         */
        public Builder portworxVolume(PortworxVolumeSourceArgs portworxVolume) {
            return portworxVolume(Output.of(portworxVolume));
        }

        /**
         * @param projected projected items for all in one resources secrets, configmaps, and downward API
         * 
         * @return builder
         * 
         */
        public Builder projected(@Nullable Output<ProjectedVolumeSourceArgs> projected) {
            $.projected = projected;
            return this;
        }

        /**
         * @param projected projected items for all in one resources secrets, configmaps, and downward API
         * 
         * @return builder
         * 
         */
        public Builder projected(ProjectedVolumeSourceArgs projected) {
            return projected(Output.of(projected));
        }

        /**
         * @param quobyte quobyte represents a Quobyte mount on the host that shares a pod&#39;s lifetime
         * 
         * @return builder
         * 
         */
        public Builder quobyte(@Nullable Output<QuobyteVolumeSourceArgs> quobyte) {
            $.quobyte = quobyte;
            return this;
        }

        /**
         * @param quobyte quobyte represents a Quobyte mount on the host that shares a pod&#39;s lifetime
         * 
         * @return builder
         * 
         */
        public Builder quobyte(QuobyteVolumeSourceArgs quobyte) {
            return quobyte(Output.of(quobyte));
        }

        /**
         * @param rbd rbd represents a Rados Block Device mount on the host that shares a pod&#39;s lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
         * 
         * @return builder
         * 
         */
        public Builder rbd(@Nullable Output<RBDVolumeSourceArgs> rbd) {
            $.rbd = rbd;
            return this;
        }

        /**
         * @param rbd rbd represents a Rados Block Device mount on the host that shares a pod&#39;s lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
         * 
         * @return builder
         * 
         */
        public Builder rbd(RBDVolumeSourceArgs rbd) {
            return rbd(Output.of(rbd));
        }

        /**
         * @param scaleIO scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
         * 
         * @return builder
         * 
         */
        public Builder scaleIO(@Nullable Output<ScaleIOVolumeSourceArgs> scaleIO) {
            $.scaleIO = scaleIO;
            return this;
        }

        /**
         * @param scaleIO scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
         * 
         * @return builder
         * 
         */
        public Builder scaleIO(ScaleIOVolumeSourceArgs scaleIO) {
            return scaleIO(Output.of(scaleIO));
        }

        /**
         * @param secret secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
         * 
         * @return builder
         * 
         */
        public Builder secret(@Nullable Output<SecretVolumeSourceArgs> secret) {
            $.secret = secret;
            return this;
        }

        /**
         * @param secret secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
         * 
         * @return builder
         * 
         */
        public Builder secret(SecretVolumeSourceArgs secret) {
            return secret(Output.of(secret));
        }

        /**
         * @param storageos storageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
         * 
         * @return builder
         * 
         */
        public Builder storageos(@Nullable Output<StorageOSVolumeSourceArgs> storageos) {
            $.storageos = storageos;
            return this;
        }

        /**
         * @param storageos storageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
         * 
         * @return builder
         * 
         */
        public Builder storageos(StorageOSVolumeSourceArgs storageos) {
            return storageos(Output.of(storageos));
        }

        /**
         * @param vsphereVolume vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
         * 
         * @return builder
         * 
         */
        public Builder vsphereVolume(@Nullable Output<VsphereVirtualDiskVolumeSourceArgs> vsphereVolume) {
            $.vsphereVolume = vsphereVolume;
            return this;
        }

        /**
         * @param vsphereVolume vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
         * 
         * @return builder
         * 
         */
        public Builder vsphereVolume(VsphereVirtualDiskVolumeSourceArgs vsphereVolume) {
            return vsphereVolume(Output.of(vsphereVolume));
        }

        public VolumeArgs build() {
            if ($.name == null) {
                throw new MissingRequiredPropertyException("VolumeArgs", "name");
            }
            return $;
        }
    }

}
