// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ContainerPort {
    /**
     * @return Number of port to expose on the pod&#39;s IP address. This must be a valid port number, 0 &lt; x &lt; 65536.
     * 
     */
    private Integer containerPort;
    /**
     * @return What host IP to bind the external port to.
     * 
     */
    private @Nullable String hostIP;
    /**
     * @return Number of port to expose on the host. If specified, this must be a valid port number, 0 &lt; x &lt; 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
     * 
     */
    private @Nullable Integer hostPort;
    /**
     * @return If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
     * 
     */
    private @Nullable String name;
    /**
     * @return Protocol for port. Must be UDP, TCP, or SCTP. Defaults to &#34;TCP&#34;.
     * 
     */
    private @Nullable String protocol;

    private ContainerPort() {}
    /**
     * @return Number of port to expose on the pod&#39;s IP address. This must be a valid port number, 0 &lt; x &lt; 65536.
     * 
     */
    public Integer containerPort() {
        return this.containerPort;
    }
    /**
     * @return What host IP to bind the external port to.
     * 
     */
    public Optional<String> hostIP() {
        return Optional.ofNullable(this.hostIP);
    }
    /**
     * @return Number of port to expose on the host. If specified, this must be a valid port number, 0 &lt; x &lt; 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
     * 
     */
    public Optional<Integer> hostPort() {
        return Optional.ofNullable(this.hostPort);
    }
    /**
     * @return If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
     * 
     */
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }
    /**
     * @return Protocol for port. Must be UDP, TCP, or SCTP. Defaults to &#34;TCP&#34;.
     * 
     */
    public Optional<String> protocol() {
        return Optional.ofNullable(this.protocol);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContainerPort defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private Integer containerPort;
        private @Nullable String hostIP;
        private @Nullable Integer hostPort;
        private @Nullable String name;
        private @Nullable String protocol;
        public Builder() {}
        public Builder(ContainerPort defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.containerPort = defaults.containerPort;
    	      this.hostIP = defaults.hostIP;
    	      this.hostPort = defaults.hostPort;
    	      this.name = defaults.name;
    	      this.protocol = defaults.protocol;
        }

        @CustomType.Setter
        public Builder containerPort(Integer containerPort) {
            if (containerPort == null) {
              throw new MissingRequiredPropertyException("ContainerPort", "containerPort");
            }
            this.containerPort = containerPort;
            return this;
        }
        @CustomType.Setter
        public Builder hostIP(@Nullable String hostIP) {

            this.hostIP = hostIP;
            return this;
        }
        @CustomType.Setter
        public Builder hostPort(@Nullable Integer hostPort) {

            this.hostPort = hostPort;
            return this;
        }
        @CustomType.Setter
        public Builder name(@Nullable String name) {

            this.name = name;
            return this;
        }
        @CustomType.Setter
        public Builder protocol(@Nullable String protocol) {

            this.protocol = protocol;
            return this;
        }
        public ContainerPort build() {
            final var _resultValue = new ContainerPort();
            _resultValue.containerPort = containerPort;
            _resultValue.hostIP = hostIP;
            _resultValue.hostPort = hostPort;
            _resultValue.name = name;
            _resultValue.protocol = protocol;
            return _resultValue;
        }
    }
}
