// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.EnvVarSource;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class EnvVar {
    /**
     * @return Name of the environment variable. Must be a C_IDENTIFIER.
     * 
     */
    private String name;
    /**
     * @return Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. &#34;$$(VAR_NAME)&#34; will produce the string literal &#34;$(VAR_NAME)&#34;. Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to &#34;&#34;.
     * 
     */
    private @Nullable String value;
    /**
     * @return Source for the environment variable&#39;s value. Cannot be used if value is not empty.
     * 
     */
    private @Nullable EnvVarSource valueFrom;

    private EnvVar() {}
    /**
     * @return Name of the environment variable. Must be a C_IDENTIFIER.
     * 
     */
    public String name() {
        return this.name;
    }
    /**
     * @return Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. &#34;$$(VAR_NAME)&#34; will produce the string literal &#34;$(VAR_NAME)&#34;. Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to &#34;&#34;.
     * 
     */
    public Optional<String> value() {
        return Optional.ofNullable(this.value);
    }
    /**
     * @return Source for the environment variable&#39;s value. Cannot be used if value is not empty.
     * 
     */
    public Optional<EnvVarSource> valueFrom() {
        return Optional.ofNullable(this.valueFrom);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EnvVar defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private String name;
        private @Nullable String value;
        private @Nullable EnvVarSource valueFrom;
        public Builder() {}
        public Builder(EnvVar defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.name = defaults.name;
    	      this.value = defaults.value;
    	      this.valueFrom = defaults.valueFrom;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
              throw new MissingRequiredPropertyException("EnvVar", "name");
            }
            this.name = name;
            return this;
        }
        @CustomType.Setter
        public Builder value(@Nullable String value) {

            this.value = value;
            return this;
        }
        @CustomType.Setter
        public Builder valueFrom(@Nullable EnvVarSource valueFrom) {

            this.valueFrom = valueFrom;
            return this;
        }
        public EnvVar build() {
            final var _resultValue = new EnvVar();
            _resultValue.name = name;
            _resultValue.value = value;
            _resultValue.valueFrom = valueFrom;
            return _resultValue;
        }
    }
}
