// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.PortStatus;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class LoadBalancerIngress {
    /**
     * @return Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
     * 
     */
    private @Nullable String hostname;
    /**
     * @return IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
     * 
     */
    private @Nullable String ip;
    /**
     * @return IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to &#34;VIP&#34; indicates that traffic is delivered to the node with the destination set to the load-balancer&#39;s IP and port. Setting this to &#34;Proxy&#34; indicates that traffic is delivered to the node or pod with the destination set to the node&#39;s IP and node port or the pod&#39;s IP and port. Service implementations may use this information to adjust traffic routing.
     * 
     */
    private @Nullable String ipMode;
    /**
     * @return Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
     * 
     */
    private @Nullable List<PortStatus> ports;

    private LoadBalancerIngress() {}
    /**
     * @return Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)
     * 
     */
    public Optional<String> hostname() {
        return Optional.ofNullable(this.hostname);
    }
    /**
     * @return IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)
     * 
     */
    public Optional<String> ip() {
        return Optional.ofNullable(this.ip);
    }
    /**
     * @return IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified. Setting this to &#34;VIP&#34; indicates that traffic is delivered to the node with the destination set to the load-balancer&#39;s IP and port. Setting this to &#34;Proxy&#34; indicates that traffic is delivered to the node or pod with the destination set to the node&#39;s IP and node port or the pod&#39;s IP and port. Service implementations may use this information to adjust traffic routing.
     * 
     */
    public Optional<String> ipMode() {
        return Optional.ofNullable(this.ipMode);
    }
    /**
     * @return Ports is a list of records of service ports If used, every port defined in the service should have an entry in it
     * 
     */
    public List<PortStatus> ports() {
        return this.ports == null ? List.of() : this.ports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LoadBalancerIngress defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable String hostname;
        private @Nullable String ip;
        private @Nullable String ipMode;
        private @Nullable List<PortStatus> ports;
        public Builder() {}
        public Builder(LoadBalancerIngress defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.hostname = defaults.hostname;
    	      this.ip = defaults.ip;
    	      this.ipMode = defaults.ipMode;
    	      this.ports = defaults.ports;
        }

        @CustomType.Setter
        public Builder hostname(@Nullable String hostname) {

            this.hostname = hostname;
            return this;
        }
        @CustomType.Setter
        public Builder ip(@Nullable String ip) {

            this.ip = ip;
            return this;
        }
        @CustomType.Setter
        public Builder ipMode(@Nullable String ipMode) {

            this.ipMode = ipMode;
            return this;
        }
        @CustomType.Setter
        public Builder ports(@Nullable List<PortStatus> ports) {

            this.ports = ports;
            return this;
        }
        public Builder ports(PortStatus... ports) {
            return ports(List.of(ports));
        }
        public LoadBalancerIngress build() {
            final var _resultValue = new LoadBalancerIngress();
            _resultValue.hostname = hostname;
            _resultValue.ip = ip;
            _resultValue.ipMode = ipMode;
            _resultValue.ports = ports;
            return _resultValue;
        }
    }
}
