// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.Affinity;
import com.pulumi.kubernetes.core.v1.outputs.Container;
import com.pulumi.kubernetes.core.v1.outputs.EphemeralContainer;
import com.pulumi.kubernetes.core.v1.outputs.HostAlias;
import com.pulumi.kubernetes.core.v1.outputs.LocalObjectReference;
import com.pulumi.kubernetes.core.v1.outputs.PodDNSConfig;
import com.pulumi.kubernetes.core.v1.outputs.PodOS;
import com.pulumi.kubernetes.core.v1.outputs.PodReadinessGate;
import com.pulumi.kubernetes.core.v1.outputs.PodResourceClaim;
import com.pulumi.kubernetes.core.v1.outputs.PodSchedulingGate;
import com.pulumi.kubernetes.core.v1.outputs.PodSecurityContext;
import com.pulumi.kubernetes.core.v1.outputs.Toleration;
import com.pulumi.kubernetes.core.v1.outputs.TopologySpreadConstraint;
import com.pulumi.kubernetes.core.v1.outputs.Volume;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class PodSpec {
    /**
     * @return Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
     * 
     */
    private @Nullable Integer activeDeadlineSeconds;
    /**
     * @return If specified, the pod&#39;s scheduling constraints
     * 
     */
    private @Nullable Affinity affinity;
    /**
     * @return AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
     * 
     */
    private @Nullable Boolean automountServiceAccountToken;
    /**
     * @return List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.
     * 
     */
    private List<Container> containers;
    /**
     * @return Specifies the DNS parameters of a pod. Parameters specified here will be merged to the generated DNS configuration based on DNSPolicy.
     * 
     */
    private @Nullable PodDNSConfig dnsConfig;
    /**
     * @return Set DNS policy for the pod. Defaults to &#34;ClusterFirst&#34;. Valid values are &#39;ClusterFirstWithHostNet&#39;, &#39;ClusterFirst&#39;, &#39;Default&#39; or &#39;None&#39;. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to &#39;ClusterFirstWithHostNet&#39;.
     * 
     */
    private @Nullable String dnsPolicy;
    /**
     * @return EnableServiceLinks indicates whether information about services should be injected into pod&#39;s environment variables, matching the syntax of Docker links. Optional: Defaults to true.
     * 
     */
    private @Nullable Boolean enableServiceLinks;
    /**
     * @return List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod&#39;s ephemeralcontainers subresource.
     * 
     */
    private @Nullable List<EphemeralContainer> ephemeralContainers;
    /**
     * @return HostAliases is an optional list of hosts and IPs that will be injected into the pod&#39;s hosts file if specified.
     * 
     */
    private @Nullable List<HostAlias> hostAliases;
    /**
     * @return Use the host&#39;s ipc namespace. Optional: Default to false.
     * 
     */
    private @Nullable Boolean hostIPC;
    /**
     * @return Host networking requested for this pod. Use the host&#39;s network namespace. If this option is set, the ports that will be used must be specified. Default to false.
     * 
     */
    private @Nullable Boolean hostNetwork;
    /**
     * @return Use the host&#39;s pid namespace. Optional: Default to false.
     * 
     */
    private @Nullable Boolean hostPID;
    /**
     * @return Use the host&#39;s user namespace. Optional: Default to true. If set to true or not present, the pod will be run in the host user namespace, useful for when the pod needs a feature only available to the host user namespace, such as loading a kernel module with CAP_SYS_MODULE. When set to false, a new userns is created for the pod. Setting false is useful for mitigating container breakout vulnerabilities even allowing users to run their containers as root without actually having root privileges on the host. This field is alpha-level and is only honored by servers that enable the UserNamespacesSupport feature.
     * 
     */
    private @Nullable Boolean hostUsers;
    /**
     * @return Specifies the hostname of the Pod If not specified, the pod&#39;s hostname will be set to a system-defined value.
     * 
     */
    private @Nullable String hostname;
    /**
     * @return ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
     * 
     */
    private @Nullable List<LocalObjectReference> imagePullSecrets;
    /**
     * @return List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
     * 
     */
    private @Nullable List<Container> initContainers;
    /**
     * @return NodeName indicates in which node this pod is scheduled. If empty, this pod is a candidate for scheduling by the scheduler defined in schedulerName. Once this field is set, the kubelet for this node becomes responsible for the lifecycle of this pod. This field should not be used to express a desire for the pod to be scheduled on a specific node. https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#nodename
     * 
     */
    private @Nullable String nodeName;
    /**
     * @return NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node&#39;s labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
     * 
     */
    private @Nullable Map<String,String> nodeSelector;
    /**
     * @return Specifies the OS of the containers in the pod. Some pod and container fields are restricted if this is set.
     * 
     * If the OS field is set to linux, the following fields must be unset: -securityContext.windowsOptions
     * 
     * If the OS field is set to windows, following fields must be unset: - spec.hostPID - spec.hostIPC - spec.hostUsers - spec.securityContext.appArmorProfile - spec.securityContext.seLinuxOptions - spec.securityContext.seccompProfile - spec.securityContext.fsGroup - spec.securityContext.fsGroupChangePolicy - spec.securityContext.sysctls - spec.shareProcessNamespace - spec.securityContext.runAsUser - spec.securityContext.runAsGroup - spec.securityContext.supplementalGroups - spec.securityContext.supplementalGroupsPolicy - spec.containers[*].securityContext.appArmorProfile - spec.containers[*].securityContext.seLinuxOptions - spec.containers[*].securityContext.seccompProfile - spec.containers[*].securityContext.capabilities - spec.containers[*].securityContext.readOnlyRootFilesystem - spec.containers[*].securityContext.privileged - spec.containers[*].securityContext.allowPrivilegeEscalation - spec.containers[*].securityContext.procMount - spec.containers[*].securityContext.runAsUser - spec.containers[*].securityContext.runAsGroup
     * 
     */
    private @Nullable PodOS os;
    /**
     * @return Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md
     * 
     */
    private @Nullable Map<String,String> overhead;
    /**
     * @return PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset.
     * 
     */
    private @Nullable String preemptionPolicy;
    /**
     * @return The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.
     * 
     */
    private @Nullable Integer priority;
    /**
     * @return If specified, indicates the pod&#39;s priority. &#34;system-node-critical&#34; and &#34;system-cluster-critical&#34; are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
     * 
     */
    private @Nullable String priorityClassName;
    /**
     * @return If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to &#34;True&#34; More info: https://git.k8s.io/enhancements/keps/sig-network/580-pod-readiness-gates
     * 
     */
    private @Nullable List<PodReadinessGate> readinessGates;
    /**
     * @return ResourceClaims defines which ResourceClaims must be allocated and reserved before the Pod is allowed to start. The resources will be made available to those containers which consume them by name.
     * 
     * This is an alpha field and requires enabling the DynamicResourceAllocation feature gate.
     * 
     * This field is immutable.
     * 
     */
    private @Nullable List<PodResourceClaim> resourceClaims;
    /**
     * @return Restart policy for all containers within the pod. One of Always, OnFailure, Never. In some contexts, only a subset of those values may be permitted. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
     * 
     */
    private @Nullable String restartPolicy;
    /**
     * @return RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the &#34;legacy&#34; RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class
     * 
     */
    private @Nullable String runtimeClassName;
    /**
     * @return If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.
     * 
     */
    private @Nullable String schedulerName;
    /**
     * @return SchedulingGates is an opaque list of values that if specified will block scheduling the pod. If schedulingGates is not empty, the pod will stay in the SchedulingGated state and the scheduler will not attempt to schedule the pod.
     * 
     * SchedulingGates can only be set at pod creation time, and be removed only afterwards.
     * 
     */
    private @Nullable List<PodSchedulingGate> schedulingGates;
    /**
     * @return SecurityContext holds pod-level security attributes and common container settings. Optional: Defaults to empty.  See type description for default values of each field.
     * 
     */
    private @Nullable PodSecurityContext securityContext;
    /**
     * @return DeprecatedServiceAccount is a deprecated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.
     * 
     */
    private @Nullable String serviceAccount;
    /**
     * @return ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
     * 
     */
    private @Nullable String serviceAccountName;
    /**
     * @return If true the pod&#39;s hostname will be configured as the pod&#39;s FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default to false.
     * 
     */
    private @Nullable Boolean setHostnameAsFQDN;
    /**
     * @return Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.
     * 
     */
    private @Nullable Boolean shareProcessNamespace;
    /**
     * @return If specified, the fully qualified Pod hostname will be &#34;&lt;hostname&gt;.&lt;subdomain&gt;.&lt;pod namespace&gt;.svc.&lt;cluster domain&gt;&#34;. If not specified, the pod will not have a domainname at all.
     * 
     */
    private @Nullable String subdomain;
    /**
     * @return Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.
     * 
     */
    private @Nullable Integer terminationGracePeriodSeconds;
    /**
     * @return If specified, the pod&#39;s tolerations.
     * 
     */
    private @Nullable List<Toleration> tolerations;
    /**
     * @return TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed.
     * 
     */
    private @Nullable List<TopologySpreadConstraint> topologySpreadConstraints;
    /**
     * @return List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes
     * 
     */
    private @Nullable List<Volume> volumes;

    private PodSpec() {}
    /**
     * @return Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.
     * 
     */
    public Optional<Integer> activeDeadlineSeconds() {
        return Optional.ofNullable(this.activeDeadlineSeconds);
    }
    /**
     * @return If specified, the pod&#39;s scheduling constraints
     * 
     */
    public Optional<Affinity> affinity() {
        return Optional.ofNullable(this.affinity);
    }
    /**
     * @return AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
     * 
     */
    public Optional<Boolean> automountServiceAccountToken() {
        return Optional.ofNullable(this.automountServiceAccountToken);
    }
    /**
     * @return List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.
     * 
     */
    public List<Container> containers() {
        return this.containers;
    }
    /**
     * @return Specifies the DNS parameters of a pod. Parameters specified here will be merged to the generated DNS configuration based on DNSPolicy.
     * 
     */
    public Optional<PodDNSConfig> dnsConfig() {
        return Optional.ofNullable(this.dnsConfig);
    }
    /**
     * @return Set DNS policy for the pod. Defaults to &#34;ClusterFirst&#34;. Valid values are &#39;ClusterFirstWithHostNet&#39;, &#39;ClusterFirst&#39;, &#39;Default&#39; or &#39;None&#39;. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to &#39;ClusterFirstWithHostNet&#39;.
     * 
     */
    public Optional<String> dnsPolicy() {
        return Optional.ofNullable(this.dnsPolicy);
    }
    /**
     * @return EnableServiceLinks indicates whether information about services should be injected into pod&#39;s environment variables, matching the syntax of Docker links. Optional: Defaults to true.
     * 
     */
    public Optional<Boolean> enableServiceLinks() {
        return Optional.ofNullable(this.enableServiceLinks);
    }
    /**
     * @return List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod&#39;s ephemeralcontainers subresource.
     * 
     */
    public List<EphemeralContainer> ephemeralContainers() {
        return this.ephemeralContainers == null ? List.of() : this.ephemeralContainers;
    }
    /**
     * @return HostAliases is an optional list of hosts and IPs that will be injected into the pod&#39;s hosts file if specified.
     * 
     */
    public List<HostAlias> hostAliases() {
        return this.hostAliases == null ? List.of() : this.hostAliases;
    }
    /**
     * @return Use the host&#39;s ipc namespace. Optional: Default to false.
     * 
     */
    public Optional<Boolean> hostIPC() {
        return Optional.ofNullable(this.hostIPC);
    }
    /**
     * @return Host networking requested for this pod. Use the host&#39;s network namespace. If this option is set, the ports that will be used must be specified. Default to false.
     * 
     */
    public Optional<Boolean> hostNetwork() {
        return Optional.ofNullable(this.hostNetwork);
    }
    /**
     * @return Use the host&#39;s pid namespace. Optional: Default to false.
     * 
     */
    public Optional<Boolean> hostPID() {
        return Optional.ofNullable(this.hostPID);
    }
    /**
     * @return Use the host&#39;s user namespace. Optional: Default to true. If set to true or not present, the pod will be run in the host user namespace, useful for when the pod needs a feature only available to the host user namespace, such as loading a kernel module with CAP_SYS_MODULE. When set to false, a new userns is created for the pod. Setting false is useful for mitigating container breakout vulnerabilities even allowing users to run their containers as root without actually having root privileges on the host. This field is alpha-level and is only honored by servers that enable the UserNamespacesSupport feature.
     * 
     */
    public Optional<Boolean> hostUsers() {
        return Optional.ofNullable(this.hostUsers);
    }
    /**
     * @return Specifies the hostname of the Pod If not specified, the pod&#39;s hostname will be set to a system-defined value.
     * 
     */
    public Optional<String> hostname() {
        return Optional.ofNullable(this.hostname);
    }
    /**
     * @return ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
     * 
     */
    public List<LocalObjectReference> imagePullSecrets() {
        return this.imagePullSecrets == null ? List.of() : this.imagePullSecrets;
    }
    /**
     * @return List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
     * 
     */
    public List<Container> initContainers() {
        return this.initContainers == null ? List.of() : this.initContainers;
    }
    /**
     * @return NodeName indicates in which node this pod is scheduled. If empty, this pod is a candidate for scheduling by the scheduler defined in schedulerName. Once this field is set, the kubelet for this node becomes responsible for the lifecycle of this pod. This field should not be used to express a desire for the pod to be scheduled on a specific node. https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#nodename
     * 
     */
    public Optional<String> nodeName() {
        return Optional.ofNullable(this.nodeName);
    }
    /**
     * @return NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node&#39;s labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
     * 
     */
    public Map<String,String> nodeSelector() {
        return this.nodeSelector == null ? Map.of() : this.nodeSelector;
    }
    /**
     * @return Specifies the OS of the containers in the pod. Some pod and container fields are restricted if this is set.
     * 
     * If the OS field is set to linux, the following fields must be unset: -securityContext.windowsOptions
     * 
     * If the OS field is set to windows, following fields must be unset: - spec.hostPID - spec.hostIPC - spec.hostUsers - spec.securityContext.appArmorProfile - spec.securityContext.seLinuxOptions - spec.securityContext.seccompProfile - spec.securityContext.fsGroup - spec.securityContext.fsGroupChangePolicy - spec.securityContext.sysctls - spec.shareProcessNamespace - spec.securityContext.runAsUser - spec.securityContext.runAsGroup - spec.securityContext.supplementalGroups - spec.securityContext.supplementalGroupsPolicy - spec.containers[*].securityContext.appArmorProfile - spec.containers[*].securityContext.seLinuxOptions - spec.containers[*].securityContext.seccompProfile - spec.containers[*].securityContext.capabilities - spec.containers[*].securityContext.readOnlyRootFilesystem - spec.containers[*].securityContext.privileged - spec.containers[*].securityContext.allowPrivilegeEscalation - spec.containers[*].securityContext.procMount - spec.containers[*].securityContext.runAsUser - spec.containers[*].securityContext.runAsGroup
     * 
     */
    public Optional<PodOS> os() {
        return Optional.ofNullable(this.os);
    }
    /**
     * @return Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md
     * 
     */
    public Map<String,String> overhead() {
        return this.overhead == null ? Map.of() : this.overhead;
    }
    /**
     * @return PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset.
     * 
     */
    public Optional<String> preemptionPolicy() {
        return Optional.ofNullable(this.preemptionPolicy);
    }
    /**
     * @return The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.
     * 
     */
    public Optional<Integer> priority() {
        return Optional.ofNullable(this.priority);
    }
    /**
     * @return If specified, indicates the pod&#39;s priority. &#34;system-node-critical&#34; and &#34;system-cluster-critical&#34; are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.
     * 
     */
    public Optional<String> priorityClassName() {
        return Optional.ofNullable(this.priorityClassName);
    }
    /**
     * @return If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to &#34;True&#34; More info: https://git.k8s.io/enhancements/keps/sig-network/580-pod-readiness-gates
     * 
     */
    public List<PodReadinessGate> readinessGates() {
        return this.readinessGates == null ? List.of() : this.readinessGates;
    }
    /**
     * @return ResourceClaims defines which ResourceClaims must be allocated and reserved before the Pod is allowed to start. The resources will be made available to those containers which consume them by name.
     * 
     * This is an alpha field and requires enabling the DynamicResourceAllocation feature gate.
     * 
     * This field is immutable.
     * 
     */
    public List<PodResourceClaim> resourceClaims() {
        return this.resourceClaims == null ? List.of() : this.resourceClaims;
    }
    /**
     * @return Restart policy for all containers within the pod. One of Always, OnFailure, Never. In some contexts, only a subset of those values may be permitted. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
     * 
     */
    public Optional<String> restartPolicy() {
        return Optional.ofNullable(this.restartPolicy);
    }
    /**
     * @return RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the &#34;legacy&#34; RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class
     * 
     */
    public Optional<String> runtimeClassName() {
        return Optional.ofNullable(this.runtimeClassName);
    }
    /**
     * @return If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.
     * 
     */
    public Optional<String> schedulerName() {
        return Optional.ofNullable(this.schedulerName);
    }
    /**
     * @return SchedulingGates is an opaque list of values that if specified will block scheduling the pod. If schedulingGates is not empty, the pod will stay in the SchedulingGated state and the scheduler will not attempt to schedule the pod.
     * 
     * SchedulingGates can only be set at pod creation time, and be removed only afterwards.
     * 
     */
    public List<PodSchedulingGate> schedulingGates() {
        return this.schedulingGates == null ? List.of() : this.schedulingGates;
    }
    /**
     * @return SecurityContext holds pod-level security attributes and common container settings. Optional: Defaults to empty.  See type description for default values of each field.
     * 
     */
    public Optional<PodSecurityContext> securityContext() {
        return Optional.ofNullable(this.securityContext);
    }
    /**
     * @return DeprecatedServiceAccount is a deprecated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.
     * 
     */
    public Optional<String> serviceAccount() {
        return Optional.ofNullable(this.serviceAccount);
    }
    /**
     * @return ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
     * 
     */
    public Optional<String> serviceAccountName() {
        return Optional.ofNullable(this.serviceAccountName);
    }
    /**
     * @return If true the pod&#39;s hostname will be configured as the pod&#39;s FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default to false.
     * 
     */
    public Optional<Boolean> setHostnameAsFQDN() {
        return Optional.ofNullable(this.setHostnameAsFQDN);
    }
    /**
     * @return Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.
     * 
     */
    public Optional<Boolean> shareProcessNamespace() {
        return Optional.ofNullable(this.shareProcessNamespace);
    }
    /**
     * @return If specified, the fully qualified Pod hostname will be &#34;&lt;hostname&gt;.&lt;subdomain&gt;.&lt;pod namespace&gt;.svc.&lt;cluster domain&gt;&#34;. If not specified, the pod will not have a domainname at all.
     * 
     */
    public Optional<String> subdomain() {
        return Optional.ofNullable(this.subdomain);
    }
    /**
     * @return Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.
     * 
     */
    public Optional<Integer> terminationGracePeriodSeconds() {
        return Optional.ofNullable(this.terminationGracePeriodSeconds);
    }
    /**
     * @return If specified, the pod&#39;s tolerations.
     * 
     */
    public List<Toleration> tolerations() {
        return this.tolerations == null ? List.of() : this.tolerations;
    }
    /**
     * @return TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed.
     * 
     */
    public List<TopologySpreadConstraint> topologySpreadConstraints() {
        return this.topologySpreadConstraints == null ? List.of() : this.topologySpreadConstraints;
    }
    /**
     * @return List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes
     * 
     */
    public List<Volume> volumes() {
        return this.volumes == null ? List.of() : this.volumes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PodSpec defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Integer activeDeadlineSeconds;
        private @Nullable Affinity affinity;
        private @Nullable Boolean automountServiceAccountToken;
        private List<Container> containers;
        private @Nullable PodDNSConfig dnsConfig;
        private @Nullable String dnsPolicy;
        private @Nullable Boolean enableServiceLinks;
        private @Nullable List<EphemeralContainer> ephemeralContainers;
        private @Nullable List<HostAlias> hostAliases;
        private @Nullable Boolean hostIPC;
        private @Nullable Boolean hostNetwork;
        private @Nullable Boolean hostPID;
        private @Nullable Boolean hostUsers;
        private @Nullable String hostname;
        private @Nullable List<LocalObjectReference> imagePullSecrets;
        private @Nullable List<Container> initContainers;
        private @Nullable String nodeName;
        private @Nullable Map<String,String> nodeSelector;
        private @Nullable PodOS os;
        private @Nullable Map<String,String> overhead;
        private @Nullable String preemptionPolicy;
        private @Nullable Integer priority;
        private @Nullable String priorityClassName;
        private @Nullable List<PodReadinessGate> readinessGates;
        private @Nullable List<PodResourceClaim> resourceClaims;
        private @Nullable String restartPolicy;
        private @Nullable String runtimeClassName;
        private @Nullable String schedulerName;
        private @Nullable List<PodSchedulingGate> schedulingGates;
        private @Nullable PodSecurityContext securityContext;
        private @Nullable String serviceAccount;
        private @Nullable String serviceAccountName;
        private @Nullable Boolean setHostnameAsFQDN;
        private @Nullable Boolean shareProcessNamespace;
        private @Nullable String subdomain;
        private @Nullable Integer terminationGracePeriodSeconds;
        private @Nullable List<Toleration> tolerations;
        private @Nullable List<TopologySpreadConstraint> topologySpreadConstraints;
        private @Nullable List<Volume> volumes;
        public Builder() {}
        public Builder(PodSpec defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.activeDeadlineSeconds = defaults.activeDeadlineSeconds;
    	      this.affinity = defaults.affinity;
    	      this.automountServiceAccountToken = defaults.automountServiceAccountToken;
    	      this.containers = defaults.containers;
    	      this.dnsConfig = defaults.dnsConfig;
    	      this.dnsPolicy = defaults.dnsPolicy;
    	      this.enableServiceLinks = defaults.enableServiceLinks;
    	      this.ephemeralContainers = defaults.ephemeralContainers;
    	      this.hostAliases = defaults.hostAliases;
    	      this.hostIPC = defaults.hostIPC;
    	      this.hostNetwork = defaults.hostNetwork;
    	      this.hostPID = defaults.hostPID;
    	      this.hostUsers = defaults.hostUsers;
    	      this.hostname = defaults.hostname;
    	      this.imagePullSecrets = defaults.imagePullSecrets;
    	      this.initContainers = defaults.initContainers;
    	      this.nodeName = defaults.nodeName;
    	      this.nodeSelector = defaults.nodeSelector;
    	      this.os = defaults.os;
    	      this.overhead = defaults.overhead;
    	      this.preemptionPolicy = defaults.preemptionPolicy;
    	      this.priority = defaults.priority;
    	      this.priorityClassName = defaults.priorityClassName;
    	      this.readinessGates = defaults.readinessGates;
    	      this.resourceClaims = defaults.resourceClaims;
    	      this.restartPolicy = defaults.restartPolicy;
    	      this.runtimeClassName = defaults.runtimeClassName;
    	      this.schedulerName = defaults.schedulerName;
    	      this.schedulingGates = defaults.schedulingGates;
    	      this.securityContext = defaults.securityContext;
    	      this.serviceAccount = defaults.serviceAccount;
    	      this.serviceAccountName = defaults.serviceAccountName;
    	      this.setHostnameAsFQDN = defaults.setHostnameAsFQDN;
    	      this.shareProcessNamespace = defaults.shareProcessNamespace;
    	      this.subdomain = defaults.subdomain;
    	      this.terminationGracePeriodSeconds = defaults.terminationGracePeriodSeconds;
    	      this.tolerations = defaults.tolerations;
    	      this.topologySpreadConstraints = defaults.topologySpreadConstraints;
    	      this.volumes = defaults.volumes;
        }

        @CustomType.Setter
        public Builder activeDeadlineSeconds(@Nullable Integer activeDeadlineSeconds) {

            this.activeDeadlineSeconds = activeDeadlineSeconds;
            return this;
        }
        @CustomType.Setter
        public Builder affinity(@Nullable Affinity affinity) {

            this.affinity = affinity;
            return this;
        }
        @CustomType.Setter
        public Builder automountServiceAccountToken(@Nullable Boolean automountServiceAccountToken) {

            this.automountServiceAccountToken = automountServiceAccountToken;
            return this;
        }
        @CustomType.Setter
        public Builder containers(List<Container> containers) {
            if (containers == null) {
              throw new MissingRequiredPropertyException("PodSpec", "containers");
            }
            this.containers = containers;
            return this;
        }
        public Builder containers(Container... containers) {
            return containers(List.of(containers));
        }
        @CustomType.Setter
        public Builder dnsConfig(@Nullable PodDNSConfig dnsConfig) {

            this.dnsConfig = dnsConfig;
            return this;
        }
        @CustomType.Setter
        public Builder dnsPolicy(@Nullable String dnsPolicy) {

            this.dnsPolicy = dnsPolicy;
            return this;
        }
        @CustomType.Setter
        public Builder enableServiceLinks(@Nullable Boolean enableServiceLinks) {

            this.enableServiceLinks = enableServiceLinks;
            return this;
        }
        @CustomType.Setter
        public Builder ephemeralContainers(@Nullable List<EphemeralContainer> ephemeralContainers) {

            this.ephemeralContainers = ephemeralContainers;
            return this;
        }
        public Builder ephemeralContainers(EphemeralContainer... ephemeralContainers) {
            return ephemeralContainers(List.of(ephemeralContainers));
        }
        @CustomType.Setter
        public Builder hostAliases(@Nullable List<HostAlias> hostAliases) {

            this.hostAliases = hostAliases;
            return this;
        }
        public Builder hostAliases(HostAlias... hostAliases) {
            return hostAliases(List.of(hostAliases));
        }
        @CustomType.Setter
        public Builder hostIPC(@Nullable Boolean hostIPC) {

            this.hostIPC = hostIPC;
            return this;
        }
        @CustomType.Setter
        public Builder hostNetwork(@Nullable Boolean hostNetwork) {

            this.hostNetwork = hostNetwork;
            return this;
        }
        @CustomType.Setter
        public Builder hostPID(@Nullable Boolean hostPID) {

            this.hostPID = hostPID;
            return this;
        }
        @CustomType.Setter
        public Builder hostUsers(@Nullable Boolean hostUsers) {

            this.hostUsers = hostUsers;
            return this;
        }
        @CustomType.Setter
        public Builder hostname(@Nullable String hostname) {

            this.hostname = hostname;
            return this;
        }
        @CustomType.Setter
        public Builder imagePullSecrets(@Nullable List<LocalObjectReference> imagePullSecrets) {

            this.imagePullSecrets = imagePullSecrets;
            return this;
        }
        public Builder imagePullSecrets(LocalObjectReference... imagePullSecrets) {
            return imagePullSecrets(List.of(imagePullSecrets));
        }
        @CustomType.Setter
        public Builder initContainers(@Nullable List<Container> initContainers) {

            this.initContainers = initContainers;
            return this;
        }
        public Builder initContainers(Container... initContainers) {
            return initContainers(List.of(initContainers));
        }
        @CustomType.Setter
        public Builder nodeName(@Nullable String nodeName) {

            this.nodeName = nodeName;
            return this;
        }
        @CustomType.Setter
        public Builder nodeSelector(@Nullable Map<String,String> nodeSelector) {

            this.nodeSelector = nodeSelector;
            return this;
        }
        @CustomType.Setter
        public Builder os(@Nullable PodOS os) {

            this.os = os;
            return this;
        }
        @CustomType.Setter
        public Builder overhead(@Nullable Map<String,String> overhead) {

            this.overhead = overhead;
            return this;
        }
        @CustomType.Setter
        public Builder preemptionPolicy(@Nullable String preemptionPolicy) {

            this.preemptionPolicy = preemptionPolicy;
            return this;
        }
        @CustomType.Setter
        public Builder priority(@Nullable Integer priority) {

            this.priority = priority;
            return this;
        }
        @CustomType.Setter
        public Builder priorityClassName(@Nullable String priorityClassName) {

            this.priorityClassName = priorityClassName;
            return this;
        }
        @CustomType.Setter
        public Builder readinessGates(@Nullable List<PodReadinessGate> readinessGates) {

            this.readinessGates = readinessGates;
            return this;
        }
        public Builder readinessGates(PodReadinessGate... readinessGates) {
            return readinessGates(List.of(readinessGates));
        }
        @CustomType.Setter
        public Builder resourceClaims(@Nullable List<PodResourceClaim> resourceClaims) {

            this.resourceClaims = resourceClaims;
            return this;
        }
        public Builder resourceClaims(PodResourceClaim... resourceClaims) {
            return resourceClaims(List.of(resourceClaims));
        }
        @CustomType.Setter
        public Builder restartPolicy(@Nullable String restartPolicy) {

            this.restartPolicy = restartPolicy;
            return this;
        }
        @CustomType.Setter
        public Builder runtimeClassName(@Nullable String runtimeClassName) {

            this.runtimeClassName = runtimeClassName;
            return this;
        }
        @CustomType.Setter
        public Builder schedulerName(@Nullable String schedulerName) {

            this.schedulerName = schedulerName;
            return this;
        }
        @CustomType.Setter
        public Builder schedulingGates(@Nullable List<PodSchedulingGate> schedulingGates) {

            this.schedulingGates = schedulingGates;
            return this;
        }
        public Builder schedulingGates(PodSchedulingGate... schedulingGates) {
            return schedulingGates(List.of(schedulingGates));
        }
        @CustomType.Setter
        public Builder securityContext(@Nullable PodSecurityContext securityContext) {

            this.securityContext = securityContext;
            return this;
        }
        @CustomType.Setter
        public Builder serviceAccount(@Nullable String serviceAccount) {

            this.serviceAccount = serviceAccount;
            return this;
        }
        @CustomType.Setter
        public Builder serviceAccountName(@Nullable String serviceAccountName) {

            this.serviceAccountName = serviceAccountName;
            return this;
        }
        @CustomType.Setter
        public Builder setHostnameAsFQDN(@Nullable Boolean setHostnameAsFQDN) {

            this.setHostnameAsFQDN = setHostnameAsFQDN;
            return this;
        }
        @CustomType.Setter
        public Builder shareProcessNamespace(@Nullable Boolean shareProcessNamespace) {

            this.shareProcessNamespace = shareProcessNamespace;
            return this;
        }
        @CustomType.Setter
        public Builder subdomain(@Nullable String subdomain) {

            this.subdomain = subdomain;
            return this;
        }
        @CustomType.Setter
        public Builder terminationGracePeriodSeconds(@Nullable Integer terminationGracePeriodSeconds) {

            this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
            return this;
        }
        @CustomType.Setter
        public Builder tolerations(@Nullable List<Toleration> tolerations) {

            this.tolerations = tolerations;
            return this;
        }
        public Builder tolerations(Toleration... tolerations) {
            return tolerations(List.of(tolerations));
        }
        @CustomType.Setter
        public Builder topologySpreadConstraints(@Nullable List<TopologySpreadConstraint> topologySpreadConstraints) {

            this.topologySpreadConstraints = topologySpreadConstraints;
            return this;
        }
        public Builder topologySpreadConstraints(TopologySpreadConstraint... topologySpreadConstraints) {
            return topologySpreadConstraints(List.of(topologySpreadConstraints));
        }
        @CustomType.Setter
        public Builder volumes(@Nullable List<Volume> volumes) {

            this.volumes = volumes;
            return this;
        }
        public Builder volumes(Volume... volumes) {
            return volumes(List.of(volumes));
        }
        public PodSpec build() {
            final var _resultValue = new PodSpec();
            _resultValue.activeDeadlineSeconds = activeDeadlineSeconds;
            _resultValue.affinity = affinity;
            _resultValue.automountServiceAccountToken = automountServiceAccountToken;
            _resultValue.containers = containers;
            _resultValue.dnsConfig = dnsConfig;
            _resultValue.dnsPolicy = dnsPolicy;
            _resultValue.enableServiceLinks = enableServiceLinks;
            _resultValue.ephemeralContainers = ephemeralContainers;
            _resultValue.hostAliases = hostAliases;
            _resultValue.hostIPC = hostIPC;
            _resultValue.hostNetwork = hostNetwork;
            _resultValue.hostPID = hostPID;
            _resultValue.hostUsers = hostUsers;
            _resultValue.hostname = hostname;
            _resultValue.imagePullSecrets = imagePullSecrets;
            _resultValue.initContainers = initContainers;
            _resultValue.nodeName = nodeName;
            _resultValue.nodeSelector = nodeSelector;
            _resultValue.os = os;
            _resultValue.overhead = overhead;
            _resultValue.preemptionPolicy = preemptionPolicy;
            _resultValue.priority = priority;
            _resultValue.priorityClassName = priorityClassName;
            _resultValue.readinessGates = readinessGates;
            _resultValue.resourceClaims = resourceClaims;
            _resultValue.restartPolicy = restartPolicy;
            _resultValue.runtimeClassName = runtimeClassName;
            _resultValue.schedulerName = schedulerName;
            _resultValue.schedulingGates = schedulingGates;
            _resultValue.securityContext = securityContext;
            _resultValue.serviceAccount = serviceAccount;
            _resultValue.serviceAccountName = serviceAccountName;
            _resultValue.setHostnameAsFQDN = setHostnameAsFQDN;
            _resultValue.shareProcessNamespace = shareProcessNamespace;
            _resultValue.subdomain = subdomain;
            _resultValue.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
            _resultValue.tolerations = tolerations;
            _resultValue.topologySpreadConstraints = topologySpreadConstraints;
            _resultValue.volumes = volumes;
            return _resultValue;
        }
    }
}
