// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.ReplicationControllerCondition;
import java.lang.Integer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ReplicationControllerStatus {
    /**
     * @return The number of available replicas (ready for at least minReadySeconds) for this replication controller.
     * 
     */
    private @Nullable Integer availableReplicas;
    /**
     * @return Represents the latest available observations of a replication controller&#39;s current state.
     * 
     */
    private @Nullable List<ReplicationControllerCondition> conditions;
    /**
     * @return The number of pods that have labels matching the labels of the pod template of the replication controller.
     * 
     */
    private @Nullable Integer fullyLabeledReplicas;
    /**
     * @return ObservedGeneration reflects the generation of the most recently observed replication controller.
     * 
     */
    private @Nullable Integer observedGeneration;
    /**
     * @return The number of ready replicas for this replication controller.
     * 
     */
    private @Nullable Integer readyReplicas;
    /**
     * @return Replicas is the most recently observed number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
     * 
     */
    private Integer replicas;

    private ReplicationControllerStatus() {}
    /**
     * @return The number of available replicas (ready for at least minReadySeconds) for this replication controller.
     * 
     */
    public Optional<Integer> availableReplicas() {
        return Optional.ofNullable(this.availableReplicas);
    }
    /**
     * @return Represents the latest available observations of a replication controller&#39;s current state.
     * 
     */
    public List<ReplicationControllerCondition> conditions() {
        return this.conditions == null ? List.of() : this.conditions;
    }
    /**
     * @return The number of pods that have labels matching the labels of the pod template of the replication controller.
     * 
     */
    public Optional<Integer> fullyLabeledReplicas() {
        return Optional.ofNullable(this.fullyLabeledReplicas);
    }
    /**
     * @return ObservedGeneration reflects the generation of the most recently observed replication controller.
     * 
     */
    public Optional<Integer> observedGeneration() {
        return Optional.ofNullable(this.observedGeneration);
    }
    /**
     * @return The number of ready replicas for this replication controller.
     * 
     */
    public Optional<Integer> readyReplicas() {
        return Optional.ofNullable(this.readyReplicas);
    }
    /**
     * @return Replicas is the most recently observed number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
     * 
     */
    public Integer replicas() {
        return this.replicas;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ReplicationControllerStatus defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Integer availableReplicas;
        private @Nullable List<ReplicationControllerCondition> conditions;
        private @Nullable Integer fullyLabeledReplicas;
        private @Nullable Integer observedGeneration;
        private @Nullable Integer readyReplicas;
        private Integer replicas;
        public Builder() {}
        public Builder(ReplicationControllerStatus defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.availableReplicas = defaults.availableReplicas;
    	      this.conditions = defaults.conditions;
    	      this.fullyLabeledReplicas = defaults.fullyLabeledReplicas;
    	      this.observedGeneration = defaults.observedGeneration;
    	      this.readyReplicas = defaults.readyReplicas;
    	      this.replicas = defaults.replicas;
        }

        @CustomType.Setter
        public Builder availableReplicas(@Nullable Integer availableReplicas) {

            this.availableReplicas = availableReplicas;
            return this;
        }
        @CustomType.Setter
        public Builder conditions(@Nullable List<ReplicationControllerCondition> conditions) {

            this.conditions = conditions;
            return this;
        }
        public Builder conditions(ReplicationControllerCondition... conditions) {
            return conditions(List.of(conditions));
        }
        @CustomType.Setter
        public Builder fullyLabeledReplicas(@Nullable Integer fullyLabeledReplicas) {

            this.fullyLabeledReplicas = fullyLabeledReplicas;
            return this;
        }
        @CustomType.Setter
        public Builder observedGeneration(@Nullable Integer observedGeneration) {

            this.observedGeneration = observedGeneration;
            return this;
        }
        @CustomType.Setter
        public Builder readyReplicas(@Nullable Integer readyReplicas) {

            this.readyReplicas = readyReplicas;
            return this;
        }
        @CustomType.Setter
        public Builder replicas(Integer replicas) {
            if (replicas == null) {
              throw new MissingRequiredPropertyException("ReplicationControllerStatus", "replicas");
            }
            this.replicas = replicas;
            return this;
        }
        public ReplicationControllerStatus build() {
            final var _resultValue = new ReplicationControllerStatus();
            _resultValue.availableReplicas = availableReplicas;
            _resultValue.conditions = conditions;
            _resultValue.fullyLabeledReplicas = fullyLabeledReplicas;
            _resultValue.observedGeneration = observedGeneration;
            _resultValue.readyReplicas = readyReplicas;
            _resultValue.replicas = replicas;
            return _resultValue;
        }
    }
}
