// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceHealth {
    /**
     * @return Health of the resource. can be one of:
     *  - Healthy: operates as normal
     *  - Unhealthy: reported unhealthy. We consider this a temporary health issue
     *               since we do not have a mechanism today to distinguish
     *               temporary and permanent issues.
     *  - Unknown: The status cannot be determined.
     *             For example, Device Plugin got unregistered and hasn&#39;t been re-registered since.
     * 
     * In future we may want to introduce the PermanentlyUnhealthy Status.
     * 
     */
    private @Nullable String health;
    /**
     * @return ResourceID is the unique identifier of the resource. See the ResourceID type for more information.
     * 
     */
    private String resourceID;

    private ResourceHealth() {}
    /**
     * @return Health of the resource. can be one of:
     *  - Healthy: operates as normal
     *  - Unhealthy: reported unhealthy. We consider this a temporary health issue
     *               since we do not have a mechanism today to distinguish
     *               temporary and permanent issues.
     *  - Unknown: The status cannot be determined.
     *             For example, Device Plugin got unregistered and hasn&#39;t been re-registered since.
     * 
     * In future we may want to introduce the PermanentlyUnhealthy Status.
     * 
     */
    public Optional<String> health() {
        return Optional.ofNullable(this.health);
    }
    /**
     * @return ResourceID is the unique identifier of the resource. See the ResourceID type for more information.
     * 
     */
    public String resourceID() {
        return this.resourceID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceHealth defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable String health;
        private String resourceID;
        public Builder() {}
        public Builder(ResourceHealth defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.health = defaults.health;
    	      this.resourceID = defaults.resourceID;
        }

        @CustomType.Setter
        public Builder health(@Nullable String health) {

            this.health = health;
            return this;
        }
        @CustomType.Setter
        public Builder resourceID(String resourceID) {
            if (resourceID == null) {
              throw new MissingRequiredPropertyException("ResourceHealth", "resourceID");
            }
            this.resourceID = resourceID;
            return this;
        }
        public ResourceHealth build() {
            final var _resultValue = new ResourceHealth();
            _resultValue.health = health;
            _resultValue.resourceID = resourceID;
            return _resultValue;
        }
    }
}
