// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.core.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.core.v1.outputs.ServicePort;
import com.pulumi.kubernetes.core.v1.outputs.SessionAffinityConfig;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceSpec {
    /**
     * @return allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is &#34;true&#34;. It may be set to &#34;false&#34; if the cluster load-balancer does not rely on NodePorts.  If the caller requests specific NodePorts (by specifying a value), those requests will be respected, regardless of this field. This field may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type.
     * 
     */
    private @Nullable Boolean allocateLoadBalancerNodePorts;
    /**
     * @return clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address. Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    private @Nullable String clusterIP;
    /**
     * @return ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address.  Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.
     * 
     * This field may hold a maximum of two entries (dual-stack IPs, in either order). These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    private @Nullable List<String> clusterIPs;
    /**
     * @return externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
     * 
     */
    private @Nullable List<String> externalIPs;
    /**
     * @return externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be &#34;ExternalName&#34;.
     * 
     */
    private @Nullable String externalName;
    /**
     * @return externalTrafficPolicy describes how nodes distribute service traffic they receive on one of the Service&#39;s &#34;externally-facing&#34; addresses (NodePorts, ExternalIPs, and LoadBalancer IPs). If set to &#34;Local&#34;, the proxy will configure the service in a way that assumes that external load balancers will take care of balancing the service traffic between nodes, and so each node will deliver traffic only to the node-local endpoints of the service, without masquerading the client source IP. (Traffic mistakenly sent to a node with no endpoints will be dropped.) The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features). Note that traffic sent to an External IP or LoadBalancer IP from within the cluster will always get &#34;Cluster&#34; semantics, but clients sending to a NodePort from within the cluster may need to take traffic policy into account when picking a node.
     * 
     */
    private @Nullable String externalTrafficPolicy;
    /**
     * @return healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type). This field cannot be updated once set.
     * 
     */
    private @Nullable Integer healthCheckNodePort;
    /**
     * @return InternalTrafficPolicy describes how nodes distribute service traffic they receive on the ClusterIP. If set to &#34;Local&#34;, the proxy will assume that pods only want to talk to endpoints of the service on the same node as the pod, dropping the traffic if there are no local endpoints. The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features).
     * 
     */
    private @Nullable String internalTrafficPolicy;
    /**
     * @return IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service. This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail. This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service. Valid values are &#34;IPv4&#34; and &#34;IPv6&#34;.  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to &#34;headless&#34; services. This field will be wiped when updating a Service to type ExternalName.
     * 
     * This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
     * 
     */
    private @Nullable List<String> ipFamilies;
    /**
     * @return ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is available in the cluster.  If no IP family is requested, the cluster&#39;s primary IP family will be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.
     * 
     */
    private @Nullable String ipFamily;
    /**
     * @return IPFamilyPolicy represents the dual-stack-ness requested or required by this Service. If there is no value provided, then this field will be set to SingleStack. Services can be &#34;SingleStack&#34; (a single IP family), &#34;PreferDualStack&#34; (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or &#34;RequireDualStack&#34; (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field. This field will be wiped when updating a service to type ExternalName.
     * 
     */
    private @Nullable String ipFamilyPolicy;
    /**
     * @return loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. &#34;internal-vip&#34; or &#34;example.com/internal-vip&#34;. Unprefixed names are reserved for end-users. This field can only be set when the Service type is &#39;LoadBalancer&#39;. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type &#39;LoadBalancer&#39;. Once set, it can not be changed. This field will be wiped when a service is updated to a non &#39;LoadBalancer&#39; type.
     * 
     */
    private @Nullable String loadBalancerClass;
    /**
     * @return Only applies to Service Type: LoadBalancer. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature. Deprecated: This field was under-specified and its meaning varies across implementations. Using it is non-portable and it may not support dual-stack. Users are encouraged to use implementation-specific annotations when available.
     * 
     */
    private @Nullable String loadBalancerIP;
    /**
     * @return If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.&#34; More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
     * 
     */
    private @Nullable List<String> loadBalancerSourceRanges;
    /**
     * @return The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    private @Nullable List<ServicePort> ports;
    /**
     * @return publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet&#39;s Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered &#34;ready&#34; even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
     * 
     */
    private @Nullable Boolean publishNotReadyAddresses;
    /**
     * @return Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
     * 
     */
    private @Nullable Map<String,String> selector;
    /**
     * @return Supports &#34;ClientIP&#34; and &#34;None&#34;. Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    private @Nullable String sessionAffinity;
    /**
     * @return sessionAffinityConfig contains the configurations of session affinity.
     * 
     */
    private @Nullable SessionAffinityConfig sessionAffinityConfig;
    /**
     * @return topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value &#34;*&#34; may be used to mean &#34;any topology&#34;. This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied.
     * 
     */
    private @Nullable List<String> topologyKeys;
    /**
     * @return TrafficDistribution offers a way to express preferences for how traffic is distributed to Service endpoints. Implementations can use this field as a hint, but are not required to guarantee strict adherence. If the field is not set, the implementation will apply its default routing strategy. If set to &#34;PreferClose&#34;, implementations should prioritize endpoints that are topologically close (e.g., same zone). This is an alpha field and requires enabling ServiceTrafficDistribution feature.
     * 
     */
    private @Nullable String trafficDistribution;
    /**
     * @return type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. &#34;ClusterIP&#34; allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is &#34;None&#34;, no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. &#34;NodePort&#34; builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. &#34;LoadBalancer&#34; builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. &#34;ExternalName&#34; aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
     * 
     */
    private @Nullable String type;

    private ServiceSpec() {}
    /**
     * @return allocateLoadBalancerNodePorts defines if NodePorts will be automatically allocated for services with type LoadBalancer.  Default is &#34;true&#34;. It may be set to &#34;false&#34; if the cluster load-balancer does not rely on NodePorts.  If the caller requests specific NodePorts (by specifying a value), those requests will be respected, regardless of this field. This field may only be set for services with type LoadBalancer and will be cleared if the type is changed to any other type.
     * 
     */
    public Optional<Boolean> allocateLoadBalancerNodePorts() {
        return Optional.ofNullable(this.allocateLoadBalancerNodePorts);
    }
    /**
     * @return clusterIP is the IP address of the service and is usually assigned randomly. If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be blank) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address. Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    public Optional<String> clusterIP() {
        return Optional.ofNullable(this.clusterIP);
    }
    /**
     * @return ClusterIPs is a list of IP addresses assigned to this service, and are usually assigned randomly.  If an address is specified manually, is in-range (as per system configuration), and is not in use, it will be allocated to the service; otherwise creation of the service will fail. This field may not be changed through updates unless the type field is also being changed to ExternalName (which requires this field to be empty) or the type field is being changed from ExternalName (in which case this field may optionally be specified, as describe above).  Valid values are &#34;None&#34;, empty string (&#34;&#34;), or a valid IP address.  Setting this to &#34;None&#34; makes a &#34;headless service&#34; (no virtual IP), which is useful when direct endpoint connections are preferred and proxying is not required.  Only applies to types ClusterIP, NodePort, and LoadBalancer. If this field is specified when creating a Service of type ExternalName, creation will fail. This field will be wiped when updating a Service to type ExternalName.  If this field is not specified, it will be initialized from the clusterIP field.  If this field is specified, clients must ensure that clusterIPs[0] and clusterIP have the same value.
     * 
     * This field may hold a maximum of two entries (dual-stack IPs, in either order). These IPs must correspond to the values of the ipFamilies field. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    public List<String> clusterIPs() {
        return this.clusterIPs == null ? List.of() : this.clusterIPs;
    }
    /**
     * @return externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.
     * 
     */
    public List<String> externalIPs() {
        return this.externalIPs == null ? List.of() : this.externalIPs;
    }
    /**
     * @return externalName is the external reference that discovery mechanisms will return as an alias for this service (e.g. a DNS CNAME record). No proxying will be involved.  Must be a lowercase RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires `type` to be &#34;ExternalName&#34;.
     * 
     */
    public Optional<String> externalName() {
        return Optional.ofNullable(this.externalName);
    }
    /**
     * @return externalTrafficPolicy describes how nodes distribute service traffic they receive on one of the Service&#39;s &#34;externally-facing&#34; addresses (NodePorts, ExternalIPs, and LoadBalancer IPs). If set to &#34;Local&#34;, the proxy will configure the service in a way that assumes that external load balancers will take care of balancing the service traffic between nodes, and so each node will deliver traffic only to the node-local endpoints of the service, without masquerading the client source IP. (Traffic mistakenly sent to a node with no endpoints will be dropped.) The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features). Note that traffic sent to an External IP or LoadBalancer IP from within the cluster will always get &#34;Cluster&#34; semantics, but clients sending to a NodePort from within the cluster may need to take traffic policy into account when picking a node.
     * 
     */
    public Optional<String> externalTrafficPolicy() {
        return Optional.ofNullable(this.externalTrafficPolicy);
    }
    /**
     * @return healthCheckNodePort specifies the healthcheck nodePort for the service. This only applies when type is set to LoadBalancer and externalTrafficPolicy is set to Local. If a value is specified, is in-range, and is not in use, it will be used.  If not specified, a value will be automatically allocated.  External systems (e.g. load-balancers) can use this port to determine if a given node holds endpoints for this service or not.  If this field is specified when creating a Service which does not need it, creation will fail. This field will be wiped when updating a Service to no longer need it (e.g. changing type). This field cannot be updated once set.
     * 
     */
    public Optional<Integer> healthCheckNodePort() {
        return Optional.ofNullable(this.healthCheckNodePort);
    }
    /**
     * @return InternalTrafficPolicy describes how nodes distribute service traffic they receive on the ClusterIP. If set to &#34;Local&#34;, the proxy will assume that pods only want to talk to endpoints of the service on the same node as the pod, dropping the traffic if there are no local endpoints. The default value, &#34;Cluster&#34;, uses the standard behavior of routing to all endpoints evenly (possibly modified by topology and other features).
     * 
     */
    public Optional<String> internalTrafficPolicy() {
        return Optional.ofNullable(this.internalTrafficPolicy);
    }
    /**
     * @return IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this service. This field is usually assigned automatically based on cluster configuration and the ipFamilyPolicy field. If this field is specified manually, the requested family is available in the cluster, and ipFamilyPolicy allows it, it will be used; otherwise creation of the service will fail. This field is conditionally mutable: it allows for adding or removing a secondary IP family, but it does not allow changing the primary IP family of the Service. Valid values are &#34;IPv4&#34; and &#34;IPv6&#34;.  This field only applies to Services of types ClusterIP, NodePort, and LoadBalancer, and does apply to &#34;headless&#34; services. This field will be wiped when updating a Service to type ExternalName.
     * 
     * This field may hold a maximum of two entries (dual-stack families, in either order).  These families must correspond to the values of the clusterIPs field, if specified. Both clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
     * 
     */
    public List<String> ipFamilies() {
        return this.ipFamilies == null ? List.of() : this.ipFamilies;
    }
    /**
     * @return ipFamily specifies whether this Service has a preference for a particular IP family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the clusterIP field will be allocated from that family, if it is available in the cluster.  If no IP family is requested, the cluster&#39;s primary IP family will be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges, externalIPs) and controllers which allocate external load-balancers should use the same IP family.  Endpoints for this Service will be of this family.  This field is immutable after creation. Assigning a ServiceIPFamily not available in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will fail during clusterIP assignment.
     * 
     */
    public Optional<String> ipFamily() {
        return Optional.ofNullable(this.ipFamily);
    }
    /**
     * @return IPFamilyPolicy represents the dual-stack-ness requested or required by this Service. If there is no value provided, then this field will be set to SingleStack. Services can be &#34;SingleStack&#34; (a single IP family), &#34;PreferDualStack&#34; (two IP families on dual-stack configured clusters or a single IP family on single-stack clusters), or &#34;RequireDualStack&#34; (two IP families on dual-stack configured clusters, otherwise fail). The ipFamilies and clusterIPs fields depend on the value of this field. This field will be wiped when updating a service to type ExternalName.
     * 
     */
    public Optional<String> ipFamilyPolicy() {
        return Optional.ofNullable(this.ipFamilyPolicy);
    }
    /**
     * @return loadBalancerClass is the class of the load balancer implementation this Service belongs to. If specified, the value of this field must be a label-style identifier, with an optional prefix, e.g. &#34;internal-vip&#34; or &#34;example.com/internal-vip&#34;. Unprefixed names are reserved for end-users. This field can only be set when the Service type is &#39;LoadBalancer&#39;. If not set, the default load balancer implementation is used, today this is typically done through the cloud provider integration, but should apply for any default implementation. If set, it is assumed that a load balancer implementation is watching for Services with a matching class. Any default load balancer implementation (e.g. cloud providers) should ignore Services that set this field. This field can only be set when creating or updating a Service to type &#39;LoadBalancer&#39;. Once set, it can not be changed. This field will be wiped when a service is updated to a non &#39;LoadBalancer&#39; type.
     * 
     */
    public Optional<String> loadBalancerClass() {
        return Optional.ofNullable(this.loadBalancerClass);
    }
    /**
     * @return Only applies to Service Type: LoadBalancer. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature. Deprecated: This field was under-specified and its meaning varies across implementations. Using it is non-portable and it may not support dual-stack. Users are encouraged to use implementation-specific annotations when available.
     * 
     */
    public Optional<String> loadBalancerIP() {
        return Optional.ofNullable(this.loadBalancerIP);
    }
    /**
     * @return If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.&#34; More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
     * 
     */
    public List<String> loadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges == null ? List.of() : this.loadBalancerSourceRanges;
    }
    /**
     * @return The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    public List<ServicePort> ports() {
        return this.ports == null ? List.of() : this.ports;
    }
    /**
     * @return publishNotReadyAddresses indicates that any agent which deals with endpoints for this Service should disregard any indications of ready/not-ready. The primary use case for setting this field is for a StatefulSet&#39;s Headless Service to propagate SRV DNS records for its Pods for the purpose of peer discovery. The Kubernetes controllers that generate Endpoints and EndpointSlice resources for Services interpret this to mean that all endpoints are considered &#34;ready&#34; even if the Pods themselves are not. Agents which consume only Kubernetes generated endpoints through the Endpoints or EndpointSlice resources can safely assume this behavior.
     * 
     */
    public Optional<Boolean> publishNotReadyAddresses() {
        return Optional.ofNullable(this.publishNotReadyAddresses);
    }
    /**
     * @return Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
     * 
     */
    public Map<String,String> selector() {
        return this.selector == null ? Map.of() : this.selector;
    }
    /**
     * @return Supports &#34;ClientIP&#34; and &#34;None&#34;. Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     * 
     */
    public Optional<String> sessionAffinity() {
        return Optional.ofNullable(this.sessionAffinity);
    }
    /**
     * @return sessionAffinityConfig contains the configurations of session affinity.
     * 
     */
    public Optional<SessionAffinityConfig> sessionAffinityConfig() {
        return Optional.ofNullable(this.sessionAffinityConfig);
    }
    /**
     * @return topologyKeys is a preference-order list of topology keys which implementations of services should use to preferentially sort endpoints when accessing this Service, it can not be used at the same time as externalTrafficPolicy=Local. Topology keys must be valid label keys and at most 16 keys may be specified. Endpoints are chosen based on the first topology key with available backends. If this field is specified and all entries have no backends that match the topology of the client, the service has no backends for that client and connections should fail. The special value &#34;*&#34; may be used to mean &#34;any topology&#34;. This catch-all value, if used, only makes sense as the last value in the list. If this is not specified or empty, no topology constraints will be applied.
     * 
     */
    public List<String> topologyKeys() {
        return this.topologyKeys == null ? List.of() : this.topologyKeys;
    }
    /**
     * @return TrafficDistribution offers a way to express preferences for how traffic is distributed to Service endpoints. Implementations can use this field as a hint, but are not required to guarantee strict adherence. If the field is not set, the implementation will apply its default routing strategy. If set to &#34;PreferClose&#34;, implementations should prioritize endpoints that are topologically close (e.g., same zone). This is an alpha field and requires enabling ServiceTrafficDistribution feature.
     * 
     */
    public Optional<String> trafficDistribution() {
        return Optional.ofNullable(this.trafficDistribution);
    }
    /**
     * @return type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. &#34;ClusterIP&#34; allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object or EndpointSlice objects. If clusterIP is &#34;None&#34;, no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a virtual IP. &#34;NodePort&#34; builds on ClusterIP and allocates a port on every node which routes to the same endpoints as the clusterIP. &#34;LoadBalancer&#34; builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the same endpoints as the clusterIP. &#34;ExternalName&#34; aliases this service to the specified externalName. Several other fields do not apply to ExternalName services. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
     * 
     */
    public Optional<String> type() {
        return Optional.ofNullable(this.type);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceSpec defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Boolean allocateLoadBalancerNodePorts;
        private @Nullable String clusterIP;
        private @Nullable List<String> clusterIPs;
        private @Nullable List<String> externalIPs;
        private @Nullable String externalName;
        private @Nullable String externalTrafficPolicy;
        private @Nullable Integer healthCheckNodePort;
        private @Nullable String internalTrafficPolicy;
        private @Nullable List<String> ipFamilies;
        private @Nullable String ipFamily;
        private @Nullable String ipFamilyPolicy;
        private @Nullable String loadBalancerClass;
        private @Nullable String loadBalancerIP;
        private @Nullable List<String> loadBalancerSourceRanges;
        private @Nullable List<ServicePort> ports;
        private @Nullable Boolean publishNotReadyAddresses;
        private @Nullable Map<String,String> selector;
        private @Nullable String sessionAffinity;
        private @Nullable SessionAffinityConfig sessionAffinityConfig;
        private @Nullable List<String> topologyKeys;
        private @Nullable String trafficDistribution;
        private @Nullable String type;
        public Builder() {}
        public Builder(ServiceSpec defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.allocateLoadBalancerNodePorts = defaults.allocateLoadBalancerNodePorts;
    	      this.clusterIP = defaults.clusterIP;
    	      this.clusterIPs = defaults.clusterIPs;
    	      this.externalIPs = defaults.externalIPs;
    	      this.externalName = defaults.externalName;
    	      this.externalTrafficPolicy = defaults.externalTrafficPolicy;
    	      this.healthCheckNodePort = defaults.healthCheckNodePort;
    	      this.internalTrafficPolicy = defaults.internalTrafficPolicy;
    	      this.ipFamilies = defaults.ipFamilies;
    	      this.ipFamily = defaults.ipFamily;
    	      this.ipFamilyPolicy = defaults.ipFamilyPolicy;
    	      this.loadBalancerClass = defaults.loadBalancerClass;
    	      this.loadBalancerIP = defaults.loadBalancerIP;
    	      this.loadBalancerSourceRanges = defaults.loadBalancerSourceRanges;
    	      this.ports = defaults.ports;
    	      this.publishNotReadyAddresses = defaults.publishNotReadyAddresses;
    	      this.selector = defaults.selector;
    	      this.sessionAffinity = defaults.sessionAffinity;
    	      this.sessionAffinityConfig = defaults.sessionAffinityConfig;
    	      this.topologyKeys = defaults.topologyKeys;
    	      this.trafficDistribution = defaults.trafficDistribution;
    	      this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder allocateLoadBalancerNodePorts(@Nullable Boolean allocateLoadBalancerNodePorts) {

            this.allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts;
            return this;
        }
        @CustomType.Setter
        public Builder clusterIP(@Nullable String clusterIP) {

            this.clusterIP = clusterIP;
            return this;
        }
        @CustomType.Setter
        public Builder clusterIPs(@Nullable List<String> clusterIPs) {

            this.clusterIPs = clusterIPs;
            return this;
        }
        public Builder clusterIPs(String... clusterIPs) {
            return clusterIPs(List.of(clusterIPs));
        }
        @CustomType.Setter
        public Builder externalIPs(@Nullable List<String> externalIPs) {

            this.externalIPs = externalIPs;
            return this;
        }
        public Builder externalIPs(String... externalIPs) {
            return externalIPs(List.of(externalIPs));
        }
        @CustomType.Setter
        public Builder externalName(@Nullable String externalName) {

            this.externalName = externalName;
            return this;
        }
        @CustomType.Setter
        public Builder externalTrafficPolicy(@Nullable String externalTrafficPolicy) {

            this.externalTrafficPolicy = externalTrafficPolicy;
            return this;
        }
        @CustomType.Setter
        public Builder healthCheckNodePort(@Nullable Integer healthCheckNodePort) {

            this.healthCheckNodePort = healthCheckNodePort;
            return this;
        }
        @CustomType.Setter
        public Builder internalTrafficPolicy(@Nullable String internalTrafficPolicy) {

            this.internalTrafficPolicy = internalTrafficPolicy;
            return this;
        }
        @CustomType.Setter
        public Builder ipFamilies(@Nullable List<String> ipFamilies) {

            this.ipFamilies = ipFamilies;
            return this;
        }
        public Builder ipFamilies(String... ipFamilies) {
            return ipFamilies(List.of(ipFamilies));
        }
        @CustomType.Setter
        public Builder ipFamily(@Nullable String ipFamily) {

            this.ipFamily = ipFamily;
            return this;
        }
        @CustomType.Setter
        public Builder ipFamilyPolicy(@Nullable String ipFamilyPolicy) {

            this.ipFamilyPolicy = ipFamilyPolicy;
            return this;
        }
        @CustomType.Setter
        public Builder loadBalancerClass(@Nullable String loadBalancerClass) {

            this.loadBalancerClass = loadBalancerClass;
            return this;
        }
        @CustomType.Setter
        public Builder loadBalancerIP(@Nullable String loadBalancerIP) {

            this.loadBalancerIP = loadBalancerIP;
            return this;
        }
        @CustomType.Setter
        public Builder loadBalancerSourceRanges(@Nullable List<String> loadBalancerSourceRanges) {

            this.loadBalancerSourceRanges = loadBalancerSourceRanges;
            return this;
        }
        public Builder loadBalancerSourceRanges(String... loadBalancerSourceRanges) {
            return loadBalancerSourceRanges(List.of(loadBalancerSourceRanges));
        }
        @CustomType.Setter
        public Builder ports(@Nullable List<ServicePort> ports) {

            this.ports = ports;
            return this;
        }
        public Builder ports(ServicePort... ports) {
            return ports(List.of(ports));
        }
        @CustomType.Setter
        public Builder publishNotReadyAddresses(@Nullable Boolean publishNotReadyAddresses) {

            this.publishNotReadyAddresses = publishNotReadyAddresses;
            return this;
        }
        @CustomType.Setter
        public Builder selector(@Nullable Map<String,String> selector) {

            this.selector = selector;
            return this;
        }
        @CustomType.Setter
        public Builder sessionAffinity(@Nullable String sessionAffinity) {

            this.sessionAffinity = sessionAffinity;
            return this;
        }
        @CustomType.Setter
        public Builder sessionAffinityConfig(@Nullable SessionAffinityConfig sessionAffinityConfig) {

            this.sessionAffinityConfig = sessionAffinityConfig;
            return this;
        }
        @CustomType.Setter
        public Builder topologyKeys(@Nullable List<String> topologyKeys) {

            this.topologyKeys = topologyKeys;
            return this;
        }
        public Builder topologyKeys(String... topologyKeys) {
            return topologyKeys(List.of(topologyKeys));
        }
        @CustomType.Setter
        public Builder trafficDistribution(@Nullable String trafficDistribution) {

            this.trafficDistribution = trafficDistribution;
            return this;
        }
        @CustomType.Setter
        public Builder type(@Nullable String type) {

            this.type = type;
            return this;
        }
        public ServiceSpec build() {
            final var _resultValue = new ServiceSpec();
            _resultValue.allocateLoadBalancerNodePorts = allocateLoadBalancerNodePorts;
            _resultValue.clusterIP = clusterIP;
            _resultValue.clusterIPs = clusterIPs;
            _resultValue.externalIPs = externalIPs;
            _resultValue.externalName = externalName;
            _resultValue.externalTrafficPolicy = externalTrafficPolicy;
            _resultValue.healthCheckNodePort = healthCheckNodePort;
            _resultValue.internalTrafficPolicy = internalTrafficPolicy;
            _resultValue.ipFamilies = ipFamilies;
            _resultValue.ipFamily = ipFamily;
            _resultValue.ipFamilyPolicy = ipFamilyPolicy;
            _resultValue.loadBalancerClass = loadBalancerClass;
            _resultValue.loadBalancerIP = loadBalancerIP;
            _resultValue.loadBalancerSourceRanges = loadBalancerSourceRanges;
            _resultValue.ports = ports;
            _resultValue.publishNotReadyAddresses = publishNotReadyAddresses;
            _resultValue.selector = selector;
            _resultValue.sessionAffinity = sessionAffinity;
            _resultValue.sessionAffinityConfig = sessionAffinityConfig;
            _resultValue.topologyKeys = topologyKeys;
            _resultValue.trafficDistribution = trafficDistribution;
            _resultValue.type = type;
            return _resultValue;
        }
    }
}
