// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.discovery.v1beta1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * EndpointConditions represents the current condition of an endpoint.
 * 
 */
public final class EndpointConditionsPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final EndpointConditionsPatchArgs Empty = new EndpointConditionsPatchArgs();

    /**
     * ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint. A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready.
     * 
     */
    @Import(name="ready")
    private @Nullable Output<Boolean> ready;

    /**
     * @return ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint. A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready.
     * 
     */
    public Optional<Output<Boolean>> ready() {
        return Optional.ofNullable(this.ready);
    }

    /**
     * serving is identical to ready except that it is set regardless of the terminating state of endpoints. This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
     * 
     */
    @Import(name="serving")
    private @Nullable Output<Boolean> serving;

    /**
     * @return serving is identical to ready except that it is set regardless of the terminating state of endpoints. This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
     * 
     */
    public Optional<Output<Boolean>> serving() {
        return Optional.ofNullable(this.serving);
    }

    /**
     * terminating indicates that this endpoint is terminating. A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
     * 
     */
    @Import(name="terminating")
    private @Nullable Output<Boolean> terminating;

    /**
     * @return terminating indicates that this endpoint is terminating. A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
     * 
     */
    public Optional<Output<Boolean>> terminating() {
        return Optional.ofNullable(this.terminating);
    }

    private EndpointConditionsPatchArgs() {}

    private EndpointConditionsPatchArgs(EndpointConditionsPatchArgs $) {
        this.ready = $.ready;
        this.serving = $.serving;
        this.terminating = $.terminating;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(EndpointConditionsPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private EndpointConditionsPatchArgs $;

        public Builder() {
            $ = new EndpointConditionsPatchArgs();
        }

        public Builder(EndpointConditionsPatchArgs defaults) {
            $ = new EndpointConditionsPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param ready ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint. A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready.
         * 
         * @return builder
         * 
         */
        public Builder ready(@Nullable Output<Boolean> ready) {
            $.ready = ready;
            return this;
        }

        /**
         * @param ready ready indicates that this endpoint is prepared to receive traffic, according to whatever system is managing the endpoint. A nil value indicates an unknown state. In most cases consumers should interpret this unknown state as ready.
         * 
         * @return builder
         * 
         */
        public Builder ready(Boolean ready) {
            return ready(Output.of(ready));
        }

        /**
         * @param serving serving is identical to ready except that it is set regardless of the terminating state of endpoints. This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
         * 
         * @return builder
         * 
         */
        public Builder serving(@Nullable Output<Boolean> serving) {
            $.serving = serving;
            return this;
        }

        /**
         * @param serving serving is identical to ready except that it is set regardless of the terminating state of endpoints. This condition should be set to true for a ready endpoint that is terminating. If nil, consumers should defer to the ready condition. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
         * 
         * @return builder
         * 
         */
        public Builder serving(Boolean serving) {
            return serving(Output.of(serving));
        }

        /**
         * @param terminating terminating indicates that this endpoint is terminating. A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
         * 
         * @return builder
         * 
         */
        public Builder terminating(@Nullable Output<Boolean> terminating) {
            $.terminating = terminating;
            return this;
        }

        /**
         * @param terminating terminating indicates that this endpoint is terminating. A nil value indicates an unknown state. Consumers should interpret this unknown state to mean that the endpoint is not terminating. This field can be enabled with the EndpointSliceTerminatingCondition feature gate.
         * 
         * @return builder
         * 
         */
        public Builder terminating(Boolean terminating) {
            return terminating(Output.of(terminating));
        }

        public EndpointConditionsPatchArgs build() {
            return $;
        }
    }

}
