// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.helm.v4;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.kubernetes.Utilities;
import com.pulumi.kubernetes.helm.v4.ChartArgs;
import java.lang.Object;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * _Looking for the Release resource? Please use the [v3 package](/registry/packages/kubernetes/api-docs/helm/v3/release/)
 * for production use cases, and stay tuned for an updated Release resource, coming soon._
 * 
 * _See also: [New: Helm Chart v4 resource with new features and languages](/blog/kubernetes-chart-v4/)_
 * 
 * Chart is a component representing a collection of resources described by a Helm Chart.
 * Helm charts are a popular packaging format for Kubernetes applications, and published
 * to registries such as [Artifact Hub](https://artifacthub.io/packages/search?kind=0&amp;sort=relevance&amp;page=1).
 * 
 * Chart does not use Tiller or create a Helm Release; the semantics are equivalent to
 * running `helm template --dry-run=server` and then using Pulumi to deploy the resulting YAML manifests.
 * This allows you to apply [Pulumi Transformations](https://www.pulumi.com/docs/concepts/options/transformations/) and
 * [Pulumi Policies](https://www.pulumi.com/docs/using-pulumi/crossguard/) to the Kubernetes resources.
 * 
 * You may also want to consider the `Release` resource as an alternative method for managing helm charts. For more
 * information about the trade-offs between these options, see: [Choosing the right Helm resource for your use case](https://www.pulumi.com/registry/packages/kubernetes/how-to-guides/choosing-the-right-helm-resource-for-your-use-case).
 * 
 * ### Chart Resolution
 * 
 * The Helm Chart can be fetched from any source that is accessible to the `helm` command line.
 * The following variations are supported:
 * 
 * 1. By chart reference with repo prefix: `chart: &#34;example/mariadb&#34;`
 * 2. By path to a packaged chart: `chart: &#34;./nginx-1.2.3.tgz&#34;`
 * 3. By path to an unpacked chart directory: `chart: &#34;./nginx&#34;`
 * 4. By absolute URL: `chart: &#34;https://example.com/charts/nginx-1.2.3.tgz&#34;`
 * 5. By chart reference with repo URL: `chart: &#34;nginx&#34;, repositoryOpts: { repo: &#34;https://example.com/charts/&#34; }`
 * 6. By OCI registry: `chart: &#34;oci://example.com/charts/nginx&#34;, version: &#34;1.2.3&#34;`
 * 
 * A chart reference is a convenient way of referencing a chart in a chart repository.
 * 
 * When you use a chart reference with a repo prefix (`example/mariadb`), Pulumi will look in Helm&#39;s local configuration
 * for a chart repository named `example`, and will then look for a chart in that repository whose name is `mariadb`.
 * It will install the latest stable version of that chart, unless you specify `devel` to also include
 * development versions (alpha, beta, and release candidate releases), or supply a version number with `version`.
 * 
 * Use the `verify` and optional `keyring` inputs to enable Chart verification.
 * By default, Pulumi uses the keyring at `$HOME/.gnupg/pubring.gpg`. See: [Helm Provenance and Integrity](https://helm.sh/docs/topics/provenance/).
 * 
 * ### Chart Values
 * 
 * [Values files](https://helm.sh/docs/chart_template_guide/values_files/#helm) (`values.yaml`) may be supplied
 * with the `valueYamlFiles` input, accepting [Pulumi Assets](https://www.pulumi.com/docs/concepts/assets-archives/#assets).
 * 
 * A map of chart values may also be supplied with the `values` input, with highest precedence. You&#39;re able to use literals,
 * nested maps, [Pulumi outputs](https://www.pulumi.com/docs/concepts/inputs-outputs/), and Pulumi assets as values.
 * Assets are automatically opened and converted to a string.
 * 
 * Note that the use of expressions (e.g. `--set service.type`) is not supported.
 * 
 * ### Chart Dependency Resolution
 * 
 * For unpacked chart directories, Pulumi automatically rebuilds the dependencies if dependencies are missing
 * and a `Chart.lock` file is present (see: [Helm Dependency Build](https://helm.sh/docs/helm/helm_dependency_build/)).
 * Use the `dependencyUpdate` input to have Pulumi update the dependencies (see: [Helm Dependency Update](https://helm.sh/docs/helm/helm_dependency_update/)).
 * 
 * ### Templating
 * 
 * The `Chart` resource renders the templates from your chart and then manages the resources directly with the
 * Pulumi Kubernetes provider. A default namespace is applied based on the `namespace` input, the provider&#39;s
 * configured namespace, and the active Kubernetes context. Use the `skipCrds` option to skip installing the
 * Custom Resource Definition (CRD) objects located in the chart&#39;s `crds/` special directory.
 * 
 * Use the `postRenderer` input to pipe the rendered manifest through a [post-rendering command](https://helm.sh/docs/topics/advanced/#post-rendering).
 * 
 * ### Resource Ordering
 * 
 * Sometimes resources must be applied in a specific order. For example, a namespace resource must be
 * created before any namespaced resources, or a Custom Resource Definition (CRD) must be pre-installed.
 * 
 * Pulumi uses heuristics to determine which order to apply and delete objects within the Chart.  Pulumi also
 * waits for each object to be fully reconciled, unless `skipAwait` is enabled.
 * 
 * Pulumi supports the `config.kubernetes.io/depends-on` annotation to declare an explicit dependency on a given resource.
 * The annotation accepts a list of resource references, delimited by commas.
 * 
 * Note that references to resources outside the Chart aren&#39;t supported.
 * 
 * **Resource reference**
 * 
 * A resource reference is a string that uniquely identifies a resource.
 * 
 * It consists of the group, kind, name, and optionally the namespace, delimited by forward slashes.
 * 
 * | Resource Scope   | Format                                         |
 * | :--------------- | :--------------------------------------------- |
 * | namespace-scoped | `&lt;group&gt;/namespaces/&lt;namespace&gt;/&lt;kind&gt;/&lt;name&gt;` |
 * | cluster-scoped   | `&lt;group&gt;/&lt;kind&gt;/&lt;name&gt;`                        |
 * 
 * For resources in the “core” group, the empty string is used instead (for example: `/namespaces/test/Pod/pod-a`).
 * 
 * ## Example Usage
 * ### Local Chart Directory
 * <pre>
 * {@code
 * package generated_program;
 * 
 * import com.pulumi.Pulumi;
 * import com.pulumi.kubernetes.helm.v4.Chart;
 * import com.pulumi.kubernetes.helm.v4.ChartArgs;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(ctx -> {
 *             var nginx = new Chart("nginx", ChartArgs.builder()
 *                     .chart("./nginx")
 *                     .build());
 *         });
 *     }
 * }
 * }
 * </pre>
 * ### Repository Chart
 * <pre>
 * {@code
 * package generated_program;
 * 
 * import com.pulumi.Pulumi;
 * import com.pulumi.kubernetes.helm.v4.Chart;
 * import com.pulumi.kubernetes.helm.v4.ChartArgs;
 * import com.pulumi.kubernetes.helm.v4.inputs.RepositoryOptsArgs;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(ctx -> {
 *             var nginx = new Chart("nginx", ChartArgs.builder()
 *                     .chart("nginx")
 *                     .repositoryOpts(RepositoryOptsArgs.builder()
 *                             .repo("https://charts.bitnami.com/bitnami")
 *                             .build())
 *                     .build());
 *         });
 *     }
 * }
 * }
 * </pre>
 * ### OCI Chart
 * <pre>
 * {@code
 * package generated_program;
 * 
 * import com.pulumi.Pulumi;
 * import com.pulumi.kubernetes.helm.v4.Chart;
 * import com.pulumi.kubernetes.helm.v4.ChartArgs;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(ctx -> {
 *             var nginx = new Chart("nginx", ChartArgs.builder()
 *                     .chart("oci://registry-1.docker.io/bitnamicharts/nginx")
 *                     .version("16.0.7")
 *                     .build());
 *         });
 *     }
 * }
 * }
 * </pre>
 * ### Chart Values
 * <pre>
 * {@code
 * package generated_program;
 * 
 * import java.util.Map;
 * 
 * import com.pulumi.Pulumi;
 * import com.pulumi.kubernetes.helm.v4.Chart;
 * import com.pulumi.kubernetes.helm.v4.ChartArgs;
 * import com.pulumi.kubernetes.helm.v4.inputs.RepositoryOptsArgs;
 * import com.pulumi.asset.FileAsset;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(ctx -> {
 *             var nginx = new Chart("nginx", ChartArgs.builder()
 *                     .chart("nginx")
 *                     .repositoryOpts(RepositoryOptsArgs.builder()
 *                             .repo("https://charts.bitnami.com/bitnami")
 *                             .build())
 *                     .valueYamlFiles(new FileAsset("./values.yaml"))
 *                     .values(Map.of(
 *                             "service", Map.of(
 *                                     "type", "ClusterIP"),
 *                             "notes", new FileAsset("./notes.txt")))
 *                     .build());
 *         });
 *     }
 * }
 * }
 * </pre>
 * ### Chart Namespace
 * <pre>
 * {@code
 * package generated_program;
 * 
 * import com.pulumi.Pulumi;
 * import com.pulumi.kubernetes.core.v1.Namespace;
 * import com.pulumi.kubernetes.core.v1.NamespaceArgs;
 * import com.pulumi.kubernetes.helm.v4.Chart;
 * import com.pulumi.kubernetes.helm.v4.ChartArgs;
 * import com.pulumi.kubernetes.helm.v4.inputs.RepositoryOptsArgs;
 * import com.pulumi.kubernetes.meta.v1.inputs.ObjectMetaArgs;
 * import com.pulumi.core.Output;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(ctx -> {
 *             var ns = new Namespace("nginx", NamespaceArgs.builder()
 *                     .metadata(ObjectMetaArgs.builder()
 *                             .name("nginx")
 *                             .build())
 *                     .build());
 *             var nginx = new Chart("nginx", ChartArgs.builder()
 *                     .namespace(ns.metadata().apply(m -> Output.of(m.name().get())))
 *                     .chart("nginx")
 *                     .repositoryOpts(RepositoryOptsArgs.builder()
 *                             .repo("https://charts.bitnami.com/bitnami")
 *                             .build())
 *                     .build());
 *         });
 *     }
 * }
 * }
 * </pre>
 * 
 */
@ResourceType(type="kubernetes:helm.sh/v4:Chart")
public class Chart extends com.pulumi.resources.ComponentResource {
    /**
     * Resources created by the Chart.
     * 
     */
    @Export(name="resources", refs={List.class,Object.class}, tree="[0,1]")
    private Output</* @Nullable */ List<Object>> resources;

    /**
     * @return Resources created by the Chart.
     * 
     */
    public Output<Optional<List<Object>>> resources() {
        return Codegen.optional(this.resources);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Chart(String name) {
        this(name, ChartArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Chart(String name, ChartArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Chart(String name, ChartArgs args, @Nullable com.pulumi.resources.ComponentResourceOptions options) {
        super("kubernetes:helm.sh/v4:Chart", name, makeArgs(args, options), makeResourceOptions(options, Codegen.empty()), true);
    }

    private static ChartArgs makeArgs(ChartArgs args, @Nullable com.pulumi.resources.ComponentResourceOptions options) {
        if (options != null && options.getUrn().isPresent()) {
            return null;
        }
        return args == null ? ChartArgs.Empty : args;
    }

    private static com.pulumi.resources.ComponentResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.ComponentResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.ComponentResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.ComponentResourceOptions.merge(defaultOptions, options, id);
    }

}
