// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.networking.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.networking.v1.inputs.ServiceBackendPortArgs;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * IngressServiceBackend references a Kubernetes Service as a Backend.
 * 
 */
public final class IngressServiceBackendArgs extends com.pulumi.resources.ResourceArgs {

    public static final IngressServiceBackendArgs Empty = new IngressServiceBackendArgs();

    /**
     * name is the referenced service. The service must exist in the same namespace as the Ingress object.
     * 
     */
    @Import(name="name", required=true)
    private Output<String> name;

    /**
     * @return name is the referenced service. The service must exist in the same namespace as the Ingress object.
     * 
     */
    public Output<String> name() {
        return this.name;
    }

    /**
     * port of the referenced service. A port name or port number is required for a IngressServiceBackend.
     * 
     */
    @Import(name="port")
    private @Nullable Output<ServiceBackendPortArgs> port;

    /**
     * @return port of the referenced service. A port name or port number is required for a IngressServiceBackend.
     * 
     */
    public Optional<Output<ServiceBackendPortArgs>> port() {
        return Optional.ofNullable(this.port);
    }

    private IngressServiceBackendArgs() {}

    private IngressServiceBackendArgs(IngressServiceBackendArgs $) {
        this.name = $.name;
        this.port = $.port;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(IngressServiceBackendArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private IngressServiceBackendArgs $;

        public Builder() {
            $ = new IngressServiceBackendArgs();
        }

        public Builder(IngressServiceBackendArgs defaults) {
            $ = new IngressServiceBackendArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param name name is the referenced service. The service must exist in the same namespace as the Ingress object.
         * 
         * @return builder
         * 
         */
        public Builder name(Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name name is the referenced service. The service must exist in the same namespace as the Ingress object.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param port port of the referenced service. A port name or port number is required for a IngressServiceBackend.
         * 
         * @return builder
         * 
         */
        public Builder port(@Nullable Output<ServiceBackendPortArgs> port) {
            $.port = port;
            return this;
        }

        /**
         * @param port port of the referenced service. A port name or port number is required for a IngressServiceBackend.
         * 
         * @return builder
         * 
         */
        public Builder port(ServiceBackendPortArgs port) {
            return port(Output.of(port));
        }

        public IngressServiceBackendArgs build() {
            if ($.name == null) {
                throw new MissingRequiredPropertyException("IngressServiceBackendArgs", "name");
            }
            return $;
        }
    }

}
