// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.networking.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.networking.v1.inputs.IngressBackendPatchArgs;
import com.pulumi.kubernetes.networking.v1.inputs.IngressRulePatchArgs;
import com.pulumi.kubernetes.networking.v1.inputs.IngressTLSPatchArgs;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * IngressSpec describes the Ingress the user wishes to exist.
 * 
 */
public final class IngressSpecPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final IngressSpecPatchArgs Empty = new IngressSpecPatchArgs();

    /**
     * defaultBackend is the backend that should handle requests that don&#39;t match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
     * 
     */
    @Import(name="defaultBackend")
    private @Nullable Output<IngressBackendPatchArgs> defaultBackend;

    /**
     * @return defaultBackend is the backend that should handle requests that don&#39;t match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
     * 
     */
    public Optional<Output<IngressBackendPatchArgs>> defaultBackend() {
        return Optional.ofNullable(this.defaultBackend);
    }

    /**
     * ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -&gt; IngressClass -&gt; Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
     * 
     */
    @Import(name="ingressClassName")
    private @Nullable Output<String> ingressClassName;

    /**
     * @return ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -&gt; IngressClass -&gt; Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
     * 
     */
    public Optional<Output<String>> ingressClassName() {
        return Optional.ofNullable(this.ingressClassName);
    }

    /**
     * rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
     * 
     */
    @Import(name="rules")
    private @Nullable Output<List<IngressRulePatchArgs>> rules;

    /**
     * @return rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
     * 
     */
    public Optional<Output<List<IngressRulePatchArgs>>> rules() {
        return Optional.ofNullable(this.rules);
    }

    /**
     * tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
     * 
     */
    @Import(name="tls")
    private @Nullable Output<List<IngressTLSPatchArgs>> tls;

    /**
     * @return tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
     * 
     */
    public Optional<Output<List<IngressTLSPatchArgs>>> tls() {
        return Optional.ofNullable(this.tls);
    }

    private IngressSpecPatchArgs() {}

    private IngressSpecPatchArgs(IngressSpecPatchArgs $) {
        this.defaultBackend = $.defaultBackend;
        this.ingressClassName = $.ingressClassName;
        this.rules = $.rules;
        this.tls = $.tls;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(IngressSpecPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private IngressSpecPatchArgs $;

        public Builder() {
            $ = new IngressSpecPatchArgs();
        }

        public Builder(IngressSpecPatchArgs defaults) {
            $ = new IngressSpecPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param defaultBackend defaultBackend is the backend that should handle requests that don&#39;t match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
         * 
         * @return builder
         * 
         */
        public Builder defaultBackend(@Nullable Output<IngressBackendPatchArgs> defaultBackend) {
            $.defaultBackend = defaultBackend;
            return this;
        }

        /**
         * @param defaultBackend defaultBackend is the backend that should handle requests that don&#39;t match any rule. If Rules are not specified, DefaultBackend must be specified. If DefaultBackend is not set, the handling of requests that do not match any of the rules will be up to the Ingress controller.
         * 
         * @return builder
         * 
         */
        public Builder defaultBackend(IngressBackendPatchArgs defaultBackend) {
            return defaultBackend(Output.of(defaultBackend));
        }

        /**
         * @param ingressClassName ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -&gt; IngressClass -&gt; Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
         * 
         * @return builder
         * 
         */
        public Builder ingressClassName(@Nullable Output<String> ingressClassName) {
            $.ingressClassName = ingressClassName;
            return this;
        }

        /**
         * @param ingressClassName ingressClassName is the name of an IngressClass cluster resource. Ingress controller implementations use this field to know whether they should be serving this Ingress resource, by a transitive connection (controller -&gt; IngressClass -&gt; Ingress resource). Although the `kubernetes.io/ingress.class` annotation (simple constant name) was never formally defined, it was widely supported by Ingress controllers to create a direct binding between Ingress controller and Ingress resources. Newly created Ingress resources should prefer using the field. However, even though the annotation is officially deprecated, for backwards compatibility reasons, ingress controllers should still honor that annotation if present.
         * 
         * @return builder
         * 
         */
        public Builder ingressClassName(String ingressClassName) {
            return ingressClassName(Output.of(ingressClassName));
        }

        /**
         * @param rules rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
         * 
         * @return builder
         * 
         */
        public Builder rules(@Nullable Output<List<IngressRulePatchArgs>> rules) {
            $.rules = rules;
            return this;
        }

        /**
         * @param rules rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
         * 
         * @return builder
         * 
         */
        public Builder rules(List<IngressRulePatchArgs> rules) {
            return rules(Output.of(rules));
        }

        /**
         * @param rules rules is a list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.
         * 
         * @return builder
         * 
         */
        public Builder rules(IngressRulePatchArgs... rules) {
            return rules(List.of(rules));
        }

        /**
         * @param tls tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
         * 
         * @return builder
         * 
         */
        public Builder tls(@Nullable Output<List<IngressTLSPatchArgs>> tls) {
            $.tls = tls;
            return this;
        }

        /**
         * @param tls tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
         * 
         * @return builder
         * 
         */
        public Builder tls(List<IngressTLSPatchArgs> tls) {
            return tls(Output.of(tls));
        }

        /**
         * @param tls tls represents the TLS configuration. Currently the Ingress only supports a single TLS port, 443. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension, if the ingress controller fulfilling the ingress supports SNI.
         * 
         * @return builder
         * 
         */
        public Builder tls(IngressTLSPatchArgs... tls) {
            return tls(List.of(tls));
        }

        public IngressSpecPatchArgs build() {
            return $;
        }
    }

}
