// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.networking.v1beta1.inputs;

import com.pulumi.core.Either;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.core.v1.inputs.TypedLocalObjectReferencePatchArgs;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * IngressBackend describes all endpoints for a given service and port.
 * 
 */
public final class IngressBackendPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final IngressBackendPatchArgs Empty = new IngressBackendPatchArgs();

    /**
     * Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, serviceName and servicePort must not be specified.
     * 
     */
    @Import(name="resource")
    private @Nullable Output<TypedLocalObjectReferencePatchArgs> resource;

    /**
     * @return Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, serviceName and servicePort must not be specified.
     * 
     */
    public Optional<Output<TypedLocalObjectReferencePatchArgs>> resource() {
        return Optional.ofNullable(this.resource);
    }

    /**
     * Specifies the name of the referenced service.
     * 
     */
    @Import(name="serviceName")
    private @Nullable Output<String> serviceName;

    /**
     * @return Specifies the name of the referenced service.
     * 
     */
    public Optional<Output<String>> serviceName() {
        return Optional.ofNullable(this.serviceName);
    }

    /**
     * Specifies the port of the referenced service.
     * 
     */
    @Import(name="servicePort")
    private @Nullable Output<Either<Integer,String>> servicePort;

    /**
     * @return Specifies the port of the referenced service.
     * 
     */
    public Optional<Output<Either<Integer,String>>> servicePort() {
        return Optional.ofNullable(this.servicePort);
    }

    private IngressBackendPatchArgs() {}

    private IngressBackendPatchArgs(IngressBackendPatchArgs $) {
        this.resource = $.resource;
        this.serviceName = $.serviceName;
        this.servicePort = $.servicePort;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(IngressBackendPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private IngressBackendPatchArgs $;

        public Builder() {
            $ = new IngressBackendPatchArgs();
        }

        public Builder(IngressBackendPatchArgs defaults) {
            $ = new IngressBackendPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param resource Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, serviceName and servicePort must not be specified.
         * 
         * @return builder
         * 
         */
        public Builder resource(@Nullable Output<TypedLocalObjectReferencePatchArgs> resource) {
            $.resource = resource;
            return this;
        }

        /**
         * @param resource Resource is an ObjectRef to another Kubernetes resource in the namespace of the Ingress object. If resource is specified, serviceName and servicePort must not be specified.
         * 
         * @return builder
         * 
         */
        public Builder resource(TypedLocalObjectReferencePatchArgs resource) {
            return resource(Output.of(resource));
        }

        /**
         * @param serviceName Specifies the name of the referenced service.
         * 
         * @return builder
         * 
         */
        public Builder serviceName(@Nullable Output<String> serviceName) {
            $.serviceName = serviceName;
            return this;
        }

        /**
         * @param serviceName Specifies the name of the referenced service.
         * 
         * @return builder
         * 
         */
        public Builder serviceName(String serviceName) {
            return serviceName(Output.of(serviceName));
        }

        /**
         * @param servicePort Specifies the port of the referenced service.
         * 
         * @return builder
         * 
         */
        public Builder servicePort(@Nullable Output<Either<Integer,String>> servicePort) {
            $.servicePort = servicePort;
            return this;
        }

        /**
         * @param servicePort Specifies the port of the referenced service.
         * 
         * @return builder
         * 
         */
        public Builder servicePort(Either<Integer,String> servicePort) {
            return servicePort(Output.of(servicePort));
        }

        /**
         * @param servicePort Specifies the port of the referenced service.
         * 
         * @return builder
         * 
         */
        public Builder servicePort(Integer servicePort) {
            return servicePort(Either.ofLeft(servicePort));
        }

        /**
         * @param servicePort Specifies the port of the referenced service.
         * 
         * @return builder
         * 
         */
        public Builder servicePort(String servicePort) {
            return servicePort(Either.ofRight(servicePort));
        }

        public IngressBackendPatchArgs build() {
            return $;
        }
    }

}
