// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha2.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.resource.v1alpha2.inputs.ResourceClaimParametersReferenceArgs;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * ResourceClaimSpec defines how a resource is to be allocated.
 * 
 */
public final class ResourceClaimSpecArgs extends com.pulumi.resources.ResourceArgs {

    public static final ResourceClaimSpecArgs Empty = new ResourceClaimSpecArgs();

    /**
     * Allocation can start immediately or when a Pod wants to use the resource. &#34;WaitForFirstConsumer&#34; is the default.
     * 
     */
    @Import(name="allocationMode")
    private @Nullable Output<String> allocationMode;

    /**
     * @return Allocation can start immediately or when a Pod wants to use the resource. &#34;WaitForFirstConsumer&#34; is the default.
     * 
     */
    public Optional<Output<String>> allocationMode() {
        return Optional.ofNullable(this.allocationMode);
    }

    /**
     * ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.
     * 
     * The object must be in the same namespace as the ResourceClaim.
     * 
     */
    @Import(name="parametersRef")
    private @Nullable Output<ResourceClaimParametersReferenceArgs> parametersRef;

    /**
     * @return ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.
     * 
     * The object must be in the same namespace as the ResourceClaim.
     * 
     */
    public Optional<Output<ResourceClaimParametersReferenceArgs>> parametersRef() {
        return Optional.ofNullable(this.parametersRef);
    }

    /**
     * ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
     * 
     */
    @Import(name="resourceClassName", required=true)
    private Output<String> resourceClassName;

    /**
     * @return ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
     * 
     */
    public Output<String> resourceClassName() {
        return this.resourceClassName;
    }

    private ResourceClaimSpecArgs() {}

    private ResourceClaimSpecArgs(ResourceClaimSpecArgs $) {
        this.allocationMode = $.allocationMode;
        this.parametersRef = $.parametersRef;
        this.resourceClassName = $.resourceClassName;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ResourceClaimSpecArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ResourceClaimSpecArgs $;

        public Builder() {
            $ = new ResourceClaimSpecArgs();
        }

        public Builder(ResourceClaimSpecArgs defaults) {
            $ = new ResourceClaimSpecArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allocationMode Allocation can start immediately or when a Pod wants to use the resource. &#34;WaitForFirstConsumer&#34; is the default.
         * 
         * @return builder
         * 
         */
        public Builder allocationMode(@Nullable Output<String> allocationMode) {
            $.allocationMode = allocationMode;
            return this;
        }

        /**
         * @param allocationMode Allocation can start immediately or when a Pod wants to use the resource. &#34;WaitForFirstConsumer&#34; is the default.
         * 
         * @return builder
         * 
         */
        public Builder allocationMode(String allocationMode) {
            return allocationMode(Output.of(allocationMode));
        }

        /**
         * @param parametersRef ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.
         * 
         * The object must be in the same namespace as the ResourceClaim.
         * 
         * @return builder
         * 
         */
        public Builder parametersRef(@Nullable Output<ResourceClaimParametersReferenceArgs> parametersRef) {
            $.parametersRef = parametersRef;
            return this;
        }

        /**
         * @param parametersRef ParametersRef references a separate object with arbitrary parameters that will be used by the driver when allocating a resource for the claim.
         * 
         * The object must be in the same namespace as the ResourceClaim.
         * 
         * @return builder
         * 
         */
        public Builder parametersRef(ResourceClaimParametersReferenceArgs parametersRef) {
            return parametersRef(Output.of(parametersRef));
        }

        /**
         * @param resourceClassName ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
         * 
         * @return builder
         * 
         */
        public Builder resourceClassName(Output<String> resourceClassName) {
            $.resourceClassName = resourceClassName;
            return this;
        }

        /**
         * @param resourceClassName ResourceClassName references the driver and additional parameters via the name of a ResourceClass that was created as part of the driver deployment.
         * 
         * @return builder
         * 
         */
        public Builder resourceClassName(String resourceClassName) {
            return resourceClassName(Output.of(resourceClassName));
        }

        public ResourceClaimSpecArgs build() {
            if ($.resourceClassName == null) {
                throw new MissingRequiredPropertyException("ResourceClaimSpecArgs", "resourceClassName");
            }
            return $;
        }
    }

}
