// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha3.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.core.v1.inputs.NodeSelectorArgs;
import com.pulumi.kubernetes.resource.v1alpha3.inputs.DeviceAllocationResultArgs;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * AllocationResult contains attributes of an allocated resource.
 * 
 */
public final class AllocationResultArgs extends com.pulumi.resources.ResourceArgs {

    public static final AllocationResultArgs Empty = new AllocationResultArgs();

    /**
     * Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.
     * 
     * A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.
     * 
     * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
     * 
     */
    @Import(name="controller")
    private @Nullable Output<String> controller;

    /**
     * @return Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.
     * 
     * A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.
     * 
     * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
     * 
     */
    public Optional<Output<String>> controller() {
        return Optional.ofNullable(this.controller);
    }

    /**
     * Devices is the result of allocating devices.
     * 
     */
    @Import(name="devices")
    private @Nullable Output<DeviceAllocationResultArgs> devices;

    /**
     * @return Devices is the result of allocating devices.
     * 
     */
    public Optional<Output<DeviceAllocationResultArgs>> devices() {
        return Optional.ofNullable(this.devices);
    }

    /**
     * NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
     * 
     */
    @Import(name="nodeSelector")
    private @Nullable Output<NodeSelectorArgs> nodeSelector;

    /**
     * @return NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
     * 
     */
    public Optional<Output<NodeSelectorArgs>> nodeSelector() {
        return Optional.ofNullable(this.nodeSelector);
    }

    private AllocationResultArgs() {}

    private AllocationResultArgs(AllocationResultArgs $) {
        this.controller = $.controller;
        this.devices = $.devices;
        this.nodeSelector = $.nodeSelector;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(AllocationResultArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private AllocationResultArgs $;

        public Builder() {
            $ = new AllocationResultArgs();
        }

        public Builder(AllocationResultArgs defaults) {
            $ = new AllocationResultArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param controller Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.
         * 
         * A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.
         * 
         * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
         * 
         * @return builder
         * 
         */
        public Builder controller(@Nullable Output<String> controller) {
            $.controller = controller;
            return this;
        }

        /**
         * @param controller Controller is the name of the DRA driver which handled the allocation. That driver is also responsible for deallocating the claim. It is empty when the claim can be deallocated without involving a driver.
         * 
         * A driver may allocate devices provided by other drivers, so this driver name here can be different from the driver names listed for the results.
         * 
         * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
         * 
         * @return builder
         * 
         */
        public Builder controller(String controller) {
            return controller(Output.of(controller));
        }

        /**
         * @param devices Devices is the result of allocating devices.
         * 
         * @return builder
         * 
         */
        public Builder devices(@Nullable Output<DeviceAllocationResultArgs> devices) {
            $.devices = devices;
            return this;
        }

        /**
         * @param devices Devices is the result of allocating devices.
         * 
         * @return builder
         * 
         */
        public Builder devices(DeviceAllocationResultArgs devices) {
            return devices(Output.of(devices));
        }

        /**
         * @param nodeSelector NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
         * 
         * @return builder
         * 
         */
        public Builder nodeSelector(@Nullable Output<NodeSelectorArgs> nodeSelector) {
            $.nodeSelector = nodeSelector;
            return this;
        }

        /**
         * @param nodeSelector NodeSelector defines where the allocated resources are available. If unset, they are available everywhere.
         * 
         * @return builder
         * 
         */
        public Builder nodeSelector(NodeSelectorArgs nodeSelector) {
            return nodeSelector(Output.of(nodeSelector));
        }

        public AllocationResultArgs build() {
            return $;
        }
    }

}
