// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha3.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.core.v1.inputs.NodeSelectorPatchArgs;
import com.pulumi.kubernetes.resource.v1alpha3.inputs.DeviceClassConfigurationPatchArgs;
import com.pulumi.kubernetes.resource.v1alpha3.inputs.DeviceSelectorPatchArgs;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.
 * 
 */
public final class DeviceClassSpecPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final DeviceClassSpecPatchArgs Empty = new DeviceClassSpecPatchArgs();

    /**
     * Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
     * 
     * They are passed to the driver, but are not considered while allocating the claim.
     * 
     */
    @Import(name="config")
    private @Nullable Output<List<DeviceClassConfigurationPatchArgs>> config;

    /**
     * @return Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
     * 
     * They are passed to the driver, but are not considered while allocating the claim.
     * 
     */
    public Optional<Output<List<DeviceClassConfigurationPatchArgs>>> config() {
        return Optional.ofNullable(this.config);
    }

    /**
     * Each selector must be satisfied by a device which is claimed via this class.
     * 
     */
    @Import(name="selectors")
    private @Nullable Output<List<DeviceSelectorPatchArgs>> selectors;

    /**
     * @return Each selector must be satisfied by a device which is claimed via this class.
     * 
     */
    public Optional<Output<List<DeviceSelectorPatchArgs>>> selectors() {
        return Optional.ofNullable(this.selectors);
    }

    /**
     * Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.
     * 
     * Setting this field is optional. If unset, all Nodes are candidates.
     * 
     * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
     * 
     */
    @Import(name="suitableNodes")
    private @Nullable Output<NodeSelectorPatchArgs> suitableNodes;

    /**
     * @return Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.
     * 
     * Setting this field is optional. If unset, all Nodes are candidates.
     * 
     * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
     * 
     */
    public Optional<Output<NodeSelectorPatchArgs>> suitableNodes() {
        return Optional.ofNullable(this.suitableNodes);
    }

    private DeviceClassSpecPatchArgs() {}

    private DeviceClassSpecPatchArgs(DeviceClassSpecPatchArgs $) {
        this.config = $.config;
        this.selectors = $.selectors;
        this.suitableNodes = $.suitableNodes;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DeviceClassSpecPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DeviceClassSpecPatchArgs $;

        public Builder() {
            $ = new DeviceClassSpecPatchArgs();
        }

        public Builder(DeviceClassSpecPatchArgs defaults) {
            $ = new DeviceClassSpecPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param config Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
         * 
         * They are passed to the driver, but are not considered while allocating the claim.
         * 
         * @return builder
         * 
         */
        public Builder config(@Nullable Output<List<DeviceClassConfigurationPatchArgs>> config) {
            $.config = config;
            return this;
        }

        /**
         * @param config Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
         * 
         * They are passed to the driver, but are not considered while allocating the claim.
         * 
         * @return builder
         * 
         */
        public Builder config(List<DeviceClassConfigurationPatchArgs> config) {
            return config(Output.of(config));
        }

        /**
         * @param config Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.
         * 
         * They are passed to the driver, but are not considered while allocating the claim.
         * 
         * @return builder
         * 
         */
        public Builder config(DeviceClassConfigurationPatchArgs... config) {
            return config(List.of(config));
        }

        /**
         * @param selectors Each selector must be satisfied by a device which is claimed via this class.
         * 
         * @return builder
         * 
         */
        public Builder selectors(@Nullable Output<List<DeviceSelectorPatchArgs>> selectors) {
            $.selectors = selectors;
            return this;
        }

        /**
         * @param selectors Each selector must be satisfied by a device which is claimed via this class.
         * 
         * @return builder
         * 
         */
        public Builder selectors(List<DeviceSelectorPatchArgs> selectors) {
            return selectors(Output.of(selectors));
        }

        /**
         * @param selectors Each selector must be satisfied by a device which is claimed via this class.
         * 
         * @return builder
         * 
         */
        public Builder selectors(DeviceSelectorPatchArgs... selectors) {
            return selectors(List.of(selectors));
        }

        /**
         * @param suitableNodes Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.
         * 
         * Setting this field is optional. If unset, all Nodes are candidates.
         * 
         * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
         * 
         * @return builder
         * 
         */
        public Builder suitableNodes(@Nullable Output<NodeSelectorPatchArgs> suitableNodes) {
            $.suitableNodes = suitableNodes;
            return this;
        }

        /**
         * @param suitableNodes Only nodes matching the selector will be considered by the scheduler when trying to find a Node that fits a Pod when that Pod uses a claim that has not been allocated yet *and* that claim gets allocated through a control plane controller. It is ignored when the claim does not use a control plane controller for allocation.
         * 
         * Setting this field is optional. If unset, all Nodes are candidates.
         * 
         * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
         * 
         * @return builder
         * 
         */
        public Builder suitableNodes(NodeSelectorPatchArgs suitableNodes) {
            return suitableNodes(Output.of(suitableNodes));
        }

        public DeviceClassSpecPatchArgs build() {
            return $;
        }
    }

}
