// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha3.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;


/**
 * DeviceRequestAllocationResult contains the allocation result for one request.
 * 
 */
public final class DeviceRequestAllocationResultArgs extends com.pulumi.resources.ResourceArgs {

    public static final DeviceRequestAllocationResultArgs Empty = new DeviceRequestAllocationResultArgs();

    /**
     * Device references one device instance via its name in the driver&#39;s resource pool. It must be a DNS label.
     * 
     */
    @Import(name="device", required=true)
    private Output<String> device;

    /**
     * @return Device references one device instance via its name in the driver&#39;s resource pool. It must be a DNS label.
     * 
     */
    public Output<String> device() {
        return this.device;
    }

    /**
     * Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
     * 
     * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
     * 
     */
    @Import(name="driver", required=true)
    private Output<String> driver;

    /**
     * @return Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
     * 
     * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
     * 
     */
    public Output<String> driver() {
        return this.driver;
    }

    /**
     * This name together with the driver name and the device name field identify which device was allocated (`&lt;driver name&gt;/&lt;pool name&gt;/&lt;device name&gt;`).
     * 
     * Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
     * 
     */
    @Import(name="pool", required=true)
    private Output<String> pool;

    /**
     * @return This name together with the driver name and the device name field identify which device was allocated (`&lt;driver name&gt;/&lt;pool name&gt;/&lt;device name&gt;`).
     * 
     * Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
     * 
     */
    public Output<String> pool() {
        return this.pool;
    }

    /**
     * Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
     * 
     */
    @Import(name="request", required=true)
    private Output<String> request;

    /**
     * @return Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
     * 
     */
    public Output<String> request() {
        return this.request;
    }

    private DeviceRequestAllocationResultArgs() {}

    private DeviceRequestAllocationResultArgs(DeviceRequestAllocationResultArgs $) {
        this.device = $.device;
        this.driver = $.driver;
        this.pool = $.pool;
        this.request = $.request;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DeviceRequestAllocationResultArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DeviceRequestAllocationResultArgs $;

        public Builder() {
            $ = new DeviceRequestAllocationResultArgs();
        }

        public Builder(DeviceRequestAllocationResultArgs defaults) {
            $ = new DeviceRequestAllocationResultArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param device Device references one device instance via its name in the driver&#39;s resource pool. It must be a DNS label.
         * 
         * @return builder
         * 
         */
        public Builder device(Output<String> device) {
            $.device = device;
            return this;
        }

        /**
         * @param device Device references one device instance via its name in the driver&#39;s resource pool. It must be a DNS label.
         * 
         * @return builder
         * 
         */
        public Builder device(String device) {
            return device(Output.of(device));
        }

        /**
         * @param driver Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
         * 
         * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
         * 
         * @return builder
         * 
         */
        public Builder driver(Output<String> driver) {
            $.driver = driver;
            return this;
        }

        /**
         * @param driver Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.
         * 
         * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
         * 
         * @return builder
         * 
         */
        public Builder driver(String driver) {
            return driver(Output.of(driver));
        }

        /**
         * @param pool This name together with the driver name and the device name field identify which device was allocated (`&lt;driver name&gt;/&lt;pool name&gt;/&lt;device name&gt;`).
         * 
         * Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
         * 
         * @return builder
         * 
         */
        public Builder pool(Output<String> pool) {
            $.pool = pool;
            return this;
        }

        /**
         * @param pool This name together with the driver name and the device name field identify which device was allocated (`&lt;driver name&gt;/&lt;pool name&gt;/&lt;device name&gt;`).
         * 
         * Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.
         * 
         * @return builder
         * 
         */
        public Builder pool(String pool) {
            return pool(Output.of(pool));
        }

        /**
         * @param request Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
         * 
         * @return builder
         * 
         */
        public Builder request(Output<String> request) {
            $.request = request;
            return this;
        }

        /**
         * @param request Request is the name of the request in the claim which caused this device to be allocated. Multiple devices may have been allocated per request.
         * 
         * @return builder
         * 
         */
        public Builder request(String request) {
            return request(Output.of(request));
        }

        public DeviceRequestAllocationResultArgs build() {
            if ($.device == null) {
                throw new MissingRequiredPropertyException("DeviceRequestAllocationResultArgs", "device");
            }
            if ($.driver == null) {
                throw new MissingRequiredPropertyException("DeviceRequestAllocationResultArgs", "driver");
            }
            if ($.pool == null) {
                throw new MissingRequiredPropertyException("DeviceRequestAllocationResultArgs", "pool");
            }
            if ($.request == null) {
                throw new MissingRequiredPropertyException("DeviceRequestAllocationResultArgs", "request");
            }
            return $;
        }
    }

}
