// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha3.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.resource.v1alpha3.inputs.DeviceSelectorPatchArgs;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.
 * 
 * A DeviceClassName is currently required. Clients must check that it is indeed set. It&#39;s absence indicates that something changed in a way that is not supported by the client yet, in which case it must refuse to handle the request.
 * 
 */
public final class DeviceRequestPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final DeviceRequestPatchArgs Empty = new DeviceRequestPatchArgs();

    /**
     * AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
     * 
     */
    @Import(name="adminAccess")
    private @Nullable Output<Boolean> adminAccess;

    /**
     * @return AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
     * 
     */
    public Optional<Output<Boolean>> adminAccess() {
        return Optional.ofNullable(this.adminAccess);
    }

    /**
     * AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
     * 
     * - ExactCount: This request is for a specific number of devices.
     * This is the default. The exact number is provided in the
     * count field.
     * 
     * - All: This request is for all of the matching devices in a pool.
     * Allocation will fail if some devices are already allocated,
     * unless adminAccess is requested.
     * 
     * If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
     * 
     * More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
     * 
     */
    @Import(name="allocationMode")
    private @Nullable Output<String> allocationMode;

    /**
     * @return AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
     * 
     * - ExactCount: This request is for a specific number of devices.
     * This is the default. The exact number is provided in the
     * count field.
     * 
     * - All: This request is for all of the matching devices in a pool.
     * Allocation will fail if some devices are already allocated,
     * unless adminAccess is requested.
     * 
     * If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
     * 
     * More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
     * 
     */
    public Optional<Output<String>> allocationMode() {
        return Optional.ofNullable(this.allocationMode);
    }

    /**
     * Count is used only when the count mode is &#34;ExactCount&#34;. Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
     * 
     */
    @Import(name="count")
    private @Nullable Output<Integer> count;

    /**
     * @return Count is used only when the count mode is &#34;ExactCount&#34;. Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
     * 
     */
    public Optional<Output<Integer>> count() {
        return Optional.ofNullable(this.count);
    }

    /**
     * DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
     * 
     * A class is required. Which classes are available depends on the cluster.
     * 
     * Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
     * 
     */
    @Import(name="deviceClassName")
    private @Nullable Output<String> deviceClassName;

    /**
     * @return DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
     * 
     * A class is required. Which classes are available depends on the cluster.
     * 
     * Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
     * 
     */
    public Optional<Output<String>> deviceClassName() {
        return Optional.ofNullable(this.deviceClassName);
    }

    /**
     * Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
     * 
     * Must be a DNS label.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
     * 
     * Must be a DNS label.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
     * 
     */
    @Import(name="selectors")
    private @Nullable Output<List<DeviceSelectorPatchArgs>> selectors;

    /**
     * @return Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
     * 
     */
    public Optional<Output<List<DeviceSelectorPatchArgs>>> selectors() {
        return Optional.ofNullable(this.selectors);
    }

    private DeviceRequestPatchArgs() {}

    private DeviceRequestPatchArgs(DeviceRequestPatchArgs $) {
        this.adminAccess = $.adminAccess;
        this.allocationMode = $.allocationMode;
        this.count = $.count;
        this.deviceClassName = $.deviceClassName;
        this.name = $.name;
        this.selectors = $.selectors;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(DeviceRequestPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private DeviceRequestPatchArgs $;

        public Builder() {
            $ = new DeviceRequestPatchArgs();
        }

        public Builder(DeviceRequestPatchArgs defaults) {
            $ = new DeviceRequestPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param adminAccess AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
         * 
         * @return builder
         * 
         */
        public Builder adminAccess(@Nullable Output<Boolean> adminAccess) {
            $.adminAccess = adminAccess;
            return this;
        }

        /**
         * @param adminAccess AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.
         * 
         * @return builder
         * 
         */
        public Builder adminAccess(Boolean adminAccess) {
            return adminAccess(Output.of(adminAccess));
        }

        /**
         * @param allocationMode AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
         * 
         * - ExactCount: This request is for a specific number of devices.
         * This is the default. The exact number is provided in the
         * count field.
         * 
         * - All: This request is for all of the matching devices in a pool.
         * Allocation will fail if some devices are already allocated,
         * unless adminAccess is requested.
         * 
         * If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
         * 
         * More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
         * 
         * @return builder
         * 
         */
        public Builder allocationMode(@Nullable Output<String> allocationMode) {
            $.allocationMode = allocationMode;
            return this;
        }

        /**
         * @param allocationMode AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:
         * 
         * - ExactCount: This request is for a specific number of devices.
         * This is the default. The exact number is provided in the
         * count field.
         * 
         * - All: This request is for all of the matching devices in a pool.
         * Allocation will fail if some devices are already allocated,
         * unless adminAccess is requested.
         * 
         * If AlloctionMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.
         * 
         * More modes may get added in the future. Clients must refuse to handle requests with unknown modes.
         * 
         * @return builder
         * 
         */
        public Builder allocationMode(String allocationMode) {
            return allocationMode(Output.of(allocationMode));
        }

        /**
         * @param count Count is used only when the count mode is &#34;ExactCount&#34;. Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
         * 
         * @return builder
         * 
         */
        public Builder count(@Nullable Output<Integer> count) {
            $.count = count;
            return this;
        }

        /**
         * @param count Count is used only when the count mode is &#34;ExactCount&#34;. Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.
         * 
         * @return builder
         * 
         */
        public Builder count(Integer count) {
            return count(Output.of(count));
        }

        /**
         * @param deviceClassName DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
         * 
         * A class is required. Which classes are available depends on the cluster.
         * 
         * Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
         * 
         * @return builder
         * 
         */
        public Builder deviceClassName(@Nullable Output<String> deviceClassName) {
            $.deviceClassName = deviceClassName;
            return this;
        }

        /**
         * @param deviceClassName DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.
         * 
         * A class is required. Which classes are available depends on the cluster.
         * 
         * Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.
         * 
         * @return builder
         * 
         */
        public Builder deviceClassName(String deviceClassName) {
            return deviceClassName(Output.of(deviceClassName));
        }

        /**
         * @param name Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
         * 
         * Must be a DNS label.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.
         * 
         * Must be a DNS label.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param selectors Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
         * 
         * @return builder
         * 
         */
        public Builder selectors(@Nullable Output<List<DeviceSelectorPatchArgs>> selectors) {
            $.selectors = selectors;
            return this;
        }

        /**
         * @param selectors Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
         * 
         * @return builder
         * 
         */
        public Builder selectors(List<DeviceSelectorPatchArgs> selectors) {
            return selectors(Output.of(selectors));
        }

        /**
         * @param selectors Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.
         * 
         * @return builder
         * 
         */
        public Builder selectors(DeviceSelectorPatchArgs... selectors) {
            return selectors(List.of(selectors));
        }

        public DeviceRequestPatchArgs build() {
            return $;
        }
    }

}
