// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha3.inputs;

import com.google.gson.JsonElement;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;


/**
 * OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.
 * 
 */
public final class OpaqueDeviceConfigurationArgs extends com.pulumi.resources.ResourceArgs {

    public static final OpaqueDeviceConfigurationArgs Empty = new OpaqueDeviceConfigurationArgs();

    /**
     * Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
     * 
     * An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
     * 
     * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
     * 
     */
    @Import(name="driver", required=true)
    private Output<String> driver;

    /**
     * @return Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
     * 
     * An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
     * 
     * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
     * 
     */
    public Output<String> driver() {
        return this.driver;
    }

    /**
     * Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version (&#34;kind&#34; + &#34;apiVersion&#34; for Kubernetes types), with conversion between different versions.
     * 
     */
    @Import(name="parameters", required=true)
    private Output<JsonElement> parameters;

    /**
     * @return Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version (&#34;kind&#34; + &#34;apiVersion&#34; for Kubernetes types), with conversion between different versions.
     * 
     */
    public Output<JsonElement> parameters() {
        return this.parameters;
    }

    private OpaqueDeviceConfigurationArgs() {}

    private OpaqueDeviceConfigurationArgs(OpaqueDeviceConfigurationArgs $) {
        this.driver = $.driver;
        this.parameters = $.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(OpaqueDeviceConfigurationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private OpaqueDeviceConfigurationArgs $;

        public Builder() {
            $ = new OpaqueDeviceConfigurationArgs();
        }

        public Builder(OpaqueDeviceConfigurationArgs defaults) {
            $ = new OpaqueDeviceConfigurationArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param driver Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
         * 
         * An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
         * 
         * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
         * 
         * @return builder
         * 
         */
        public Builder driver(Output<String> driver) {
            $.driver = driver;
            return this;
        }

        /**
         * @param driver Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.
         * 
         * An admission policy provided by the driver developer could use this to decide whether it needs to validate them.
         * 
         * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.
         * 
         * @return builder
         * 
         */
        public Builder driver(String driver) {
            return driver(Output.of(driver));
        }

        /**
         * @param parameters Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version (&#34;kind&#34; + &#34;apiVersion&#34; for Kubernetes types), with conversion between different versions.
         * 
         * @return builder
         * 
         */
        public Builder parameters(Output<JsonElement> parameters) {
            $.parameters = parameters;
            return this;
        }

        /**
         * @param parameters Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version (&#34;kind&#34; + &#34;apiVersion&#34; for Kubernetes types), with conversion between different versions.
         * 
         * @return builder
         * 
         */
        public Builder parameters(JsonElement parameters) {
            return parameters(Output.of(parameters));
        }

        public OpaqueDeviceConfigurationArgs build() {
            if ($.driver == null) {
                throw new MissingRequiredPropertyException("OpaqueDeviceConfigurationArgs", "driver");
            }
            if ($.parameters == null) {
                throw new MissingRequiredPropertyException("OpaqueDeviceConfigurationArgs", "parameters");
            }
            return $;
        }
    }

}
