// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha3.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.resource.v1alpha3.inputs.AllocationResultArgs;
import com.pulumi.kubernetes.resource.v1alpha3.inputs.ResourceClaimConsumerReferenceArgs;
import java.lang.Boolean;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.
 * 
 */
public final class ResourceClaimStatusArgs extends com.pulumi.resources.ResourceArgs {

    public static final ResourceClaimStatusArgs Empty = new ResourceClaimStatusArgs();

    /**
     * Allocation is set once the claim has been allocated successfully.
     * 
     */
    @Import(name="allocation")
    private @Nullable Output<AllocationResultArgs> allocation;

    /**
     * @return Allocation is set once the claim has been allocated successfully.
     * 
     */
    public Optional<Output<AllocationResultArgs>> allocation() {
        return Optional.ofNullable(this.allocation);
    }

    /**
     * Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
     * 
     * This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
     * 
     * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
     * 
     */
    @Import(name="deallocationRequested")
    private @Nullable Output<Boolean> deallocationRequested;

    /**
     * @return Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
     * 
     * This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
     * 
     * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
     * 
     */
    public Optional<Output<Boolean>> deallocationRequested() {
        return Optional.ofNullable(this.deallocationRequested);
    }

    /**
     * ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
     * 
     * In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
     * 
     * Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
     * 
     * There can be at most 32 such reservations. This may get increased in the future, but not reduced.
     * 
     */
    @Import(name="reservedFor")
    private @Nullable Output<List<ResourceClaimConsumerReferenceArgs>> reservedFor;

    /**
     * @return ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
     * 
     * In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
     * 
     * Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
     * 
     * There can be at most 32 such reservations. This may get increased in the future, but not reduced.
     * 
     */
    public Optional<Output<List<ResourceClaimConsumerReferenceArgs>>> reservedFor() {
        return Optional.ofNullable(this.reservedFor);
    }

    private ResourceClaimStatusArgs() {}

    private ResourceClaimStatusArgs(ResourceClaimStatusArgs $) {
        this.allocation = $.allocation;
        this.deallocationRequested = $.deallocationRequested;
        this.reservedFor = $.reservedFor;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ResourceClaimStatusArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ResourceClaimStatusArgs $;

        public Builder() {
            $ = new ResourceClaimStatusArgs();
        }

        public Builder(ResourceClaimStatusArgs defaults) {
            $ = new ResourceClaimStatusArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allocation Allocation is set once the claim has been allocated successfully.
         * 
         * @return builder
         * 
         */
        public Builder allocation(@Nullable Output<AllocationResultArgs> allocation) {
            $.allocation = allocation;
            return this;
        }

        /**
         * @param allocation Allocation is set once the claim has been allocated successfully.
         * 
         * @return builder
         * 
         */
        public Builder allocation(AllocationResultArgs allocation) {
            return allocation(Output.of(allocation));
        }

        /**
         * @param deallocationRequested Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
         * 
         * This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
         * 
         * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
         * 
         * @return builder
         * 
         */
        public Builder deallocationRequested(@Nullable Output<Boolean> deallocationRequested) {
            $.deallocationRequested = deallocationRequested;
            return this;
        }

        /**
         * @param deallocationRequested Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
         * 
         * This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
         * 
         * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
         * 
         * @return builder
         * 
         */
        public Builder deallocationRequested(Boolean deallocationRequested) {
            return deallocationRequested(Output.of(deallocationRequested));
        }

        /**
         * @param reservedFor ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
         * 
         * In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
         * 
         * Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
         * 
         * There can be at most 32 such reservations. This may get increased in the future, but not reduced.
         * 
         * @return builder
         * 
         */
        public Builder reservedFor(@Nullable Output<List<ResourceClaimConsumerReferenceArgs>> reservedFor) {
            $.reservedFor = reservedFor;
            return this;
        }

        /**
         * @param reservedFor ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
         * 
         * In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
         * 
         * Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
         * 
         * There can be at most 32 such reservations. This may get increased in the future, but not reduced.
         * 
         * @return builder
         * 
         */
        public Builder reservedFor(List<ResourceClaimConsumerReferenceArgs> reservedFor) {
            return reservedFor(Output.of(reservedFor));
        }

        /**
         * @param reservedFor ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
         * 
         * In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
         * 
         * Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
         * 
         * There can be at most 32 such reservations. This may get increased in the future, but not reduced.
         * 
         * @return builder
         * 
         */
        public Builder reservedFor(ResourceClaimConsumerReferenceArgs... reservedFor) {
            return reservedFor(List.of(reservedFor));
        }

        public ResourceClaimStatusArgs build() {
            return $;
        }
    }

}
