// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha3.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.inputs.NodeSelectorArgs;
import com.pulumi.kubernetes.resource.v1alpha3.inputs.DeviceArgs;
import com.pulumi.kubernetes.resource.v1alpha3.inputs.ResourcePoolArgs;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
 * 
 */
public final class ResourceSliceSpecArgs extends com.pulumi.resources.ResourceArgs {

    public static final ResourceSliceSpecArgs Empty = new ResourceSliceSpecArgs();

    /**
     * AllNodes indicates that all nodes have access to the resources in the pool.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set.
     * 
     */
    @Import(name="allNodes")
    private @Nullable Output<Boolean> allNodes;

    /**
     * @return AllNodes indicates that all nodes have access to the resources in the pool.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set.
     * 
     */
    public Optional<Output<Boolean>> allNodes() {
        return Optional.ofNullable(this.allNodes);
    }

    /**
     * Devices lists some or all of the devices in this pool.
     * 
     * Must not have more than 128 entries.
     * 
     */
    @Import(name="devices")
    private @Nullable Output<List<DeviceArgs>> devices;

    /**
     * @return Devices lists some or all of the devices in this pool.
     * 
     * Must not have more than 128 entries.
     * 
     */
    public Optional<Output<List<DeviceArgs>>> devices() {
        return Optional.ofNullable(this.devices);
    }

    /**
     * Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
     * 
     * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
     * 
     */
    @Import(name="driver", required=true)
    private Output<String> driver;

    /**
     * @return Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
     * 
     * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
     * 
     */
    public Output<String> driver() {
        return this.driver;
    }

    /**
     * NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
     * 
     * This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
     * 
     */
    @Import(name="nodeName")
    private @Nullable Output<String> nodeName;

    /**
     * @return NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
     * 
     * This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
     * 
     */
    public Optional<Output<String>> nodeName() {
        return Optional.ofNullable(this.nodeName);
    }

    /**
     * NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
     * 
     * Must use exactly one term.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set.
     * 
     */
    @Import(name="nodeSelector")
    private @Nullable Output<NodeSelectorArgs> nodeSelector;

    /**
     * @return NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
     * 
     * Must use exactly one term.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set.
     * 
     */
    public Optional<Output<NodeSelectorArgs>> nodeSelector() {
        return Optional.ofNullable(this.nodeSelector);
    }

    /**
     * Pool describes the pool that this ResourceSlice belongs to.
     * 
     */
    @Import(name="pool", required=true)
    private Output<ResourcePoolArgs> pool;

    /**
     * @return Pool describes the pool that this ResourceSlice belongs to.
     * 
     */
    public Output<ResourcePoolArgs> pool() {
        return this.pool;
    }

    private ResourceSliceSpecArgs() {}

    private ResourceSliceSpecArgs(ResourceSliceSpecArgs $) {
        this.allNodes = $.allNodes;
        this.devices = $.devices;
        this.driver = $.driver;
        this.nodeName = $.nodeName;
        this.nodeSelector = $.nodeSelector;
        this.pool = $.pool;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ResourceSliceSpecArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ResourceSliceSpecArgs $;

        public Builder() {
            $ = new ResourceSliceSpecArgs();
        }

        public Builder(ResourceSliceSpecArgs defaults) {
            $ = new ResourceSliceSpecArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allNodes AllNodes indicates that all nodes have access to the resources in the pool.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set.
         * 
         * @return builder
         * 
         */
        public Builder allNodes(@Nullable Output<Boolean> allNodes) {
            $.allNodes = allNodes;
            return this;
        }

        /**
         * @param allNodes AllNodes indicates that all nodes have access to the resources in the pool.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set.
         * 
         * @return builder
         * 
         */
        public Builder allNodes(Boolean allNodes) {
            return allNodes(Output.of(allNodes));
        }

        /**
         * @param devices Devices lists some or all of the devices in this pool.
         * 
         * Must not have more than 128 entries.
         * 
         * @return builder
         * 
         */
        public Builder devices(@Nullable Output<List<DeviceArgs>> devices) {
            $.devices = devices;
            return this;
        }

        /**
         * @param devices Devices lists some or all of the devices in this pool.
         * 
         * Must not have more than 128 entries.
         * 
         * @return builder
         * 
         */
        public Builder devices(List<DeviceArgs> devices) {
            return devices(Output.of(devices));
        }

        /**
         * @param devices Devices lists some or all of the devices in this pool.
         * 
         * Must not have more than 128 entries.
         * 
         * @return builder
         * 
         */
        public Builder devices(DeviceArgs... devices) {
            return devices(List.of(devices));
        }

        /**
         * @param driver Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
         * 
         * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
         * 
         * @return builder
         * 
         */
        public Builder driver(Output<String> driver) {
            $.driver = driver;
            return this;
        }

        /**
         * @param driver Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
         * 
         * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
         * 
         * @return builder
         * 
         */
        public Builder driver(String driver) {
            return driver(Output.of(driver));
        }

        /**
         * @param nodeName NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
         * 
         * This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
         * 
         * @return builder
         * 
         */
        public Builder nodeName(@Nullable Output<String> nodeName) {
            $.nodeName = nodeName;
            return this;
        }

        /**
         * @param nodeName NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
         * 
         * This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
         * 
         * @return builder
         * 
         */
        public Builder nodeName(String nodeName) {
            return nodeName(Output.of(nodeName));
        }

        /**
         * @param nodeSelector NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
         * 
         * Must use exactly one term.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set.
         * 
         * @return builder
         * 
         */
        public Builder nodeSelector(@Nullable Output<NodeSelectorArgs> nodeSelector) {
            $.nodeSelector = nodeSelector;
            return this;
        }

        /**
         * @param nodeSelector NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
         * 
         * Must use exactly one term.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set.
         * 
         * @return builder
         * 
         */
        public Builder nodeSelector(NodeSelectorArgs nodeSelector) {
            return nodeSelector(Output.of(nodeSelector));
        }

        /**
         * @param pool Pool describes the pool that this ResourceSlice belongs to.
         * 
         * @return builder
         * 
         */
        public Builder pool(Output<ResourcePoolArgs> pool) {
            $.pool = pool;
            return this;
        }

        /**
         * @param pool Pool describes the pool that this ResourceSlice belongs to.
         * 
         * @return builder
         * 
         */
        public Builder pool(ResourcePoolArgs pool) {
            return pool(Output.of(pool));
        }

        public ResourceSliceSpecArgs build() {
            if ($.driver == null) {
                throw new MissingRequiredPropertyException("ResourceSliceSpecArgs", "driver");
            }
            if ($.pool == null) {
                throw new MissingRequiredPropertyException("ResourceSliceSpecArgs", "pool");
            }
            return $;
        }
    }

}
