// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha3.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.kubernetes.core.v1.inputs.NodeSelectorPatchArgs;
import com.pulumi.kubernetes.resource.v1alpha3.inputs.DevicePatchArgs;
import com.pulumi.kubernetes.resource.v1alpha3.inputs.ResourcePoolPatchArgs;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


/**
 * ResourceSliceSpec contains the information published by the driver in one ResourceSlice.
 * 
 */
public final class ResourceSliceSpecPatchArgs extends com.pulumi.resources.ResourceArgs {

    public static final ResourceSliceSpecPatchArgs Empty = new ResourceSliceSpecPatchArgs();

    /**
     * AllNodes indicates that all nodes have access to the resources in the pool.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set.
     * 
     */
    @Import(name="allNodes")
    private @Nullable Output<Boolean> allNodes;

    /**
     * @return AllNodes indicates that all nodes have access to the resources in the pool.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set.
     * 
     */
    public Optional<Output<Boolean>> allNodes() {
        return Optional.ofNullable(this.allNodes);
    }

    /**
     * Devices lists some or all of the devices in this pool.
     * 
     * Must not have more than 128 entries.
     * 
     */
    @Import(name="devices")
    private @Nullable Output<List<DevicePatchArgs>> devices;

    /**
     * @return Devices lists some or all of the devices in this pool.
     * 
     * Must not have more than 128 entries.
     * 
     */
    public Optional<Output<List<DevicePatchArgs>>> devices() {
        return Optional.ofNullable(this.devices);
    }

    /**
     * Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
     * 
     * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
     * 
     */
    @Import(name="driver")
    private @Nullable Output<String> driver;

    /**
     * @return Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
     * 
     * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
     * 
     */
    public Optional<Output<String>> driver() {
        return Optional.ofNullable(this.driver);
    }

    /**
     * NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
     * 
     * This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
     * 
     */
    @Import(name="nodeName")
    private @Nullable Output<String> nodeName;

    /**
     * @return NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
     * 
     * This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
     * 
     */
    public Optional<Output<String>> nodeName() {
        return Optional.ofNullable(this.nodeName);
    }

    /**
     * NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
     * 
     * Must use exactly one term.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set.
     * 
     */
    @Import(name="nodeSelector")
    private @Nullable Output<NodeSelectorPatchArgs> nodeSelector;

    /**
     * @return NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
     * 
     * Must use exactly one term.
     * 
     * Exactly one of NodeName, NodeSelector and AllNodes must be set.
     * 
     */
    public Optional<Output<NodeSelectorPatchArgs>> nodeSelector() {
        return Optional.ofNullable(this.nodeSelector);
    }

    /**
     * Pool describes the pool that this ResourceSlice belongs to.
     * 
     */
    @Import(name="pool")
    private @Nullable Output<ResourcePoolPatchArgs> pool;

    /**
     * @return Pool describes the pool that this ResourceSlice belongs to.
     * 
     */
    public Optional<Output<ResourcePoolPatchArgs>> pool() {
        return Optional.ofNullable(this.pool);
    }

    private ResourceSliceSpecPatchArgs() {}

    private ResourceSliceSpecPatchArgs(ResourceSliceSpecPatchArgs $) {
        this.allNodes = $.allNodes;
        this.devices = $.devices;
        this.driver = $.driver;
        this.nodeName = $.nodeName;
        this.nodeSelector = $.nodeSelector;
        this.pool = $.pool;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ResourceSliceSpecPatchArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ResourceSliceSpecPatchArgs $;

        public Builder() {
            $ = new ResourceSliceSpecPatchArgs();
        }

        public Builder(ResourceSliceSpecPatchArgs defaults) {
            $ = new ResourceSliceSpecPatchArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param allNodes AllNodes indicates that all nodes have access to the resources in the pool.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set.
         * 
         * @return builder
         * 
         */
        public Builder allNodes(@Nullable Output<Boolean> allNodes) {
            $.allNodes = allNodes;
            return this;
        }

        /**
         * @param allNodes AllNodes indicates that all nodes have access to the resources in the pool.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set.
         * 
         * @return builder
         * 
         */
        public Builder allNodes(Boolean allNodes) {
            return allNodes(Output.of(allNodes));
        }

        /**
         * @param devices Devices lists some or all of the devices in this pool.
         * 
         * Must not have more than 128 entries.
         * 
         * @return builder
         * 
         */
        public Builder devices(@Nullable Output<List<DevicePatchArgs>> devices) {
            $.devices = devices;
            return this;
        }

        /**
         * @param devices Devices lists some or all of the devices in this pool.
         * 
         * Must not have more than 128 entries.
         * 
         * @return builder
         * 
         */
        public Builder devices(List<DevicePatchArgs> devices) {
            return devices(Output.of(devices));
        }

        /**
         * @param devices Devices lists some or all of the devices in this pool.
         * 
         * Must not have more than 128 entries.
         * 
         * @return builder
         * 
         */
        public Builder devices(DevicePatchArgs... devices) {
            return devices(List.of(devices));
        }

        /**
         * @param driver Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
         * 
         * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
         * 
         * @return builder
         * 
         */
        public Builder driver(@Nullable Output<String> driver) {
            $.driver = driver;
            return this;
        }

        /**
         * @param driver Driver identifies the DRA driver providing the capacity information. A field selector can be used to list only ResourceSlice objects with a certain driver name.
         * 
         * Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver. This field is immutable.
         * 
         * @return builder
         * 
         */
        public Builder driver(String driver) {
            return driver(Output.of(driver));
        }

        /**
         * @param nodeName NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
         * 
         * This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
         * 
         * @return builder
         * 
         */
        public Builder nodeName(@Nullable Output<String> nodeName) {
            $.nodeName = nodeName;
            return this;
        }

        /**
         * @param nodeName NodeName identifies the node which provides the resources in this pool. A field selector can be used to list only ResourceSlice objects belonging to a certain node.
         * 
         * This field can be used to limit access from nodes to ResourceSlices with the same node name. It also indicates to autoscalers that adding new nodes of the same type as some old node might also make new resources available.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set. This field is immutable.
         * 
         * @return builder
         * 
         */
        public Builder nodeName(String nodeName) {
            return nodeName(Output.of(nodeName));
        }

        /**
         * @param nodeSelector NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
         * 
         * Must use exactly one term.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set.
         * 
         * @return builder
         * 
         */
        public Builder nodeSelector(@Nullable Output<NodeSelectorPatchArgs> nodeSelector) {
            $.nodeSelector = nodeSelector;
            return this;
        }

        /**
         * @param nodeSelector NodeSelector defines which nodes have access to the resources in the pool, when that pool is not limited to a single node.
         * 
         * Must use exactly one term.
         * 
         * Exactly one of NodeName, NodeSelector and AllNodes must be set.
         * 
         * @return builder
         * 
         */
        public Builder nodeSelector(NodeSelectorPatchArgs nodeSelector) {
            return nodeSelector(Output.of(nodeSelector));
        }

        /**
         * @param pool Pool describes the pool that this ResourceSlice belongs to.
         * 
         * @return builder
         * 
         */
        public Builder pool(@Nullable Output<ResourcePoolPatchArgs> pool) {
            $.pool = pool;
            return this;
        }

        /**
         * @param pool Pool describes the pool that this ResourceSlice belongs to.
         * 
         * @return builder
         * 
         */
        public Builder pool(ResourcePoolPatchArgs pool) {
            return pool(Output.of(pool));
        }

        public ResourceSliceSpecPatchArgs build() {
            return $;
        }
    }

}
