// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha3.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.kubernetes.resource.v1alpha3.outputs.AllocationResultPatch;
import com.pulumi.kubernetes.resource.v1alpha3.outputs.ResourceClaimConsumerReferencePatch;
import java.lang.Boolean;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourceClaimStatusPatch {
    /**
     * @return Allocation is set once the claim has been allocated successfully.
     * 
     */
    private @Nullable AllocationResultPatch allocation;
    /**
     * @return Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
     * 
     * This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
     * 
     * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
     * 
     */
    private @Nullable Boolean deallocationRequested;
    /**
     * @return ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
     * 
     * In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
     * 
     * Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
     * 
     * There can be at most 32 such reservations. This may get increased in the future, but not reduced.
     * 
     */
    private @Nullable List<ResourceClaimConsumerReferencePatch> reservedFor;

    private ResourceClaimStatusPatch() {}
    /**
     * @return Allocation is set once the claim has been allocated successfully.
     * 
     */
    public Optional<AllocationResultPatch> allocation() {
        return Optional.ofNullable(this.allocation);
    }
    /**
     * @return Indicates that a claim is to be deallocated. While this is set, no new consumers may be added to ReservedFor.
     * 
     * This is only used if the claim needs to be deallocated by a DRA driver. That driver then must deallocate this claim and reset the field together with clearing the Allocation field.
     * 
     * This is an alpha field and requires enabling the DRAControlPlaneController feature gate.
     * 
     */
    public Optional<Boolean> deallocationRequested() {
        return Optional.ofNullable(this.deallocationRequested);
    }
    /**
     * @return ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.
     * 
     * In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.
     * 
     * Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.
     * 
     * There can be at most 32 such reservations. This may get increased in the future, but not reduced.
     * 
     */
    public List<ResourceClaimConsumerReferencePatch> reservedFor() {
        return this.reservedFor == null ? List.of() : this.reservedFor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourceClaimStatusPatch defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable AllocationResultPatch allocation;
        private @Nullable Boolean deallocationRequested;
        private @Nullable List<ResourceClaimConsumerReferencePatch> reservedFor;
        public Builder() {}
        public Builder(ResourceClaimStatusPatch defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.allocation = defaults.allocation;
    	      this.deallocationRequested = defaults.deallocationRequested;
    	      this.reservedFor = defaults.reservedFor;
        }

        @CustomType.Setter
        public Builder allocation(@Nullable AllocationResultPatch allocation) {

            this.allocation = allocation;
            return this;
        }
        @CustomType.Setter
        public Builder deallocationRequested(@Nullable Boolean deallocationRequested) {

            this.deallocationRequested = deallocationRequested;
            return this;
        }
        @CustomType.Setter
        public Builder reservedFor(@Nullable List<ResourceClaimConsumerReferencePatch> reservedFor) {

            this.reservedFor = reservedFor;
            return this;
        }
        public Builder reservedFor(ResourceClaimConsumerReferencePatch... reservedFor) {
            return reservedFor(List.of(reservedFor));
        }
        public ResourceClaimStatusPatch build() {
            final var _resultValue = new ResourceClaimStatusPatch();
            _resultValue.allocation = allocation;
            _resultValue.deallocationRequested = deallocationRequested;
            _resultValue.reservedFor = reservedFor;
            return _resultValue;
        }
    }
}
