// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.resource.v1alpha3.outputs;

import com.pulumi.core.annotations.CustomType;
import java.lang.Integer;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ResourcePoolPatch {
    /**
     * @return Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.
     * 
     * Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
     * 
     */
    private @Nullable Integer generation;
    /**
     * @return Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.
     * 
     * It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
     * 
     */
    private @Nullable String name;
    /**
     * @return ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.
     * 
     * Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
     * 
     */
    private @Nullable Integer resourceSliceCount;

    private ResourcePoolPatch() {}
    /**
     * @return Generation tracks the change in a pool over time. Whenever a driver changes something about one or more of the resources in a pool, it must change the generation in all ResourceSlices which are part of that pool. Consumers of ResourceSlices should only consider resources from the pool with the highest generation number. The generation may be reset by drivers, which should be fine for consumers, assuming that all ResourceSlices in a pool are updated to match or deleted.
     * 
     * Combined with ResourceSliceCount, this mechanism enables consumers to detect pools which are comprised of multiple ResourceSlices and are in an incomplete state.
     * 
     */
    public Optional<Integer> generation() {
        return Optional.ofNullable(this.generation);
    }
    /**
     * @return Name is used to identify the pool. For node-local devices, this is often the node name, but this is not required.
     * 
     * It must not be longer than 253 characters and must consist of one or more DNS sub-domains separated by slashes. This field is immutable.
     * 
     */
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }
    /**
     * @return ResourceSliceCount is the total number of ResourceSlices in the pool at this generation number. Must be greater than zero.
     * 
     * Consumers can use this to check whether they have seen all ResourceSlices belonging to the same pool.
     * 
     */
    public Optional<Integer> resourceSliceCount() {
        return Optional.ofNullable(this.resourceSliceCount);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ResourcePoolPatch defaults) {
        return new Builder(defaults);
    }
    @CustomType.Builder
    public static final class Builder {
        private @Nullable Integer generation;
        private @Nullable String name;
        private @Nullable Integer resourceSliceCount;
        public Builder() {}
        public Builder(ResourcePoolPatch defaults) {
    	      Objects.requireNonNull(defaults);
    	      this.generation = defaults.generation;
    	      this.name = defaults.name;
    	      this.resourceSliceCount = defaults.resourceSliceCount;
        }

        @CustomType.Setter
        public Builder generation(@Nullable Integer generation) {

            this.generation = generation;
            return this;
        }
        @CustomType.Setter
        public Builder name(@Nullable String name) {

            this.name = name;
            return this;
        }
        @CustomType.Setter
        public Builder resourceSliceCount(@Nullable Integer resourceSliceCount) {

            this.resourceSliceCount = resourceSliceCount;
            return this;
        }
        public ResourcePoolPatch build() {
            final var _resultValue = new ResourcePoolPatch();
            _resultValue.generation = generation;
            _resultValue.name = name;
            _resultValue.resourceSliceCount = resourceSliceCount;
            return _resultValue;
        }
    }
}
