// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.kubernetes.yaml.v2;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.kubernetes.Utilities;
import com.pulumi.kubernetes.yaml.v2.ConfigGroupArgs;
import java.lang.Object;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * ConfigGroup creates a set of Kubernetes resources from Kubernetes YAML text. The YAML text
 * may be supplied using any of the following methods:
 * 
 * 1. Using a filename or a list of filenames:
 * 2. Using a file pattern or a list of file patterns:
 * 3. Using a literal string containing YAML, or a list of such strings:
 * 4. Any combination of files, patterns, or YAML strings:
 * 
 * ## Dependency ordering
 * Sometimes resources must be applied in a specific order. For example, a namespace resource must be
 * created before any namespaced resources, or a Custom Resource Definition (CRD) must be pre-installed.
 * 
 * Pulumi uses heuristics to determine which order to apply and delete objects within the ConfigGroup.  Pulumi also
 * waits for each object to be fully reconciled, unless `skipAwait` is enabled.
 * 
 * ### Explicit Dependency Ordering
 * Pulumi supports the `config.kubernetes.io/depends-on` annotation to declare an explicit dependency on a given resource.
 * The annotation accepts a list of resource references, delimited by commas.
 * 
 * Note that references to resources outside the ConfigGroup aren&#39;t supported.
 * 
 * **Resource reference**
 * 
 * A resource reference is a string that uniquely identifies a resource.
 * 
 * It consists of the group, kind, name, and optionally the namespace, delimited by forward slashes.
 * 
 * | Resource Scope   | Format                                         |
 * | :--------------- | :--------------------------------------------- |
 * | namespace-scoped | `&lt;group&gt;/namespaces/&lt;namespace&gt;/&lt;kind&gt;/&lt;name&gt;` |
 * | cluster-scoped   | `&lt;group&gt;/&lt;kind&gt;/&lt;name&gt;`                        |
 * 
 * For resources in the “core” group, the empty string is used instead (for example: `/namespaces/test/Pod/pod-a`).
 * 
 * ### Ordering across ConfigGroups
 * The `dependsOn` resource option creates a list of explicit dependencies between Pulumi resources.
 * Use it on another resource to make it dependent on the ConfigGroup and to wait for the resources within
 * the group to be deployed.
 * 
 * A best practice is to deploy each application using its own ConfigGroup, especially when that application
 * installs custom resource definitions.
 * 
 * ## Example Usage
 * ### Local File(s)
 * <pre>
 * {@code
 * package myproject;
 * 
 * import com.pulumi.Pulumi;
 * import com.pulumi.kubernetes.yaml.v2.ConfigGroup;
 * import com.pulumi.kubernetes.yaml.v2.ConfigGroupArgs;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(ctx -> {
 *             var example = new ConfigGroup("example", ConfigGroupArgs.builder()
 *                     .files("./manifest.yaml")
 *                     .build());
 *         });
 *     }
 * }
 * }
 * </pre>
 * ### Local File Pattern
 * <pre>
 * {@code
 * package myproject;
 * 
 * import com.pulumi.Pulumi;
 * import com.pulumi.kubernetes.yaml.v2.ConfigGroup;
 * import com.pulumi.kubernetes.yaml.v2.ConfigGroupArgs;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(ctx -> {
 *             var example = new ConfigGroup("example", ConfigGroupArgs.builder()
 *                     .files("./manifests/*.yaml")
 *                     .build());
 *         });
 *     }
 * }
 * }
 * </pre>
 * {{% /example %}}
 * ### Literal YAML String
 * <pre>
 * {@code
 * package myproject;
 * 
 * import com.pulumi.Pulumi;
 * import com.pulumi.kubernetes.yaml.v2.ConfigGroup;
 * import com.pulumi.kubernetes.yaml.v2.ConfigGroupArgs;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(ctx -> {
 *             var example = new ConfigGroup("example", ConfigGroupArgs.builder()
 *                     .yaml("""
 *                         apiVersion: v1
 *                         kind: ConfigMap
 *                         metadata:
 *                           name: my-map
 *                         """
 *                     )
 *                     .build());
 *         });
 *     }
 * }
 * }
 * </pre>
 * ### Literal Object
 * <pre>
 * {@code
 * package myproject;
 * 
 * import java.util.Map;
 * 
 * import com.pulumi.Pulumi;
 * import com.pulumi.kubernetes.yaml.v2.ConfigGroup;
 * import com.pulumi.kubernetes.yaml.v2.ConfigGroupArgs;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(ctx -> {
 *             var example = new ConfigGroup("example", ConfigGroupArgs.builder()
 *                     .objs(Map.ofEntries(
 *                         Map.entry("apiVersion", "v1"),
 *                         Map.entry("kind", "ConfigMap"),
 *                         Map.entry("metadata", Map.ofEntries(
 *                             Map.entry("name", "my-map")
 *                         ))
 *                     ))
 *                     .build());
 *         });
 *     }
 * }
 * }
 * </pre>
 * {% /examples %}}
 * 
 */
@ResourceType(type="kubernetes:yaml/v2:ConfigGroup")
public class ConfigGroup extends com.pulumi.resources.ComponentResource {
    /**
     * Resources created by the ConfigGroup.
     * 
     */
    @Export(name="resources", refs={List.class,Object.class}, tree="[0,1]")
    private Output</* @Nullable */ List<Object>> resources;

    /**
     * @return Resources created by the ConfigGroup.
     * 
     */
    public Output<Optional<List<Object>>> resources() {
        return Codegen.optional(this.resources);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ConfigGroup(String name) {
        this(name, ConfigGroupArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ConfigGroup(String name, @Nullable ConfigGroupArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ConfigGroup(String name, @Nullable ConfigGroupArgs args, @Nullable com.pulumi.resources.ComponentResourceOptions options) {
        super("kubernetes:yaml/v2:ConfigGroup", name, makeArgs(args, options), makeResourceOptions(options, Codegen.empty()), true);
    }

    private static ConfigGroupArgs makeArgs(@Nullable ConfigGroupArgs args, @Nullable com.pulumi.resources.ComponentResourceOptions options) {
        if (options != null && options.getUrn().isPresent()) {
            return null;
        }
        return args == null ? ConfigGroupArgs.Empty : args;
    }

    private static com.pulumi.resources.ComponentResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.ComponentResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.ComponentResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.ComponentResourceOptions.merge(defaultOptions, options, id);
    }

}
