/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.mysql;

import com.pulumi.core.Either;
import com.pulumi.core.internal.Environment;
import com.pulumi.deployment.InvokeOptions;
import com.pulumi.resources.ProviderResource;
import com.pulumi.resources.Resource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Utilities {
    private static final String version;

    public static Optional<String> getEnv(String ... names) {
        for (String n : names) {
            Either value = Environment.getEnvironmentVariable((String)n);
            if (!value.isValue()) continue;
            return Optional.of((String)value.value());
        }
        return Optional.empty();
    }

    public static Optional<Boolean> getEnvBoolean(String ... names) {
        for (String n : names) {
            Either value = Environment.getBooleanEnvironmentVariable((String)n);
            if (!value.isValue()) continue;
            return Optional.of((Boolean)value.value());
        }
        return Optional.empty();
    }

    public static Optional<Integer> getEnvInteger(String ... names) {
        for (String n : names) {
            Either value = Environment.getIntegerEnvironmentVariable((String)n);
            if (!value.isValue()) continue;
            return Optional.of((Integer)value.value());
        }
        return Optional.empty();
    }

    public static Optional<Double> getEnvDouble(String ... names) {
        for (String n : names) {
            Either value = Environment.getDoubleEnvironmentVariable((String)n);
            if (!value.isValue()) continue;
            return Optional.of((Double)value.value());
        }
        return Optional.empty();
    }

    public static InvokeOptions withVersion(@Nullable InvokeOptions options) {
        if (options != null && options.getVersion().isPresent()) {
            return options;
        }
        return new InvokeOptions(options == null ? null : (Resource)options.getParent().orElse(null), options == null ? null : (ProviderResource)options.getProvider().orElse(null), Utilities.getVersion());
    }

    public static String getVersion() {
        return version;
    }

    static {
        String resourceName = "com/pulumi/mysql/version.txt";
        InputStream versionFile = Utilities.class.getClassLoader().getResourceAsStream(resourceName);
        if (versionFile == null) {
            throw new IllegalStateException(String.format("expected resource '%s' on Classpath, not found", resourceName));
        }
        version = new BufferedReader(new InputStreamReader(versionFile)).lines().collect(Collectors.joining("\n")).trim();
    }
}

