// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.blockstorage;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.blockstorage.VolumeTypeAccessV3Args;
import com.pulumi.openstack.blockstorage.inputs.VolumeTypeAccessV3State;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages a V3 block storage volume type access resource within OpenStack.
 * 
 * &gt; **Note:** This usually requires admin privileges.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.identity.Project;
 * import com.pulumi.openstack.blockstorage.VolumeTypeV3;
 * import com.pulumi.openstack.blockstorage.VolumeTypeV3Args;
 * import com.pulumi.openstack.blockstorage.VolumeTypeAccessV3;
 * import com.pulumi.openstack.blockstorage.VolumeTypeAccessV3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var project1 = new Project(&#34;project1&#34;);
 * 
 *         var volumeType1 = new VolumeTypeV3(&#34;volumeType1&#34;, VolumeTypeV3Args.builder()        
 *             .isPublic(false)
 *             .build());
 * 
 *         var volumeTypeAccess = new VolumeTypeAccessV3(&#34;volumeTypeAccess&#34;, VolumeTypeAccessV3Args.builder()        
 *             .projectId(project1.id())
 *             .volumeTypeId(volumeType1.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Volume types access can be imported using the `volume_type_id/project_id`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:blockstorage/volumeTypeAccessV3:VolumeTypeAccessV3 volume_type_access 941793f0-0a34-4bc4-b72e-a6326ae58283/ed498e81f0cc448bae0ad4f8f21bf67f
 * ```
 * 
 */
@ResourceType(type="openstack:blockstorage/volumeTypeAccessV3:VolumeTypeAccessV3")
public class VolumeTypeAccessV3 extends com.pulumi.resources.CustomResource {
    /**
     * ID of the project to give access to. Changing this
     * creates a new resource.
     * 
     */
    @Export(name="projectId", refs={String.class}, tree="[0]")
    private Output<String> projectId;

    /**
     * @return ID of the project to give access to. Changing this
     * creates a new resource.
     * 
     */
    public Output<String> projectId() {
        return this.projectId;
    }
    /**
     * The region in which to create the volume. If
     * omitted, the `region` argument of the provider is used. Changing this
     * creates a new quotaset.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to create the volume. If
     * omitted, the `region` argument of the provider is used. Changing this
     * creates a new quotaset.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * ID of the volume type to give access to. Changing
     * this creates a new resource.
     * 
     */
    @Export(name="volumeTypeId", refs={String.class}, tree="[0]")
    private Output<String> volumeTypeId;

    /**
     * @return ID of the volume type to give access to. Changing
     * this creates a new resource.
     * 
     */
    public Output<String> volumeTypeId() {
        return this.volumeTypeId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VolumeTypeAccessV3(String name) {
        this(name, VolumeTypeAccessV3Args.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VolumeTypeAccessV3(String name, VolumeTypeAccessV3Args args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VolumeTypeAccessV3(String name, VolumeTypeAccessV3Args args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:blockstorage/volumeTypeAccessV3:VolumeTypeAccessV3", name, args == null ? VolumeTypeAccessV3Args.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VolumeTypeAccessV3(String name, Output<String> id, @Nullable VolumeTypeAccessV3State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:blockstorage/volumeTypeAccessV3:VolumeTypeAccessV3", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VolumeTypeAccessV3 get(String name, Output<String> id, @Nullable VolumeTypeAccessV3State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VolumeTypeAccessV3(name, id, state, options);
    }
}
