// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.blockstorage;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.blockstorage.VolumeTypeV3Args;
import com.pulumi.openstack.blockstorage.inputs.VolumeTypeV3State;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import javax.annotation.Nullable;

/**
 * Manages a V3 block storage volume type resource within OpenStack.
 * 
 * &gt; **Note:** This usually requires admin privileges.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.blockstorage.VolumeTypeV3;
 * import com.pulumi.openstack.blockstorage.VolumeTypeV3Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var volumeType1 = new VolumeTypeV3(&#34;volumeType1&#34;, VolumeTypeV3Args.builder()        
 *             .description(&#34;Volume type 1&#34;)
 *             .extraSpecs(Map.ofEntries(
 *                 Map.entry(&#34;capabilities&#34;, &#34;gpu&#34;),
 *                 Map.entry(&#34;volume_backend_name&#34;, &#34;ssd&#34;)
 *             ))
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Volume types can be imported using the `volume_type_id`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:blockstorage/volumeTypeV3:VolumeTypeV3 volume_type_1 941793f0-0a34-4bc4-b72e-a6326ae58283
 * ```
 * 
 */
@ResourceType(type="openstack:blockstorage/volumeTypeV3:VolumeTypeV3")
public class VolumeTypeV3 extends com.pulumi.resources.CustomResource {
    /**
     * Human-readable description of the port. Changing
     * this updates the `description` of an existing volume type.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output<String> description;

    /**
     * @return Human-readable description of the port. Changing
     * this updates the `description` of an existing volume type.
     * 
     */
    public Output<String> description() {
        return this.description;
    }
    /**
     * Key/Value pairs of metadata for the volume type.
     * 
     */
    @Export(name="extraSpecs", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output<Map<String,Object>> extraSpecs;

    /**
     * @return Key/Value pairs of metadata for the volume type.
     * 
     */
    public Output<Map<String,Object>> extraSpecs() {
        return this.extraSpecs;
    }
    /**
     * Whether the volume type is public. Changing
     * this updates the `is_public` of an existing volume type.
     * 
     */
    @Export(name="isPublic", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> isPublic;

    /**
     * @return Whether the volume type is public. Changing
     * this updates the `is_public` of an existing volume type.
     * 
     */
    public Output<Boolean> isPublic() {
        return this.isPublic;
    }
    /**
     * Name of the volume type.  Changing this
     * updates the `name` of an existing volume type.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Name of the volume type.  Changing this
     * updates the `name` of an existing volume type.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The region in which to create the volume. If
     * omitted, the `region` argument of the provider is used. Changing this
     * creates a new quotaset.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to create the volume. If
     * omitted, the `region` argument of the provider is used. Changing this
     * creates a new quotaset.
     * 
     */
    public Output<String> region() {
        return this.region;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public VolumeTypeV3(String name) {
        this(name, VolumeTypeV3Args.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public VolumeTypeV3(String name, @Nullable VolumeTypeV3Args args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public VolumeTypeV3(String name, @Nullable VolumeTypeV3Args args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:blockstorage/volumeTypeV3:VolumeTypeV3", name, args == null ? VolumeTypeV3Args.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private VolumeTypeV3(String name, Output<String> id, @Nullable VolumeTypeV3State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:blockstorage/volumeTypeV3:VolumeTypeV3", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static VolumeTypeV3 get(String name, Output<String> id, @Nullable VolumeTypeV3State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new VolumeTypeV3(name, id, state, options);
    }
}
