// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.compute;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.compute.FloatingIpArgs;
import com.pulumi.openstack.compute.inputs.FloatingIpState;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages a V2 floating IP resource within OpenStack Nova (compute)
 * that can be used for compute instances.
 * 
 * Please note that managing floating IPs through the OpenStack Compute API has
 * been deprecated. Unless you are using an older OpenStack environment, it is
 * recommended to use the `openstack.networking.FloatingIp`
 * resource instead, which uses the OpenStack Networking API.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.compute.FloatingIp;
 * import com.pulumi.openstack.compute.FloatingIpArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var floatip1 = new FloatingIp(&#34;floatip1&#34;, FloatingIpArgs.builder()        
 *             .pool(&#34;public&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Floating IPs can be imported using the `id`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:compute/floatingIp:FloatingIp floatip_1 89c60255-9bd6-460c-822a-e2b959ede9d2
 * ```
 * 
 */
@ResourceType(type="openstack:compute/floatingIp:FloatingIp")
public class FloatingIp extends com.pulumi.resources.CustomResource {
    /**
     * The actual floating IP address itself.
     * 
     */
    @Export(name="address", refs={String.class}, tree="[0]")
    private Output<String> address;

    /**
     * @return The actual floating IP address itself.
     * 
     */
    public Output<String> address() {
        return this.address;
    }
    /**
     * The fixed IP address corresponding to the floating IP.
     * 
     */
    @Export(name="fixedIp", refs={String.class}, tree="[0]")
    private Output<String> fixedIp;

    /**
     * @return The fixed IP address corresponding to the floating IP.
     * 
     */
    public Output<String> fixedIp() {
        return this.fixedIp;
    }
    /**
     * UUID of the compute instance associated with the floating IP.
     * 
     */
    @Export(name="instanceId", refs={String.class}, tree="[0]")
    private Output<String> instanceId;

    /**
     * @return UUID of the compute instance associated with the floating IP.
     * 
     */
    public Output<String> instanceId() {
        return this.instanceId;
    }
    /**
     * The name of the pool from which to obtain the floating
     * IP. Changing this creates a new floating IP.
     * 
     */
    @Export(name="pool", refs={String.class}, tree="[0]")
    private Output<String> pool;

    /**
     * @return The name of the pool from which to obtain the floating
     * IP. Changing this creates a new floating IP.
     * 
     */
    public Output<String> pool() {
        return this.pool;
    }
    /**
     * The region in which to obtain the V2 Compute client.
     * A Compute client is needed to create a floating IP that can be used with
     * a compute instance. If omitted, the `region` argument of the provider
     * is used. Changing this creates a new floating IP (which may or may not
     * have a different address).
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V2 Compute client.
     * A Compute client is needed to create a floating IP that can be used with
     * a compute instance. If omitted, the `region` argument of the provider
     * is used. Changing this creates a new floating IP (which may or may not
     * have a different address).
     * 
     */
    public Output<String> region() {
        return this.region;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public FloatingIp(String name) {
        this(name, FloatingIpArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public FloatingIp(String name, FloatingIpArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public FloatingIp(String name, FloatingIpArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:compute/floatingIp:FloatingIp", name, args == null ? FloatingIpArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private FloatingIp(String name, Output<String> id, @Nullable FloatingIpState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:compute/floatingIp:FloatingIp", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static FloatingIp get(String name, Output<String> id, @Nullable FloatingIpState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new FloatingIp(name, id, state, options);
    }
}
