// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.compute;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class InterfaceAttachArgs extends com.pulumi.resources.ResourceArgs {

    public static final InterfaceAttachArgs Empty = new InterfaceAttachArgs();

    /**
     * An IP address to assosciate with the port.
     * _NOTE_: This option cannot be used with port_id. You must specifiy a network_id. The IP address must lie in a range on the supplied network.
     * 
     */
    @Import(name="fixedIp")
    private @Nullable Output<String> fixedIp;

    /**
     * @return An IP address to assosciate with the port.
     * _NOTE_: This option cannot be used with port_id. You must specifiy a network_id. The IP address must lie in a range on the supplied network.
     * 
     */
    public Optional<Output<String>> fixedIp() {
        return Optional.ofNullable(this.fixedIp);
    }

    /**
     * The ID of the Instance to attach the Port or Network to.
     * 
     */
    @Import(name="instanceId", required=true)
    private Output<String> instanceId;

    /**
     * @return The ID of the Instance to attach the Port or Network to.
     * 
     */
    public Output<String> instanceId() {
        return this.instanceId;
    }

    /**
     * The ID of the Network to attach to an Instance. A port will be created automatically.
     * _NOTE_: This option and `port_id` are mutually exclusive.
     * 
     */
    @Import(name="networkId")
    private @Nullable Output<String> networkId;

    /**
     * @return The ID of the Network to attach to an Instance. A port will be created automatically.
     * _NOTE_: This option and `port_id` are mutually exclusive.
     * 
     */
    public Optional<Output<String>> networkId() {
        return Optional.ofNullable(this.networkId);
    }

    /**
     * The ID of the Port to attach to an Instance.
     * _NOTE_: This option and `network_id` are mutually exclusive.
     * 
     */
    @Import(name="portId")
    private @Nullable Output<String> portId;

    /**
     * @return The ID of the Port to attach to an Instance.
     * _NOTE_: This option and `network_id` are mutually exclusive.
     * 
     */
    public Optional<Output<String>> portId() {
        return Optional.ofNullable(this.portId);
    }

    /**
     * The region in which to create the interface attachment.
     * If omitted, the `region` argument of the provider is used. Changing this
     * creates a new attachment.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to create the interface attachment.
     * If omitted, the `region` argument of the provider is used. Changing this
     * creates a new attachment.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    private InterfaceAttachArgs() {}

    private InterfaceAttachArgs(InterfaceAttachArgs $) {
        this.fixedIp = $.fixedIp;
        this.instanceId = $.instanceId;
        this.networkId = $.networkId;
        this.portId = $.portId;
        this.region = $.region;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(InterfaceAttachArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private InterfaceAttachArgs $;

        public Builder() {
            $ = new InterfaceAttachArgs();
        }

        public Builder(InterfaceAttachArgs defaults) {
            $ = new InterfaceAttachArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param fixedIp An IP address to assosciate with the port.
         * _NOTE_: This option cannot be used with port_id. You must specifiy a network_id. The IP address must lie in a range on the supplied network.
         * 
         * @return builder
         * 
         */
        public Builder fixedIp(@Nullable Output<String> fixedIp) {
            $.fixedIp = fixedIp;
            return this;
        }

        /**
         * @param fixedIp An IP address to assosciate with the port.
         * _NOTE_: This option cannot be used with port_id. You must specifiy a network_id. The IP address must lie in a range on the supplied network.
         * 
         * @return builder
         * 
         */
        public Builder fixedIp(String fixedIp) {
            return fixedIp(Output.of(fixedIp));
        }

        /**
         * @param instanceId The ID of the Instance to attach the Port or Network to.
         * 
         * @return builder
         * 
         */
        public Builder instanceId(Output<String> instanceId) {
            $.instanceId = instanceId;
            return this;
        }

        /**
         * @param instanceId The ID of the Instance to attach the Port or Network to.
         * 
         * @return builder
         * 
         */
        public Builder instanceId(String instanceId) {
            return instanceId(Output.of(instanceId));
        }

        /**
         * @param networkId The ID of the Network to attach to an Instance. A port will be created automatically.
         * _NOTE_: This option and `port_id` are mutually exclusive.
         * 
         * @return builder
         * 
         */
        public Builder networkId(@Nullable Output<String> networkId) {
            $.networkId = networkId;
            return this;
        }

        /**
         * @param networkId The ID of the Network to attach to an Instance. A port will be created automatically.
         * _NOTE_: This option and `port_id` are mutually exclusive.
         * 
         * @return builder
         * 
         */
        public Builder networkId(String networkId) {
            return networkId(Output.of(networkId));
        }

        /**
         * @param portId The ID of the Port to attach to an Instance.
         * _NOTE_: This option and `network_id` are mutually exclusive.
         * 
         * @return builder
         * 
         */
        public Builder portId(@Nullable Output<String> portId) {
            $.portId = portId;
            return this;
        }

        /**
         * @param portId The ID of the Port to attach to an Instance.
         * _NOTE_: This option and `network_id` are mutually exclusive.
         * 
         * @return builder
         * 
         */
        public Builder portId(String portId) {
            return portId(Output.of(portId));
        }

        /**
         * @param region The region in which to create the interface attachment.
         * If omitted, the `region` argument of the provider is used. Changing this
         * creates a new attachment.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to create the interface attachment.
         * If omitted, the `region` argument of the provider is used. Changing this
         * creates a new attachment.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        public InterfaceAttachArgs build() {
            if ($.instanceId == null) {
                throw new MissingRequiredPropertyException("InterfaceAttachArgs", "instanceId");
            }
            return $;
        }
    }

}
