// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.compute;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.compute.QuotaSetV2Args;
import com.pulumi.openstack.compute.inputs.QuotaSetV2State;
import java.lang.Integer;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * Manages a V2 compute quotaset resource within OpenStack.
 * 
 * &gt; **Note:** This usually requires admin privileges.
 * 
 * &gt; **Note:** This resource has a no-op deletion so no actual actions will be done against the OpenStack API
 *     in case of delete call.
 * 
 * &gt; **Note:** This resource has all-in creation so all optional quota arguments that were not specified are
 *     created with zero value.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.identity.Project;
 * import com.pulumi.openstack.compute.QuotaSetV2;
 * import com.pulumi.openstack.compute.QuotaSetV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var project1 = new Project(&#34;project1&#34;);
 * 
 *         var quotaset1 = new QuotaSetV2(&#34;quotaset1&#34;, QuotaSetV2Args.builder()        
 *             .projectId(project1.id())
 *             .keyPairs(10)
 *             .ram(40960)
 *             .cores(32)
 *             .instances(20)
 *             .serverGroups(4)
 *             .serverGroupMembers(8)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Quotasets can be imported using the `project_id/region_name`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:compute/quotaSetV2:QuotaSetV2 quotaset_1 2a0f2240-c5e6-41de-896d-e80d97428d6b/region_1
 * ```
 * 
 */
@ResourceType(type="openstack:compute/quotaSetV2:QuotaSetV2")
public class QuotaSetV2 extends com.pulumi.resources.CustomResource {
    /**
     * Quota value for cores.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="cores", refs={Integer.class}, tree="[0]")
    private Output<Integer> cores;

    /**
     * @return Quota value for cores.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> cores() {
        return this.cores;
    }
    /**
     * Quota value for fixed IPs.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="fixedIps", refs={Integer.class}, tree="[0]")
    private Output<Integer> fixedIps;

    /**
     * @return Quota value for fixed IPs.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> fixedIps() {
        return this.fixedIps;
    }
    /**
     * Quota value for floating IPs.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="floatingIps", refs={Integer.class}, tree="[0]")
    private Output<Integer> floatingIps;

    /**
     * @return Quota value for floating IPs.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> floatingIps() {
        return this.floatingIps;
    }
    /**
     * Quota value for content bytes
     * of injected files. Changing this updates the existing quotaset.
     * 
     */
    @Export(name="injectedFileContentBytes", refs={Integer.class}, tree="[0]")
    private Output<Integer> injectedFileContentBytes;

    /**
     * @return Quota value for content bytes
     * of injected files. Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> injectedFileContentBytes() {
        return this.injectedFileContentBytes;
    }
    /**
     * Quota value for path bytes of
     * injected files. Changing this updates the existing quotaset.
     * 
     */
    @Export(name="injectedFilePathBytes", refs={Integer.class}, tree="[0]")
    private Output<Integer> injectedFilePathBytes;

    /**
     * @return Quota value for path bytes of
     * injected files. Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> injectedFilePathBytes() {
        return this.injectedFilePathBytes;
    }
    /**
     * Quota value for injected files.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="injectedFiles", refs={Integer.class}, tree="[0]")
    private Output<Integer> injectedFiles;

    /**
     * @return Quota value for injected files.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> injectedFiles() {
        return this.injectedFiles;
    }
    /**
     * Quota value for instances.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="instances", refs={Integer.class}, tree="[0]")
    private Output<Integer> instances;

    /**
     * @return Quota value for instances.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> instances() {
        return this.instances;
    }
    /**
     * Quota value for key pairs.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="keyPairs", refs={Integer.class}, tree="[0]")
    private Output<Integer> keyPairs;

    /**
     * @return Quota value for key pairs.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> keyPairs() {
        return this.keyPairs;
    }
    /**
     * Quota value for metadata items.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="metadataItems", refs={Integer.class}, tree="[0]")
    private Output<Integer> metadataItems;

    /**
     * @return Quota value for metadata items.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> metadataItems() {
        return this.metadataItems;
    }
    /**
     * ID of the project to manage quotas.
     * Changing this creates a new quotaset.
     * 
     */
    @Export(name="projectId", refs={String.class}, tree="[0]")
    private Output<String> projectId;

    /**
     * @return ID of the project to manage quotas.
     * Changing this creates a new quotaset.
     * 
     */
    public Output<String> projectId() {
        return this.projectId;
    }
    /**
     * Quota value for RAM.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="ram", refs={Integer.class}, tree="[0]")
    private Output<Integer> ram;

    /**
     * @return Quota value for RAM.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> ram() {
        return this.ram;
    }
    /**
     * The region in which to create the volume. If
     * omitted, the `region` argument of the provider is used. Changing this
     * creates a new quotaset.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to create the volume. If
     * omitted, the `region` argument of the provider is used. Changing this
     * creates a new quotaset.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * Quota value for security group rules.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="securityGroupRules", refs={Integer.class}, tree="[0]")
    private Output<Integer> securityGroupRules;

    /**
     * @return Quota value for security group rules.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> securityGroupRules() {
        return this.securityGroupRules;
    }
    /**
     * Quota value for security groups.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="securityGroups", refs={Integer.class}, tree="[0]")
    private Output<Integer> securityGroups;

    /**
     * @return Quota value for security groups.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> securityGroups() {
        return this.securityGroups;
    }
    /**
     * Quota value for server groups members.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="serverGroupMembers", refs={Integer.class}, tree="[0]")
    private Output<Integer> serverGroupMembers;

    /**
     * @return Quota value for server groups members.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> serverGroupMembers() {
        return this.serverGroupMembers;
    }
    /**
     * Quota value for server groups.
     * Changing this updates the existing quotaset.
     * 
     */
    @Export(name="serverGroups", refs={Integer.class}, tree="[0]")
    private Output<Integer> serverGroups;

    /**
     * @return Quota value for server groups.
     * Changing this updates the existing quotaset.
     * 
     */
    public Output<Integer> serverGroups() {
        return this.serverGroups;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public QuotaSetV2(String name) {
        this(name, QuotaSetV2Args.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public QuotaSetV2(String name, QuotaSetV2Args args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public QuotaSetV2(String name, QuotaSetV2Args args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:compute/quotaSetV2:QuotaSetV2", name, args == null ? QuotaSetV2Args.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private QuotaSetV2(String name, Output<String> id, @Nullable QuotaSetV2State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:compute/quotaSetV2:QuotaSetV2", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static QuotaSetV2 get(String name, Output<String> id, @Nullable QuotaSetV2State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new QuotaSetV2(name, id, state, options);
    }
}
