// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.compute.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class FloatingIpState extends com.pulumi.resources.ResourceArgs {

    public static final FloatingIpState Empty = new FloatingIpState();

    /**
     * The actual floating IP address itself.
     * 
     */
    @Import(name="address")
    private @Nullable Output<String> address;

    /**
     * @return The actual floating IP address itself.
     * 
     */
    public Optional<Output<String>> address() {
        return Optional.ofNullable(this.address);
    }

    /**
     * The fixed IP address corresponding to the floating IP.
     * 
     */
    @Import(name="fixedIp")
    private @Nullable Output<String> fixedIp;

    /**
     * @return The fixed IP address corresponding to the floating IP.
     * 
     */
    public Optional<Output<String>> fixedIp() {
        return Optional.ofNullable(this.fixedIp);
    }

    /**
     * UUID of the compute instance associated with the floating IP.
     * 
     */
    @Import(name="instanceId")
    private @Nullable Output<String> instanceId;

    /**
     * @return UUID of the compute instance associated with the floating IP.
     * 
     */
    public Optional<Output<String>> instanceId() {
        return Optional.ofNullable(this.instanceId);
    }

    /**
     * The name of the pool from which to obtain the floating
     * IP. Changing this creates a new floating IP.
     * 
     */
    @Import(name="pool")
    private @Nullable Output<String> pool;

    /**
     * @return The name of the pool from which to obtain the floating
     * IP. Changing this creates a new floating IP.
     * 
     */
    public Optional<Output<String>> pool() {
        return Optional.ofNullable(this.pool);
    }

    /**
     * The region in which to obtain the V2 Compute client.
     * A Compute client is needed to create a floating IP that can be used with
     * a compute instance. If omitted, the `region` argument of the provider
     * is used. Changing this creates a new floating IP (which may or may not
     * have a different address).
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 Compute client.
     * A Compute client is needed to create a floating IP that can be used with
     * a compute instance. If omitted, the `region` argument of the provider
     * is used. Changing this creates a new floating IP (which may or may not
     * have a different address).
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    private FloatingIpState() {}

    private FloatingIpState(FloatingIpState $) {
        this.address = $.address;
        this.fixedIp = $.fixedIp;
        this.instanceId = $.instanceId;
        this.pool = $.pool;
        this.region = $.region;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(FloatingIpState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private FloatingIpState $;

        public Builder() {
            $ = new FloatingIpState();
        }

        public Builder(FloatingIpState defaults) {
            $ = new FloatingIpState(Objects.requireNonNull(defaults));
        }

        /**
         * @param address The actual floating IP address itself.
         * 
         * @return builder
         * 
         */
        public Builder address(@Nullable Output<String> address) {
            $.address = address;
            return this;
        }

        /**
         * @param address The actual floating IP address itself.
         * 
         * @return builder
         * 
         */
        public Builder address(String address) {
            return address(Output.of(address));
        }

        /**
         * @param fixedIp The fixed IP address corresponding to the floating IP.
         * 
         * @return builder
         * 
         */
        public Builder fixedIp(@Nullable Output<String> fixedIp) {
            $.fixedIp = fixedIp;
            return this;
        }

        /**
         * @param fixedIp The fixed IP address corresponding to the floating IP.
         * 
         * @return builder
         * 
         */
        public Builder fixedIp(String fixedIp) {
            return fixedIp(Output.of(fixedIp));
        }

        /**
         * @param instanceId UUID of the compute instance associated with the floating IP.
         * 
         * @return builder
         * 
         */
        public Builder instanceId(@Nullable Output<String> instanceId) {
            $.instanceId = instanceId;
            return this;
        }

        /**
         * @param instanceId UUID of the compute instance associated with the floating IP.
         * 
         * @return builder
         * 
         */
        public Builder instanceId(String instanceId) {
            return instanceId(Output.of(instanceId));
        }

        /**
         * @param pool The name of the pool from which to obtain the floating
         * IP. Changing this creates a new floating IP.
         * 
         * @return builder
         * 
         */
        public Builder pool(@Nullable Output<String> pool) {
            $.pool = pool;
            return this;
        }

        /**
         * @param pool The name of the pool from which to obtain the floating
         * IP. Changing this creates a new floating IP.
         * 
         * @return builder
         * 
         */
        public Builder pool(String pool) {
            return pool(Output.of(pool));
        }

        /**
         * @param region The region in which to obtain the V2 Compute client.
         * A Compute client is needed to create a floating IP that can be used with
         * a compute instance. If omitted, the `region` argument of the provider
         * is used. Changing this creates a new floating IP (which may or may not
         * have a different address).
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 Compute client.
         * A Compute client is needed to create a floating IP that can be used with
         * a compute instance. If omitted, the `region` argument of the provider
         * is used. Changing this creates a new floating IP (which may or may not
         * have a different address).
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        public FloatingIpState build() {
            return $;
        }
    }

}
