// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.dns;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.dns.TransferAcceptArgs;
import com.pulumi.openstack.dns.inputs.TransferAcceptState;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a DNS zone transfer accept in the OpenStack DNS Service.
 * 
 * ## Example Usage
 * ### Automatically detect the correct network
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.dns.Zone;
 * import com.pulumi.openstack.dns.ZoneArgs;
 * import com.pulumi.openstack.dns.TransferRequest;
 * import com.pulumi.openstack.dns.TransferRequestArgs;
 * import com.pulumi.openstack.dns.TransferAccept;
 * import com.pulumi.openstack.dns.TransferAcceptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var exampleZone = new Zone(&#34;exampleZone&#34;, ZoneArgs.builder()        
 *             .email(&#34;jdoe@example.com&#34;)
 *             .description(&#34;An example zone&#34;)
 *             .ttl(3000)
 *             .type(&#34;PRIMARY&#34;)
 *             .build());
 * 
 *         var request1 = new TransferRequest(&#34;request1&#34;, TransferRequestArgs.builder()        
 *             .zoneId(exampleZone.id())
 *             .description(&#34;a transfer accept&#34;)
 *             .build());
 * 
 *         var accept1 = new TransferAccept(&#34;accept1&#34;, TransferAcceptArgs.builder()        
 *             .zoneTransferRequestId(request1.id())
 *             .key(request1.key())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * This resource can be imported by specifying the transferAccept ID:
 * 
 * ```sh
 *  $ pulumi import openstack:dns/transferAccept:TransferAccept accept_1 accept_id
 * ```
 * 
 */
@ResourceType(type="openstack:dns/transferAccept:TransferAccept")
public class TransferAccept extends com.pulumi.resources.CustomResource {
    /**
     * Disable wait for zone to reach ACTIVE
     * status. The check is enabled by default. If this argument is true, zone
     * will be considered as created/updated if OpenStack accept returned success.
     * 
     */
    @Export(name="disableStatusCheck", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> disableStatusCheck;

    /**
     * @return Disable wait for zone to reach ACTIVE
     * status. The check is enabled by default. If this argument is true, zone
     * will be considered as created/updated if OpenStack accept returned success.
     * 
     */
    public Output<Optional<Boolean>> disableStatusCheck() {
        return Codegen.optional(this.disableStatusCheck);
    }
    /**
     * The transfer key.
     * 
     */
    @Export(name="key", refs={String.class}, tree="[0]")
    private Output<String> key;

    /**
     * @return The transfer key.
     * 
     */
    public Output<String> key() {
        return this.key;
    }
    /**
     * The region in which to obtain the V2 Compute client.
     * Keypairs are associated with accounts, but a Compute client is needed to
     * create one. If omitted, the `region` argument of the provider is used.
     * Changing this creates a new DNS zone.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V2 Compute client.
     * Keypairs are associated with accounts, but a Compute client is needed to
     * create one. If omitted, the `region` argument of the provider is used.
     * Changing this creates a new DNS zone.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * Map of additional options. Changing this creates a
     * new transfer accept.
     * 
     */
    @Export(name="valueSpecs", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output</* @Nullable */ Map<String,Object>> valueSpecs;

    /**
     * @return Map of additional options. Changing this creates a
     * new transfer accept.
     * 
     */
    public Output<Optional<Map<String,Object>>> valueSpecs() {
        return Codegen.optional(this.valueSpecs);
    }
    /**
     * The ID of the zone transfer request.
     * 
     */
    @Export(name="zoneTransferRequestId", refs={String.class}, tree="[0]")
    private Output<String> zoneTransferRequestId;

    /**
     * @return The ID of the zone transfer request.
     * 
     */
    public Output<String> zoneTransferRequestId() {
        return this.zoneTransferRequestId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public TransferAccept(String name) {
        this(name, TransferAcceptArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public TransferAccept(String name, TransferAcceptArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public TransferAccept(String name, TransferAcceptArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:dns/transferAccept:TransferAccept", name, args == null ? TransferAcceptArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private TransferAccept(String name, Output<String> id, @Nullable TransferAcceptState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:dns/transferAccept:TransferAccept", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static TransferAccept get(String name, Output<String> id, @Nullable TransferAcceptState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new TransferAccept(name, id, state, options);
    }
}
