// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.dns;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class TransferRequestArgs extends com.pulumi.resources.ResourceArgs {

    public static final TransferRequestArgs Empty = new TransferRequestArgs();

    /**
     * A description of the zone tranfer request.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A description of the zone tranfer request.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * Disable wait for zone to reach ACTIVE
     * status. The check is enabled by default. If this argument is true, zone
     * will be considered as created/updated if OpenStack request returned success.
     * 
     */
    @Import(name="disableStatusCheck")
    private @Nullable Output<Boolean> disableStatusCheck;

    /**
     * @return Disable wait for zone to reach ACTIVE
     * status. The check is enabled by default. If this argument is true, zone
     * will be considered as created/updated if OpenStack request returned success.
     * 
     */
    public Optional<Output<Boolean>> disableStatusCheck() {
        return Optional.ofNullable(this.disableStatusCheck);
    }

    @Import(name="key")
    private @Nullable Output<String> key;

    public Optional<Output<String>> key() {
        return Optional.ofNullable(this.key);
    }

    /**
     * The region in which to obtain the V2 Compute client.
     * Keypairs are associated with accounts, but a Compute client is needed to
     * create one. If omitted, the `region` argument of the provider is used.
     * Changing this creates a new DNS zone.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 Compute client.
     * Keypairs are associated with accounts, but a Compute client is needed to
     * create one. If omitted, the `region` argument of the provider is used.
     * Changing this creates a new DNS zone.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The target Project ID to transfer to.
     * 
     */
    @Import(name="targetProjectId")
    private @Nullable Output<String> targetProjectId;

    /**
     * @return The target Project ID to transfer to.
     * 
     */
    public Optional<Output<String>> targetProjectId() {
        return Optional.ofNullable(this.targetProjectId);
    }

    /**
     * Map of additional options. Changing this creates a
     * new transfer request.
     * 
     */
    @Import(name="valueSpecs")
    private @Nullable Output<Map<String,Object>> valueSpecs;

    /**
     * @return Map of additional options. Changing this creates a
     * new transfer request.
     * 
     */
    public Optional<Output<Map<String,Object>>> valueSpecs() {
        return Optional.ofNullable(this.valueSpecs);
    }

    /**
     * The ID of the zone for which to create the transfer
     * request.
     * 
     */
    @Import(name="zoneId", required=true)
    private Output<String> zoneId;

    /**
     * @return The ID of the zone for which to create the transfer
     * request.
     * 
     */
    public Output<String> zoneId() {
        return this.zoneId;
    }

    private TransferRequestArgs() {}

    private TransferRequestArgs(TransferRequestArgs $) {
        this.description = $.description;
        this.disableStatusCheck = $.disableStatusCheck;
        this.key = $.key;
        this.region = $.region;
        this.targetProjectId = $.targetProjectId;
        this.valueSpecs = $.valueSpecs;
        this.zoneId = $.zoneId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(TransferRequestArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private TransferRequestArgs $;

        public Builder() {
            $ = new TransferRequestArgs();
        }

        public Builder(TransferRequestArgs defaults) {
            $ = new TransferRequestArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param description A description of the zone tranfer request.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A description of the zone tranfer request.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param disableStatusCheck Disable wait for zone to reach ACTIVE
         * status. The check is enabled by default. If this argument is true, zone
         * will be considered as created/updated if OpenStack request returned success.
         * 
         * @return builder
         * 
         */
        public Builder disableStatusCheck(@Nullable Output<Boolean> disableStatusCheck) {
            $.disableStatusCheck = disableStatusCheck;
            return this;
        }

        /**
         * @param disableStatusCheck Disable wait for zone to reach ACTIVE
         * status. The check is enabled by default. If this argument is true, zone
         * will be considered as created/updated if OpenStack request returned success.
         * 
         * @return builder
         * 
         */
        public Builder disableStatusCheck(Boolean disableStatusCheck) {
            return disableStatusCheck(Output.of(disableStatusCheck));
        }

        public Builder key(@Nullable Output<String> key) {
            $.key = key;
            return this;
        }

        public Builder key(String key) {
            return key(Output.of(key));
        }

        /**
         * @param region The region in which to obtain the V2 Compute client.
         * Keypairs are associated with accounts, but a Compute client is needed to
         * create one. If omitted, the `region` argument of the provider is used.
         * Changing this creates a new DNS zone.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 Compute client.
         * Keypairs are associated with accounts, but a Compute client is needed to
         * create one. If omitted, the `region` argument of the provider is used.
         * Changing this creates a new DNS zone.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param targetProjectId The target Project ID to transfer to.
         * 
         * @return builder
         * 
         */
        public Builder targetProjectId(@Nullable Output<String> targetProjectId) {
            $.targetProjectId = targetProjectId;
            return this;
        }

        /**
         * @param targetProjectId The target Project ID to transfer to.
         * 
         * @return builder
         * 
         */
        public Builder targetProjectId(String targetProjectId) {
            return targetProjectId(Output.of(targetProjectId));
        }

        /**
         * @param valueSpecs Map of additional options. Changing this creates a
         * new transfer request.
         * 
         * @return builder
         * 
         */
        public Builder valueSpecs(@Nullable Output<Map<String,Object>> valueSpecs) {
            $.valueSpecs = valueSpecs;
            return this;
        }

        /**
         * @param valueSpecs Map of additional options. Changing this creates a
         * new transfer request.
         * 
         * @return builder
         * 
         */
        public Builder valueSpecs(Map<String,Object> valueSpecs) {
            return valueSpecs(Output.of(valueSpecs));
        }

        /**
         * @param zoneId The ID of the zone for which to create the transfer
         * request.
         * 
         * @return builder
         * 
         */
        public Builder zoneId(Output<String> zoneId) {
            $.zoneId = zoneId;
            return this;
        }

        /**
         * @param zoneId The ID of the zone for which to create the transfer
         * request.
         * 
         * @return builder
         * 
         */
        public Builder zoneId(String zoneId) {
            return zoneId(Output.of(zoneId));
        }

        public TransferRequestArgs build() {
            if ($.zoneId == null) {
                throw new MissingRequiredPropertyException("TransferRequestArgs", "zoneId");
            }
            return $;
        }
    }

}
