// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.firewall;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.firewall.PolicyArgs;
import com.pulumi.openstack.firewall.inputs.PolicyState;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a v1 firewall policy resource within OpenStack.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.firewall.Rule;
 * import com.pulumi.openstack.firewall.RuleArgs;
 * import com.pulumi.openstack.firewall.Policy;
 * import com.pulumi.openstack.firewall.PolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var rule1 = new Rule(&#34;rule1&#34;, RuleArgs.builder()        
 *             .description(&#34;drop TELNET traffic&#34;)
 *             .action(&#34;deny&#34;)
 *             .protocol(&#34;tcp&#34;)
 *             .destinationPort(&#34;23&#34;)
 *             .enabled(&#34;true&#34;)
 *             .build());
 * 
 *         var rule2 = new Rule(&#34;rule2&#34;, RuleArgs.builder()        
 *             .description(&#34;drop NTP traffic&#34;)
 *             .action(&#34;deny&#34;)
 *             .protocol(&#34;udp&#34;)
 *             .destinationPort(&#34;123&#34;)
 *             .enabled(&#34;false&#34;)
 *             .build());
 * 
 *         var policy1 = new Policy(&#34;policy1&#34;, PolicyArgs.builder()        
 *             .rules(            
 *                 rule1.id(),
 *                 rule2.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Firewall Policies can be imported using the `id`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:firewall/policy:Policy policy_1 07f422e6-c596-474b-8b94-fe2c12506ce0
 * ```
 * 
 */
@ResourceType(type="openstack:firewall/policy:Policy")
public class Policy extends com.pulumi.resources.CustomResource {
    /**
     * Audit status of the firewall policy
     * (must be &#34;true&#34; or &#34;false&#34; if provided - defaults to &#34;false&#34;).
     * This status is set to &#34;false&#34; whenever the firewall policy or any of its
     * rules are changed. Changing this updates the `audited` status of an existing
     * firewall policy.
     * 
     */
    @Export(name="audited", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> audited;

    /**
     * @return Audit status of the firewall policy
     * (must be &#34;true&#34; or &#34;false&#34; if provided - defaults to &#34;false&#34;).
     * This status is set to &#34;false&#34; whenever the firewall policy or any of its
     * rules are changed. Changing this updates the `audited` status of an existing
     * firewall policy.
     * 
     */
    public Output<Optional<Boolean>> audited() {
        return Codegen.optional(this.audited);
    }
    /**
     * A description for the firewall policy. Changing
     * this updates the `description` of an existing firewall policy.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A description for the firewall policy. Changing
     * this updates the `description` of an existing firewall policy.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * A name for the firewall policy. Changing this
     * updates the `name` of an existing firewall policy.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return A name for the firewall policy. Changing this
     * updates the `name` of an existing firewall policy.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The region in which to obtain the v1 networking client.
     * A networking client is needed to create a firewall policy. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * firewall policy.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the v1 networking client.
     * A networking client is needed to create a firewall policy. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * firewall policy.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * An array of one or more firewall rules that comprise
     * the policy. Changing this results in adding/removing rules from the
     * existing firewall policy.
     * 
     */
    @Export(name="rules", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> rules;

    /**
     * @return An array of one or more firewall rules that comprise
     * the policy. Changing this results in adding/removing rules from the
     * existing firewall policy.
     * 
     */
    public Output<Optional<List<String>>> rules() {
        return Codegen.optional(this.rules);
    }
    /**
     * Sharing status of the firewall policy (must be &#34;true&#34;
     * or &#34;false&#34; if provided). If this is &#34;true&#34; the policy is visible to, and
     * can be used in, firewalls in other tenants. Changing this updates the
     * `shared` status of an existing firewall policy. Only administrative users
     * can specify if the policy should be shared.
     * 
     */
    @Export(name="shared", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> shared;

    /**
     * @return Sharing status of the firewall policy (must be &#34;true&#34;
     * or &#34;false&#34; if provided). If this is &#34;true&#34; the policy is visible to, and
     * can be used in, firewalls in other tenants. Changing this updates the
     * `shared` status of an existing firewall policy. Only administrative users
     * can specify if the policy should be shared.
     * 
     */
    public Output<Optional<Boolean>> shared() {
        return Codegen.optional(this.shared);
    }
    @Export(name="tenantId", refs={String.class}, tree="[0]")
    private Output<String> tenantId;

    public Output<String> tenantId() {
        return this.tenantId;
    }
    /**
     * Map of additional options.
     * 
     */
    @Export(name="valueSpecs", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output</* @Nullable */ Map<String,Object>> valueSpecs;

    /**
     * @return Map of additional options.
     * 
     */
    public Output<Optional<Map<String,Object>>> valueSpecs() {
        return Codegen.optional(this.valueSpecs);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Policy(String name) {
        this(name, PolicyArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Policy(String name, @Nullable PolicyArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Policy(String name, @Nullable PolicyArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:firewall/policy:Policy", name, args == null ? PolicyArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Policy(String name, Output<String> id, @Nullable PolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:firewall/policy:Policy", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Policy get(String name, Output<String> id, @Nullable PolicyState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Policy(name, id, state, options);
    }
}
