// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.firewall;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class PolicyArgs extends com.pulumi.resources.ResourceArgs {

    public static final PolicyArgs Empty = new PolicyArgs();

    /**
     * Audit status of the firewall policy
     * (must be &#34;true&#34; or &#34;false&#34; if provided - defaults to &#34;false&#34;).
     * This status is set to &#34;false&#34; whenever the firewall policy or any of its
     * rules are changed. Changing this updates the `audited` status of an existing
     * firewall policy.
     * 
     */
    @Import(name="audited")
    private @Nullable Output<Boolean> audited;

    /**
     * @return Audit status of the firewall policy
     * (must be &#34;true&#34; or &#34;false&#34; if provided - defaults to &#34;false&#34;).
     * This status is set to &#34;false&#34; whenever the firewall policy or any of its
     * rules are changed. Changing this updates the `audited` status of an existing
     * firewall policy.
     * 
     */
    public Optional<Output<Boolean>> audited() {
        return Optional.ofNullable(this.audited);
    }

    /**
     * A description for the firewall policy. Changing
     * this updates the `description` of an existing firewall policy.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A description for the firewall policy. Changing
     * this updates the `description` of an existing firewall policy.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * A name for the firewall policy. Changing this
     * updates the `name` of an existing firewall policy.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return A name for the firewall policy. Changing this
     * updates the `name` of an existing firewall policy.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The region in which to obtain the v1 networking client.
     * A networking client is needed to create a firewall policy. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * firewall policy.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the v1 networking client.
     * A networking client is needed to create a firewall policy. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * firewall policy.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * An array of one or more firewall rules that comprise
     * the policy. Changing this results in adding/removing rules from the
     * existing firewall policy.
     * 
     */
    @Import(name="rules")
    private @Nullable Output<List<String>> rules;

    /**
     * @return An array of one or more firewall rules that comprise
     * the policy. Changing this results in adding/removing rules from the
     * existing firewall policy.
     * 
     */
    public Optional<Output<List<String>>> rules() {
        return Optional.ofNullable(this.rules);
    }

    /**
     * Sharing status of the firewall policy (must be &#34;true&#34;
     * or &#34;false&#34; if provided). If this is &#34;true&#34; the policy is visible to, and
     * can be used in, firewalls in other tenants. Changing this updates the
     * `shared` status of an existing firewall policy. Only administrative users
     * can specify if the policy should be shared.
     * 
     */
    @Import(name="shared")
    private @Nullable Output<Boolean> shared;

    /**
     * @return Sharing status of the firewall policy (must be &#34;true&#34;
     * or &#34;false&#34; if provided). If this is &#34;true&#34; the policy is visible to, and
     * can be used in, firewalls in other tenants. Changing this updates the
     * `shared` status of an existing firewall policy. Only administrative users
     * can specify if the policy should be shared.
     * 
     */
    public Optional<Output<Boolean>> shared() {
        return Optional.ofNullable(this.shared);
    }

    @Import(name="tenantId")
    private @Nullable Output<String> tenantId;

    public Optional<Output<String>> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    /**
     * Map of additional options.
     * 
     */
    @Import(name="valueSpecs")
    private @Nullable Output<Map<String,Object>> valueSpecs;

    /**
     * @return Map of additional options.
     * 
     */
    public Optional<Output<Map<String,Object>>> valueSpecs() {
        return Optional.ofNullable(this.valueSpecs);
    }

    private PolicyArgs() {}

    private PolicyArgs(PolicyArgs $) {
        this.audited = $.audited;
        this.description = $.description;
        this.name = $.name;
        this.region = $.region;
        this.rules = $.rules;
        this.shared = $.shared;
        this.tenantId = $.tenantId;
        this.valueSpecs = $.valueSpecs;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PolicyArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PolicyArgs $;

        public Builder() {
            $ = new PolicyArgs();
        }

        public Builder(PolicyArgs defaults) {
            $ = new PolicyArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param audited Audit status of the firewall policy
         * (must be &#34;true&#34; or &#34;false&#34; if provided - defaults to &#34;false&#34;).
         * This status is set to &#34;false&#34; whenever the firewall policy or any of its
         * rules are changed. Changing this updates the `audited` status of an existing
         * firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder audited(@Nullable Output<Boolean> audited) {
            $.audited = audited;
            return this;
        }

        /**
         * @param audited Audit status of the firewall policy
         * (must be &#34;true&#34; or &#34;false&#34; if provided - defaults to &#34;false&#34;).
         * This status is set to &#34;false&#34; whenever the firewall policy or any of its
         * rules are changed. Changing this updates the `audited` status of an existing
         * firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder audited(Boolean audited) {
            return audited(Output.of(audited));
        }

        /**
         * @param description A description for the firewall policy. Changing
         * this updates the `description` of an existing firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A description for the firewall policy. Changing
         * this updates the `description` of an existing firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param name A name for the firewall policy. Changing this
         * updates the `name` of an existing firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name A name for the firewall policy. Changing this
         * updates the `name` of an existing firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param region The region in which to obtain the v1 networking client.
         * A networking client is needed to create a firewall policy. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the v1 networking client.
         * A networking client is needed to create a firewall policy. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param rules An array of one or more firewall rules that comprise
         * the policy. Changing this results in adding/removing rules from the
         * existing firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder rules(@Nullable Output<List<String>> rules) {
            $.rules = rules;
            return this;
        }

        /**
         * @param rules An array of one or more firewall rules that comprise
         * the policy. Changing this results in adding/removing rules from the
         * existing firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder rules(List<String> rules) {
            return rules(Output.of(rules));
        }

        /**
         * @param rules An array of one or more firewall rules that comprise
         * the policy. Changing this results in adding/removing rules from the
         * existing firewall policy.
         * 
         * @return builder
         * 
         */
        public Builder rules(String... rules) {
            return rules(List.of(rules));
        }

        /**
         * @param shared Sharing status of the firewall policy (must be &#34;true&#34;
         * or &#34;false&#34; if provided). If this is &#34;true&#34; the policy is visible to, and
         * can be used in, firewalls in other tenants. Changing this updates the
         * `shared` status of an existing firewall policy. Only administrative users
         * can specify if the policy should be shared.
         * 
         * @return builder
         * 
         */
        public Builder shared(@Nullable Output<Boolean> shared) {
            $.shared = shared;
            return this;
        }

        /**
         * @param shared Sharing status of the firewall policy (must be &#34;true&#34;
         * or &#34;false&#34; if provided). If this is &#34;true&#34; the policy is visible to, and
         * can be used in, firewalls in other tenants. Changing this updates the
         * `shared` status of an existing firewall policy. Only administrative users
         * can specify if the policy should be shared.
         * 
         * @return builder
         * 
         */
        public Builder shared(Boolean shared) {
            return shared(Output.of(shared));
        }

        public Builder tenantId(@Nullable Output<String> tenantId) {
            $.tenantId = tenantId;
            return this;
        }

        public Builder tenantId(String tenantId) {
            return tenantId(Output.of(tenantId));
        }

        /**
         * @param valueSpecs Map of additional options.
         * 
         * @return builder
         * 
         */
        public Builder valueSpecs(@Nullable Output<Map<String,Object>> valueSpecs) {
            $.valueSpecs = valueSpecs;
            return this;
        }

        /**
         * @param valueSpecs Map of additional options.
         * 
         * @return builder
         * 
         */
        public Builder valueSpecs(Map<String,Object> valueSpecs) {
            return valueSpecs(Output.of(valueSpecs));
        }

        public PolicyArgs build() {
            return $;
        }
    }

}
