// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.firewall;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.firewall.PolicyV2Args;
import com.pulumi.openstack.firewall.inputs.PolicyV2State;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a v2 firewall policy resource within OpenStack.
 * 
 * &gt; **Note:** Firewall v2 has no support for OVN currently.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.firewall.RuleV2;
 * import com.pulumi.openstack.firewall.RuleV2Args;
 * import com.pulumi.openstack.firewall.PolicyV2;
 * import com.pulumi.openstack.firewall.PolicyV2Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var rule1 = new RuleV2(&#34;rule1&#34;, RuleV2Args.builder()        
 *             .description(&#34;drop TELNET traffic&#34;)
 *             .action(&#34;deny&#34;)
 *             .protocol(&#34;tcp&#34;)
 *             .destinationPort(&#34;23&#34;)
 *             .enabled(&#34;true&#34;)
 *             .build());
 * 
 *         var rule2 = new RuleV2(&#34;rule2&#34;, RuleV2Args.builder()        
 *             .description(&#34;drop NTP traffic&#34;)
 *             .action(&#34;deny&#34;)
 *             .protocol(&#34;udp&#34;)
 *             .destinationPort(&#34;123&#34;)
 *             .enabled(&#34;false&#34;)
 *             .build());
 * 
 *         var policy1 = new PolicyV2(&#34;policy1&#34;, PolicyV2Args.builder()        
 *             .rules(            
 *                 rule1.id(),
 *                 rule2.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Firewall Policies can be imported using the `id`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:firewall/policyV2:PolicyV2 policy_1 07f422e6-c596-474b-8b94-fe2c12506ce0
 * ```
 * 
 */
@ResourceType(type="openstack:firewall/policyV2:PolicyV2")
public class PolicyV2 extends com.pulumi.resources.CustomResource {
    /**
     * Audit status of the firewall policy
     * (must be &#34;true&#34; or &#34;false&#34; if provided - defaults to &#34;false&#34;).
     * This status is set to &#34;false&#34; whenever the firewall policy or any of its
     * rules are changed. Changing this updates the `audited` status of an existing
     * firewall policy.
     * 
     */
    @Export(name="audited", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> audited;

    /**
     * @return Audit status of the firewall policy
     * (must be &#34;true&#34; or &#34;false&#34; if provided - defaults to &#34;false&#34;).
     * This status is set to &#34;false&#34; whenever the firewall policy or any of its
     * rules are changed. Changing this updates the `audited` status of an existing
     * firewall policy.
     * 
     */
    public Output<Optional<Boolean>> audited() {
        return Codegen.optional(this.audited);
    }
    /**
     * A description for the firewall policy. Changing
     * this updates the `description` of an existing firewall policy.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> description;

    /**
     * @return A description for the firewall policy. Changing
     * this updates the `description` of an existing firewall policy.
     * 
     */
    public Output<Optional<String>> description() {
        return Codegen.optional(this.description);
    }
    /**
     * A name for the firewall policy. Changing this
     * updates the `name` of an existing firewall policy.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return A name for the firewall policy. Changing this
     * updates the `name` of an existing firewall policy.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * This argument conflicts and is interchangeable
     * with `tenant_id`. The owner of the firewall policy. Required if admin wants
     * to create a firewall policy for another project. Changing this creates a new
     * firewall policy.
     * 
     */
    @Export(name="projectId", refs={String.class}, tree="[0]")
    private Output<String> projectId;

    /**
     * @return This argument conflicts and is interchangeable
     * with `tenant_id`. The owner of the firewall policy. Required if admin wants
     * to create a firewall policy for another project. Changing this creates a new
     * firewall policy.
     * 
     */
    public Output<String> projectId() {
        return this.projectId;
    }
    /**
     * The region in which to obtain the v2 networking client.
     * A networking client is needed to create a firewall policy. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * firewall policy.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the v2 networking client.
     * A networking client is needed to create a firewall policy. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * firewall policy.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * An array of one or more firewall rules that comprise
     * the policy. Changing this results in adding/removing rules from the
     * existing firewall policy.
     * 
     */
    @Export(name="rules", refs={List.class,String.class}, tree="[0,1]")
    private Output</* @Nullable */ List<String>> rules;

    /**
     * @return An array of one or more firewall rules that comprise
     * the policy. Changing this results in adding/removing rules from the
     * existing firewall policy.
     * 
     */
    public Output<Optional<List<String>>> rules() {
        return Codegen.optional(this.rules);
    }
    /**
     * Sharing status of the firewall policy (must be &#34;true&#34;
     * or &#34;false&#34; if provided). If this is &#34;true&#34; the policy is visible to, and
     * can be used in, firewalls in other tenants. Changing this updates the
     * `shared` status of an existing firewall policy. Only administrative users
     * can specify if the policy should be shared.
     * 
     */
    @Export(name="shared", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> shared;

    /**
     * @return Sharing status of the firewall policy (must be &#34;true&#34;
     * or &#34;false&#34; if provided). If this is &#34;true&#34; the policy is visible to, and
     * can be used in, firewalls in other tenants. Changing this updates the
     * `shared` status of an existing firewall policy. Only administrative users
     * can specify if the policy should be shared.
     * 
     */
    public Output<Optional<Boolean>> shared() {
        return Codegen.optional(this.shared);
    }
    /**
     * This argument conflicts and is interchangeable
     * with `project_id`. The owner of the firewall policy. Required if admin wants
     * to create a firewall policy for another tenant. Changing this creates a new
     * firewall policy.
     * 
     */
    @Export(name="tenantId", refs={String.class}, tree="[0]")
    private Output<String> tenantId;

    /**
     * @return This argument conflicts and is interchangeable
     * with `project_id`. The owner of the firewall policy. Required if admin wants
     * to create a firewall policy for another tenant. Changing this creates a new
     * firewall policy.
     * 
     */
    public Output<String> tenantId() {
        return this.tenantId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public PolicyV2(String name) {
        this(name, PolicyV2Args.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public PolicyV2(String name, @Nullable PolicyV2Args args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public PolicyV2(String name, @Nullable PolicyV2Args args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:firewall/policyV2:PolicyV2", name, args == null ? PolicyV2Args.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private PolicyV2(String name, Output<String> id, @Nullable PolicyV2State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:firewall/policyV2:PolicyV2", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static PolicyV2 get(String name, Output<String> id, @Nullable PolicyV2State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new PolicyV2(name, id, state, options);
    }
}
