// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.identity;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.openstack.identity.inputs.ApplicationCredentialAccessRuleArgs;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ApplicationCredentialArgs extends com.pulumi.resources.ResourceArgs {

    public static final ApplicationCredentialArgs Empty = new ApplicationCredentialArgs();

    /**
     * A collection of one or more access rules, which
     * this application credential allows to follow. The structure is described
     * below. Changing this creates a new application credential.
     * 
     */
    @Import(name="accessRules")
    private @Nullable Output<List<ApplicationCredentialAccessRuleArgs>> accessRules;

    /**
     * @return A collection of one or more access rules, which
     * this application credential allows to follow. The structure is described
     * below. Changing this creates a new application credential.
     * 
     */
    public Optional<Output<List<ApplicationCredentialAccessRuleArgs>>> accessRules() {
        return Optional.ofNullable(this.accessRules);
    }

    /**
     * A description of the application credential.
     * Changing this creates a new application credential.
     * 
     */
    @Import(name="description")
    private @Nullable Output<String> description;

    /**
     * @return A description of the application credential.
     * Changing this creates a new application credential.
     * 
     */
    public Optional<Output<String>> description() {
        return Optional.ofNullable(this.description);
    }

    /**
     * The expiration time of the application credential
     * in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted,
     * an application credential will never expire. Changing this creates a new
     * application credential.
     * 
     */
    @Import(name="expiresAt")
    private @Nullable Output<String> expiresAt;

    /**
     * @return The expiration time of the application credential
     * in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted,
     * an application credential will never expire. Changing this creates a new
     * application credential.
     * 
     */
    public Optional<Output<String>> expiresAt() {
        return Optional.ofNullable(this.expiresAt);
    }

    /**
     * A name of the application credential. Changing this
     * creates a new application credential.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return A name of the application credential. Changing this
     * creates a new application credential.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The region in which to obtain the V3 Keystone client.
     * If omitted, the `region` argument of the provider is used. Changing this
     * creates a new application credential.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V3 Keystone client.
     * If omitted, the `region` argument of the provider is used. Changing this
     * creates a new application credential.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * A collection of one or more role names, which this
     * application credential has to be associated with its project. If omitted,
     * all the current user&#39;s roles within the scoped project will be inherited by
     * a new application credential. Changing this creates a new application
     * credential.
     * 
     */
    @Import(name="roles")
    private @Nullable Output<List<String>> roles;

    /**
     * @return A collection of one or more role names, which this
     * application credential has to be associated with its project. If omitted,
     * all the current user&#39;s roles within the scoped project will be inherited by
     * a new application credential. Changing this creates a new application
     * credential.
     * 
     */
    public Optional<Output<List<String>>> roles() {
        return Optional.ofNullable(this.roles);
    }

    /**
     * The secret for the application credential. If omitted,
     * it will be generated by the server. Changing this creates a new application
     * credential.
     * 
     */
    @Import(name="secret")
    private @Nullable Output<String> secret;

    /**
     * @return The secret for the application credential. If omitted,
     * it will be generated by the server. Changing this creates a new application
     * credential.
     * 
     */
    public Optional<Output<String>> secret() {
        return Optional.ofNullable(this.secret);
    }

    /**
     * A flag indicating whether the application
     * credential may be used for creation or destruction of other application
     * credentials or trusts. Changing this creates a new application credential.
     * 
     */
    @Import(name="unrestricted")
    private @Nullable Output<Boolean> unrestricted;

    /**
     * @return A flag indicating whether the application
     * credential may be used for creation or destruction of other application
     * credentials or trusts. Changing this creates a new application credential.
     * 
     */
    public Optional<Output<Boolean>> unrestricted() {
        return Optional.ofNullable(this.unrestricted);
    }

    private ApplicationCredentialArgs() {}

    private ApplicationCredentialArgs(ApplicationCredentialArgs $) {
        this.accessRules = $.accessRules;
        this.description = $.description;
        this.expiresAt = $.expiresAt;
        this.name = $.name;
        this.region = $.region;
        this.roles = $.roles;
        this.secret = $.secret;
        this.unrestricted = $.unrestricted;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ApplicationCredentialArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ApplicationCredentialArgs $;

        public Builder() {
            $ = new ApplicationCredentialArgs();
        }

        public Builder(ApplicationCredentialArgs defaults) {
            $ = new ApplicationCredentialArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param accessRules A collection of one or more access rules, which
         * this application credential allows to follow. The structure is described
         * below. Changing this creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder accessRules(@Nullable Output<List<ApplicationCredentialAccessRuleArgs>> accessRules) {
            $.accessRules = accessRules;
            return this;
        }

        /**
         * @param accessRules A collection of one or more access rules, which
         * this application credential allows to follow. The structure is described
         * below. Changing this creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder accessRules(List<ApplicationCredentialAccessRuleArgs> accessRules) {
            return accessRules(Output.of(accessRules));
        }

        /**
         * @param accessRules A collection of one or more access rules, which
         * this application credential allows to follow. The structure is described
         * below. Changing this creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder accessRules(ApplicationCredentialAccessRuleArgs... accessRules) {
            return accessRules(List.of(accessRules));
        }

        /**
         * @param description A description of the application credential.
         * Changing this creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder description(@Nullable Output<String> description) {
            $.description = description;
            return this;
        }

        /**
         * @param description A description of the application credential.
         * Changing this creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder description(String description) {
            return description(Output.of(description));
        }

        /**
         * @param expiresAt The expiration time of the application credential
         * in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted,
         * an application credential will never expire. Changing this creates a new
         * application credential.
         * 
         * @return builder
         * 
         */
        public Builder expiresAt(@Nullable Output<String> expiresAt) {
            $.expiresAt = expiresAt;
            return this;
        }

        /**
         * @param expiresAt The expiration time of the application credential
         * in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted,
         * an application credential will never expire. Changing this creates a new
         * application credential.
         * 
         * @return builder
         * 
         */
        public Builder expiresAt(String expiresAt) {
            return expiresAt(Output.of(expiresAt));
        }

        /**
         * @param name A name of the application credential. Changing this
         * creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name A name of the application credential. Changing this
         * creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param region The region in which to obtain the V3 Keystone client.
         * If omitted, the `region` argument of the provider is used. Changing this
         * creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V3 Keystone client.
         * If omitted, the `region` argument of the provider is used. Changing this
         * creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param roles A collection of one or more role names, which this
         * application credential has to be associated with its project. If omitted,
         * all the current user&#39;s roles within the scoped project will be inherited by
         * a new application credential. Changing this creates a new application
         * credential.
         * 
         * @return builder
         * 
         */
        public Builder roles(@Nullable Output<List<String>> roles) {
            $.roles = roles;
            return this;
        }

        /**
         * @param roles A collection of one or more role names, which this
         * application credential has to be associated with its project. If omitted,
         * all the current user&#39;s roles within the scoped project will be inherited by
         * a new application credential. Changing this creates a new application
         * credential.
         * 
         * @return builder
         * 
         */
        public Builder roles(List<String> roles) {
            return roles(Output.of(roles));
        }

        /**
         * @param roles A collection of one or more role names, which this
         * application credential has to be associated with its project. If omitted,
         * all the current user&#39;s roles within the scoped project will be inherited by
         * a new application credential. Changing this creates a new application
         * credential.
         * 
         * @return builder
         * 
         */
        public Builder roles(String... roles) {
            return roles(List.of(roles));
        }

        /**
         * @param secret The secret for the application credential. If omitted,
         * it will be generated by the server. Changing this creates a new application
         * credential.
         * 
         * @return builder
         * 
         */
        public Builder secret(@Nullable Output<String> secret) {
            $.secret = secret;
            return this;
        }

        /**
         * @param secret The secret for the application credential. If omitted,
         * it will be generated by the server. Changing this creates a new application
         * credential.
         * 
         * @return builder
         * 
         */
        public Builder secret(String secret) {
            return secret(Output.of(secret));
        }

        /**
         * @param unrestricted A flag indicating whether the application
         * credential may be used for creation or destruction of other application
         * credentials or trusts. Changing this creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder unrestricted(@Nullable Output<Boolean> unrestricted) {
            $.unrestricted = unrestricted;
            return this;
        }

        /**
         * @param unrestricted A flag indicating whether the application
         * credential may be used for creation or destruction of other application
         * credentials or trusts. Changing this creates a new application credential.
         * 
         * @return builder
         * 
         */
        public Builder unrestricted(Boolean unrestricted) {
            return unrestricted(Output.of(unrestricted));
        }

        public ApplicationCredentialArgs build() {
            return $;
        }
    }

}
