// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.identity.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ApplicationCredentialAccessRuleArgs extends com.pulumi.resources.ResourceArgs {

    public static final ApplicationCredentialAccessRuleArgs Empty = new ApplicationCredentialAccessRuleArgs();

    /**
     * The ID of the existing access rule. The access rule ID of
     * another application credential can be provided.
     * 
     */
    @Import(name="id")
    private @Nullable Output<String> id;

    /**
     * @return The ID of the existing access rule. The access rule ID of
     * another application credential can be provided.
     * 
     */
    public Optional<Output<String>> id() {
        return Optional.ofNullable(this.id);
    }

    /**
     * The request method that the application credential is
     * permitted to use for a given API endpoint. Allowed values: `POST`, `GET`,
     * `HEAD`, `PATCH`, `PUT` and `DELETE`.
     * 
     */
    @Import(name="method", required=true)
    private Output<String> method;

    /**
     * @return The request method that the application credential is
     * permitted to use for a given API endpoint. Allowed values: `POST`, `GET`,
     * `HEAD`, `PATCH`, `PUT` and `DELETE`.
     * 
     */
    public Output<String> method() {
        return this.method;
    }

    /**
     * The API path that the application credential is permitted
     * to access. May use named wildcards such as **{tag}** or the unnamed wildcard
     * **\*** to match against any string in the path up to a **{@literal /}**, or the recursive
     * wildcard **\*\*** to include **{@literal /}** in the matched path.
     * 
     */
    @Import(name="path", required=true)
    private Output<String> path;

    /**
     * @return The API path that the application credential is permitted
     * to access. May use named wildcards such as **{tag}** or the unnamed wildcard
     * **\*** to match against any string in the path up to a **{@literal /}**, or the recursive
     * wildcard **\*\*** to include **{@literal /}** in the matched path.
     * 
     */
    public Output<String> path() {
        return this.path;
    }

    /**
     * The service type identifier for the service that the
     * application credential is granted to access. Must be a service type that is
     * listed in the service catalog and not a code name for a service. E.g.
     * **identity**, **compute**, **volumev3**, **image**, **network**,
     * **object-store**, **sharev2**, **dns**, **key-manager**, **monitoring**, etc.
     * 
     */
    @Import(name="service", required=true)
    private Output<String> service;

    /**
     * @return The service type identifier for the service that the
     * application credential is granted to access. Must be a service type that is
     * listed in the service catalog and not a code name for a service. E.g.
     * **identity**, **compute**, **volumev3**, **image**, **network**,
     * **object-store**, **sharev2**, **dns**, **key-manager**, **monitoring**, etc.
     * 
     */
    public Output<String> service() {
        return this.service;
    }

    private ApplicationCredentialAccessRuleArgs() {}

    private ApplicationCredentialAccessRuleArgs(ApplicationCredentialAccessRuleArgs $) {
        this.id = $.id;
        this.method = $.method;
        this.path = $.path;
        this.service = $.service;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ApplicationCredentialAccessRuleArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ApplicationCredentialAccessRuleArgs $;

        public Builder() {
            $ = new ApplicationCredentialAccessRuleArgs();
        }

        public Builder(ApplicationCredentialAccessRuleArgs defaults) {
            $ = new ApplicationCredentialAccessRuleArgs(Objects.requireNonNull(defaults));
        }

        /**
         * @param id The ID of the existing access rule. The access rule ID of
         * another application credential can be provided.
         * 
         * @return builder
         * 
         */
        public Builder id(@Nullable Output<String> id) {
            $.id = id;
            return this;
        }

        /**
         * @param id The ID of the existing access rule. The access rule ID of
         * another application credential can be provided.
         * 
         * @return builder
         * 
         */
        public Builder id(String id) {
            return id(Output.of(id));
        }

        /**
         * @param method The request method that the application credential is
         * permitted to use for a given API endpoint. Allowed values: `POST`, `GET`,
         * `HEAD`, `PATCH`, `PUT` and `DELETE`.
         * 
         * @return builder
         * 
         */
        public Builder method(Output<String> method) {
            $.method = method;
            return this;
        }

        /**
         * @param method The request method that the application credential is
         * permitted to use for a given API endpoint. Allowed values: `POST`, `GET`,
         * `HEAD`, `PATCH`, `PUT` and `DELETE`.
         * 
         * @return builder
         * 
         */
        public Builder method(String method) {
            return method(Output.of(method));
        }

        /**
         * @param path The API path that the application credential is permitted
         * to access. May use named wildcards such as **{tag}** or the unnamed wildcard
         * **\*** to match against any string in the path up to a **{@literal /}**, or the recursive
         * wildcard **\*\*** to include **{@literal /}** in the matched path.
         * 
         * @return builder
         * 
         */
        public Builder path(Output<String> path) {
            $.path = path;
            return this;
        }

        /**
         * @param path The API path that the application credential is permitted
         * to access. May use named wildcards such as **{tag}** or the unnamed wildcard
         * **\*** to match against any string in the path up to a **{@literal /}**, or the recursive
         * wildcard **\*\*** to include **{@literal /}** in the matched path.
         * 
         * @return builder
         * 
         */
        public Builder path(String path) {
            return path(Output.of(path));
        }

        /**
         * @param service The service type identifier for the service that the
         * application credential is granted to access. Must be a service type that is
         * listed in the service catalog and not a code name for a service. E.g.
         * **identity**, **compute**, **volumev3**, **image**, **network**,
         * **object-store**, **sharev2**, **dns**, **key-manager**, **monitoring**, etc.
         * 
         * @return builder
         * 
         */
        public Builder service(Output<String> service) {
            $.service = service;
            return this;
        }

        /**
         * @param service The service type identifier for the service that the
         * application credential is granted to access. Must be a service type that is
         * listed in the service catalog and not a code name for a service. E.g.
         * **identity**, **compute**, **volumev3**, **image**, **network**,
         * **object-store**, **sharev2**, **dns**, **key-manager**, **monitoring**, etc.
         * 
         * @return builder
         * 
         */
        public Builder service(String service) {
            return service(Output.of(service));
        }

        public ApplicationCredentialAccessRuleArgs build() {
            if ($.method == null) {
                throw new MissingRequiredPropertyException("ApplicationCredentialAccessRuleArgs", "method");
            }
            if ($.path == null) {
                throw new MissingRequiredPropertyException("ApplicationCredentialAccessRuleArgs", "path");
            }
            if ($.service == null) {
                throw new MissingRequiredPropertyException("ApplicationCredentialAccessRuleArgs", "service");
            }
            return $;
        }
    }

}
