// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.keymanager;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.keymanager.SecretV1Args;
import com.pulumi.openstack.keymanager.inputs.SecretV1State;
import com.pulumi.openstack.keymanager.outputs.SecretV1Acl;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * ## Example Usage
 * ### Simple secret
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.keymanager.SecretV1;
 * import com.pulumi.openstack.keymanager.SecretV1Args;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var secret1 = new SecretV1(&#34;secret1&#34;, SecretV1Args.builder()        
 *             .algorithm(&#34;aes&#34;)
 *             .bitLength(256)
 *             .metadata(Map.of(&#34;key&#34;, &#34;foo&#34;))
 *             .mode(&#34;cbc&#34;)
 *             .payload(&#34;foobar&#34;)
 *             .payloadContentType(&#34;text/plain&#34;)
 *             .secretType(&#34;passphrase&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ### Secret with the ACL
 * 
 * &gt; **Note** Only read ACLs are supported
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.keymanager.SecretV1;
 * import com.pulumi.openstack.keymanager.SecretV1Args;
 * import com.pulumi.openstack.keymanager.inputs.SecretV1AclArgs;
 * import com.pulumi.openstack.keymanager.inputs.SecretV1AclReadArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var secret1 = new SecretV1(&#34;secret1&#34;, SecretV1Args.builder()        
 *             .payload(Files.readString(Paths.get(&#34;certificate.pem&#34;)))
 *             .secretType(&#34;certificate&#34;)
 *             .payloadContentType(&#34;text/plain&#34;)
 *             .acl(SecretV1AclArgs.builder()
 *                 .read(SecretV1AclReadArgs.builder()
 *                     .projectAccess(false)
 *                     .users(                    
 *                         &#34;userid1&#34;,
 *                         &#34;userid2&#34;)
 *                     .build())
 *                 .build())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Secrets can be imported using the secret id (the last part of the secret reference), e.g.:
 * 
 * ```sh
 *  $ pulumi import openstack:keymanager/secretV1:SecretV1 secret_1 8a7a79c2-cf17-4e65-b2ae-ddc8bfcf6c74
 * ```
 * 
 */
@ResourceType(type="openstack:keymanager/secretV1:SecretV1")
public class SecretV1 extends com.pulumi.resources.CustomResource {
    /**
     * Allows to control an access to a secret. Currently only the
     * `read` operation is supported. If not specified, the secret is accessible
     * project wide.
     * 
     */
    @Export(name="acl", refs={SecretV1Acl.class}, tree="[0]")
    private Output<SecretV1Acl> acl;

    /**
     * @return Allows to control an access to a secret. Currently only the
     * `read` operation is supported. If not specified, the secret is accessible
     * project wide.
     * 
     */
    public Output<SecretV1Acl> acl() {
        return this.acl;
    }
    /**
     * Metadata provided by a user or system for informational purposes.
     * 
     */
    @Export(name="algorithm", refs={String.class}, tree="[0]")
    private Output<String> algorithm;

    /**
     * @return Metadata provided by a user or system for informational purposes.
     * 
     */
    public Output<String> algorithm() {
        return this.algorithm;
    }
    /**
     * The map of metadata, assigned on the secret, which has been
     * explicitly and implicitly added.
     * 
     */
    @Export(name="allMetadata", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output<Map<String,Object>> allMetadata;

    /**
     * @return The map of metadata, assigned on the secret, which has been
     * explicitly and implicitly added.
     * 
     */
    public Output<Map<String,Object>> allMetadata() {
        return this.allMetadata;
    }
    /**
     * Metadata provided by a user or system for informational purposes.
     * 
     */
    @Export(name="bitLength", refs={Integer.class}, tree="[0]")
    private Output<Integer> bitLength;

    /**
     * @return Metadata provided by a user or system for informational purposes.
     * 
     */
    public Output<Integer> bitLength() {
        return this.bitLength;
    }
    /**
     * The map of the content types, assigned on the secret.
     * 
     */
    @Export(name="contentTypes", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output<Map<String,Object>> contentTypes;

    /**
     * @return The map of the content types, assigned on the secret.
     * 
     */
    public Output<Map<String,Object>> contentTypes() {
        return this.contentTypes;
    }
    /**
     * The date the secret ACL was created.
     * 
     */
    @Export(name="createdAt", refs={String.class}, tree="[0]")
    private Output<String> createdAt;

    /**
     * @return The date the secret ACL was created.
     * 
     */
    public Output<String> createdAt() {
        return this.createdAt;
    }
    /**
     * The creator of the secret.
     * 
     */
    @Export(name="creatorId", refs={String.class}, tree="[0]")
    private Output<String> creatorId;

    /**
     * @return The creator of the secret.
     * 
     */
    public Output<String> creatorId() {
        return this.creatorId;
    }
    /**
     * The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
     * 
     */
    @Export(name="expiration", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> expiration;

    /**
     * @return The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
     * 
     */
    public Output<Optional<String>> expiration() {
        return Codegen.optional(this.expiration);
    }
    /**
     * Additional Metadata for the secret.
     * 
     */
    @Export(name="metadata", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output</* @Nullable */ Map<String,Object>> metadata;

    /**
     * @return Additional Metadata for the secret.
     * 
     */
    public Output<Optional<Map<String,Object>>> metadata() {
        return Codegen.optional(this.metadata);
    }
    /**
     * Metadata provided by a user or system for informational purposes.
     * 
     */
    @Export(name="mode", refs={String.class}, tree="[0]")
    private Output<String> mode;

    /**
     * @return Metadata provided by a user or system for informational purposes.
     * 
     */
    public Output<String> mode() {
        return this.mode;
    }
    /**
     * Human-readable name for the Secret. Does not have
     * to be unique.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Human-readable name for the Secret. Does not have
     * to be unique.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * The secret&#39;s data to be stored. **payload\_content\_type** must also be supplied if **payload** is included.
     * 
     */
    @Export(name="payload", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> payload;

    /**
     * @return The secret&#39;s data to be stored. **payload\_content\_type** must also be supplied if **payload** is included.
     * 
     */
    public Output<Optional<String>> payload() {
        return Codegen.optional(this.payload);
    }
    /**
     * (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
     * 
     */
    @Export(name="payloadContentEncoding", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> payloadContentEncoding;

    /**
     * @return (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
     * 
     */
    public Output<Optional<String>> payloadContentEncoding() {
        return Codegen.optional(this.payloadContentEncoding);
    }
    /**
     * (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
     * 
     */
    @Export(name="payloadContentType", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> payloadContentType;

    /**
     * @return (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
     * 
     */
    public Output<Optional<String>> payloadContentType() {
        return Codegen.optional(this.payloadContentType);
    }
    /**
     * The region in which to obtain the V1 KeyManager client.
     * A KeyManager client is needed to create a secret. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * V1 secret.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V1 KeyManager client.
     * A KeyManager client is needed to create a secret. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * V1 secret.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * The secret reference / where to find the secret.
     * 
     */
    @Export(name="secretRef", refs={String.class}, tree="[0]")
    private Output<String> secretRef;

    /**
     * @return The secret reference / where to find the secret.
     * 
     */
    public Output<String> secretRef() {
        return this.secretRef;
    }
    /**
     * Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
     * 
     */
    @Export(name="secretType", refs={String.class}, tree="[0]")
    private Output<String> secretType;

    /**
     * @return Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
     * 
     */
    public Output<String> secretType() {
        return this.secretType;
    }
    /**
     * The status of the secret.
     * 
     */
    @Export(name="status", refs={String.class}, tree="[0]")
    private Output<String> status;

    /**
     * @return The status of the secret.
     * 
     */
    public Output<String> status() {
        return this.status;
    }
    /**
     * The date the secret ACL was last updated.
     * 
     */
    @Export(name="updatedAt", refs={String.class}, tree="[0]")
    private Output<String> updatedAt;

    /**
     * @return The date the secret ACL was last updated.
     * 
     */
    public Output<String> updatedAt() {
        return this.updatedAt;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public SecretV1(String name) {
        this(name, SecretV1Args.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public SecretV1(String name, @Nullable SecretV1Args args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public SecretV1(String name, @Nullable SecretV1Args args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:keymanager/secretV1:SecretV1", name, args == null ? SecretV1Args.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private SecretV1(String name, Output<String> id, @Nullable SecretV1State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:keymanager/secretV1:SecretV1", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .additionalSecretOutputs(List.of(
                "payload"
            ))
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static SecretV1 get(String name, Output<String> id, @Nullable SecretV1State state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new SecretV1(name, id, state, options);
    }
}
