// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.keymanager.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.openstack.keymanager.inputs.ContainerV1AclArgs;
import com.pulumi.openstack.keymanager.inputs.ContainerV1ConsumerArgs;
import com.pulumi.openstack.keymanager.inputs.ContainerV1SecretRefArgs;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class ContainerV1State extends com.pulumi.resources.ResourceArgs {

    public static final ContainerV1State Empty = new ContainerV1State();

    /**
     * Allows to control an access to a container. Currently only
     * the `read` operation is supported. If not specified, the container is
     * accessible project wide. The `read` structure is described below.
     * 
     */
    @Import(name="acl")
    private @Nullable Output<ContainerV1AclArgs> acl;

    /**
     * @return Allows to control an access to a container. Currently only
     * the `read` operation is supported. If not specified, the container is
     * accessible project wide. The `read` structure is described below.
     * 
     */
    public Optional<Output<ContainerV1AclArgs>> acl() {
        return Optional.ofNullable(this.acl);
    }

    /**
     * The list of the container consumers. The structure is described below.
     * 
     */
    @Import(name="consumers")
    private @Nullable Output<List<ContainerV1ConsumerArgs>> consumers;

    /**
     * @return The list of the container consumers. The structure is described below.
     * 
     */
    public Optional<Output<List<ContainerV1ConsumerArgs>>> consumers() {
        return Optional.ofNullable(this.consumers);
    }

    /**
     * The container reference / where to find the container.
     * 
     */
    @Import(name="containerRef")
    private @Nullable Output<String> containerRef;

    /**
     * @return The container reference / where to find the container.
     * 
     */
    public Optional<Output<String>> containerRef() {
        return Optional.ofNullable(this.containerRef);
    }

    /**
     * The date the container ACL was created.
     * 
     */
    @Import(name="createdAt")
    private @Nullable Output<String> createdAt;

    /**
     * @return The date the container ACL was created.
     * 
     */
    public Optional<Output<String>> createdAt() {
        return Optional.ofNullable(this.createdAt);
    }

    /**
     * The creator of the container.
     * 
     */
    @Import(name="creatorId")
    private @Nullable Output<String> creatorId;

    /**
     * @return The creator of the container.
     * 
     */
    public Optional<Output<String>> creatorId() {
        return Optional.ofNullable(this.creatorId);
    }

    /**
     * Human-readable name for the Container. Does not have
     * to be unique.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Human-readable name for the Container. Does not have
     * to be unique.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The region in which to obtain the V1 KeyManager client.
     * A KeyManager client is needed to create a container. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * V1 container.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V1 KeyManager client.
     * A KeyManager client is needed to create a container. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * V1 container.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * A set of dictionaries containing references to secrets. The structure is described
     * below.
     * 
     */
    @Import(name="secretRefs")
    private @Nullable Output<List<ContainerV1SecretRefArgs>> secretRefs;

    /**
     * @return A set of dictionaries containing references to secrets. The structure is described
     * below.
     * 
     */
    public Optional<Output<List<ContainerV1SecretRefArgs>>> secretRefs() {
        return Optional.ofNullable(this.secretRefs);
    }

    /**
     * The status of the container.
     * 
     */
    @Import(name="status")
    private @Nullable Output<String> status;

    /**
     * @return The status of the container.
     * 
     */
    public Optional<Output<String>> status() {
        return Optional.ofNullable(this.status);
    }

    /**
     * Used to indicate the type of container. Must be one of `generic`, `rsa` or `certificate`.
     * 
     */
    @Import(name="type")
    private @Nullable Output<String> type;

    /**
     * @return Used to indicate the type of container. Must be one of `generic`, `rsa` or `certificate`.
     * 
     */
    public Optional<Output<String>> type() {
        return Optional.ofNullable(this.type);
    }

    /**
     * The date the container ACL was last updated.
     * 
     */
    @Import(name="updatedAt")
    private @Nullable Output<String> updatedAt;

    /**
     * @return The date the container ACL was last updated.
     * 
     */
    public Optional<Output<String>> updatedAt() {
        return Optional.ofNullable(this.updatedAt);
    }

    private ContainerV1State() {}

    private ContainerV1State(ContainerV1State $) {
        this.acl = $.acl;
        this.consumers = $.consumers;
        this.containerRef = $.containerRef;
        this.createdAt = $.createdAt;
        this.creatorId = $.creatorId;
        this.name = $.name;
        this.region = $.region;
        this.secretRefs = $.secretRefs;
        this.status = $.status;
        this.type = $.type;
        this.updatedAt = $.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(ContainerV1State defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private ContainerV1State $;

        public Builder() {
            $ = new ContainerV1State();
        }

        public Builder(ContainerV1State defaults) {
            $ = new ContainerV1State(Objects.requireNonNull(defaults));
        }

        /**
         * @param acl Allows to control an access to a container. Currently only
         * the `read` operation is supported. If not specified, the container is
         * accessible project wide. The `read` structure is described below.
         * 
         * @return builder
         * 
         */
        public Builder acl(@Nullable Output<ContainerV1AclArgs> acl) {
            $.acl = acl;
            return this;
        }

        /**
         * @param acl Allows to control an access to a container. Currently only
         * the `read` operation is supported. If not specified, the container is
         * accessible project wide. The `read` structure is described below.
         * 
         * @return builder
         * 
         */
        public Builder acl(ContainerV1AclArgs acl) {
            return acl(Output.of(acl));
        }

        /**
         * @param consumers The list of the container consumers. The structure is described below.
         * 
         * @return builder
         * 
         */
        public Builder consumers(@Nullable Output<List<ContainerV1ConsumerArgs>> consumers) {
            $.consumers = consumers;
            return this;
        }

        /**
         * @param consumers The list of the container consumers. The structure is described below.
         * 
         * @return builder
         * 
         */
        public Builder consumers(List<ContainerV1ConsumerArgs> consumers) {
            return consumers(Output.of(consumers));
        }

        /**
         * @param consumers The list of the container consumers. The structure is described below.
         * 
         * @return builder
         * 
         */
        public Builder consumers(ContainerV1ConsumerArgs... consumers) {
            return consumers(List.of(consumers));
        }

        /**
         * @param containerRef The container reference / where to find the container.
         * 
         * @return builder
         * 
         */
        public Builder containerRef(@Nullable Output<String> containerRef) {
            $.containerRef = containerRef;
            return this;
        }

        /**
         * @param containerRef The container reference / where to find the container.
         * 
         * @return builder
         * 
         */
        public Builder containerRef(String containerRef) {
            return containerRef(Output.of(containerRef));
        }

        /**
         * @param createdAt The date the container ACL was created.
         * 
         * @return builder
         * 
         */
        public Builder createdAt(@Nullable Output<String> createdAt) {
            $.createdAt = createdAt;
            return this;
        }

        /**
         * @param createdAt The date the container ACL was created.
         * 
         * @return builder
         * 
         */
        public Builder createdAt(String createdAt) {
            return createdAt(Output.of(createdAt));
        }

        /**
         * @param creatorId The creator of the container.
         * 
         * @return builder
         * 
         */
        public Builder creatorId(@Nullable Output<String> creatorId) {
            $.creatorId = creatorId;
            return this;
        }

        /**
         * @param creatorId The creator of the container.
         * 
         * @return builder
         * 
         */
        public Builder creatorId(String creatorId) {
            return creatorId(Output.of(creatorId));
        }

        /**
         * @param name Human-readable name for the Container. Does not have
         * to be unique.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Human-readable name for the Container. Does not have
         * to be unique.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param region The region in which to obtain the V1 KeyManager client.
         * A KeyManager client is needed to create a container. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * V1 container.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V1 KeyManager client.
         * A KeyManager client is needed to create a container. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * V1 container.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param secretRefs A set of dictionaries containing references to secrets. The structure is described
         * below.
         * 
         * @return builder
         * 
         */
        public Builder secretRefs(@Nullable Output<List<ContainerV1SecretRefArgs>> secretRefs) {
            $.secretRefs = secretRefs;
            return this;
        }

        /**
         * @param secretRefs A set of dictionaries containing references to secrets. The structure is described
         * below.
         * 
         * @return builder
         * 
         */
        public Builder secretRefs(List<ContainerV1SecretRefArgs> secretRefs) {
            return secretRefs(Output.of(secretRefs));
        }

        /**
         * @param secretRefs A set of dictionaries containing references to secrets. The structure is described
         * below.
         * 
         * @return builder
         * 
         */
        public Builder secretRefs(ContainerV1SecretRefArgs... secretRefs) {
            return secretRefs(List.of(secretRefs));
        }

        /**
         * @param status The status of the container.
         * 
         * @return builder
         * 
         */
        public Builder status(@Nullable Output<String> status) {
            $.status = status;
            return this;
        }

        /**
         * @param status The status of the container.
         * 
         * @return builder
         * 
         */
        public Builder status(String status) {
            return status(Output.of(status));
        }

        /**
         * @param type Used to indicate the type of container. Must be one of `generic`, `rsa` or `certificate`.
         * 
         * @return builder
         * 
         */
        public Builder type(@Nullable Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type Used to indicate the type of container. Must be one of `generic`, `rsa` or `certificate`.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        /**
         * @param updatedAt The date the container ACL was last updated.
         * 
         * @return builder
         * 
         */
        public Builder updatedAt(@Nullable Output<String> updatedAt) {
            $.updatedAt = updatedAt;
            return this;
        }

        /**
         * @param updatedAt The date the container ACL was last updated.
         * 
         * @return builder
         * 
         */
        public Builder updatedAt(String updatedAt) {
            return updatedAt(Output.of(updatedAt));
        }

        public ContainerV1State build() {
            return $;
        }
    }

}
