// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.keymanager.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.openstack.keymanager.inputs.SecretV1AclArgs;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class SecretV1State extends com.pulumi.resources.ResourceArgs {

    public static final SecretV1State Empty = new SecretV1State();

    /**
     * Allows to control an access to a secret. Currently only the
     * `read` operation is supported. If not specified, the secret is accessible
     * project wide.
     * 
     */
    @Import(name="acl")
    private @Nullable Output<SecretV1AclArgs> acl;

    /**
     * @return Allows to control an access to a secret. Currently only the
     * `read` operation is supported. If not specified, the secret is accessible
     * project wide.
     * 
     */
    public Optional<Output<SecretV1AclArgs>> acl() {
        return Optional.ofNullable(this.acl);
    }

    /**
     * Metadata provided by a user or system for informational purposes.
     * 
     */
    @Import(name="algorithm")
    private @Nullable Output<String> algorithm;

    /**
     * @return Metadata provided by a user or system for informational purposes.
     * 
     */
    public Optional<Output<String>> algorithm() {
        return Optional.ofNullable(this.algorithm);
    }

    /**
     * The map of metadata, assigned on the secret, which has been
     * explicitly and implicitly added.
     * 
     */
    @Import(name="allMetadata")
    private @Nullable Output<Map<String,Object>> allMetadata;

    /**
     * @return The map of metadata, assigned on the secret, which has been
     * explicitly and implicitly added.
     * 
     */
    public Optional<Output<Map<String,Object>>> allMetadata() {
        return Optional.ofNullable(this.allMetadata);
    }

    /**
     * Metadata provided by a user or system for informational purposes.
     * 
     */
    @Import(name="bitLength")
    private @Nullable Output<Integer> bitLength;

    /**
     * @return Metadata provided by a user or system for informational purposes.
     * 
     */
    public Optional<Output<Integer>> bitLength() {
        return Optional.ofNullable(this.bitLength);
    }

    /**
     * The map of the content types, assigned on the secret.
     * 
     */
    @Import(name="contentTypes")
    private @Nullable Output<Map<String,Object>> contentTypes;

    /**
     * @return The map of the content types, assigned on the secret.
     * 
     */
    public Optional<Output<Map<String,Object>>> contentTypes() {
        return Optional.ofNullable(this.contentTypes);
    }

    /**
     * The date the secret ACL was created.
     * 
     */
    @Import(name="createdAt")
    private @Nullable Output<String> createdAt;

    /**
     * @return The date the secret ACL was created.
     * 
     */
    public Optional<Output<String>> createdAt() {
        return Optional.ofNullable(this.createdAt);
    }

    /**
     * The creator of the secret.
     * 
     */
    @Import(name="creatorId")
    private @Nullable Output<String> creatorId;

    /**
     * @return The creator of the secret.
     * 
     */
    public Optional<Output<String>> creatorId() {
        return Optional.ofNullable(this.creatorId);
    }

    /**
     * The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
     * 
     */
    @Import(name="expiration")
    private @Nullable Output<String> expiration;

    /**
     * @return The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
     * 
     */
    public Optional<Output<String>> expiration() {
        return Optional.ofNullable(this.expiration);
    }

    /**
     * Additional Metadata for the secret.
     * 
     */
    @Import(name="metadata")
    private @Nullable Output<Map<String,Object>> metadata;

    /**
     * @return Additional Metadata for the secret.
     * 
     */
    public Optional<Output<Map<String,Object>>> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    /**
     * Metadata provided by a user or system for informational purposes.
     * 
     */
    @Import(name="mode")
    private @Nullable Output<String> mode;

    /**
     * @return Metadata provided by a user or system for informational purposes.
     * 
     */
    public Optional<Output<String>> mode() {
        return Optional.ofNullable(this.mode);
    }

    /**
     * Human-readable name for the Secret. Does not have
     * to be unique.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Human-readable name for the Secret. Does not have
     * to be unique.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The secret&#39;s data to be stored. **payload\_content\_type** must also be supplied if **payload** is included.
     * 
     */
    @Import(name="payload")
    private @Nullable Output<String> payload;

    /**
     * @return The secret&#39;s data to be stored. **payload\_content\_type** must also be supplied if **payload** is included.
     * 
     */
    public Optional<Output<String>> payload() {
        return Optional.ofNullable(this.payload);
    }

    /**
     * (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
     * 
     */
    @Import(name="payloadContentEncoding")
    private @Nullable Output<String> payloadContentEncoding;

    /**
     * @return (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
     * 
     */
    public Optional<Output<String>> payloadContentEncoding() {
        return Optional.ofNullable(this.payloadContentEncoding);
    }

    /**
     * (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
     * 
     */
    @Import(name="payloadContentType")
    private @Nullable Output<String> payloadContentType;

    /**
     * @return (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
     * 
     */
    public Optional<Output<String>> payloadContentType() {
        return Optional.ofNullable(this.payloadContentType);
    }

    /**
     * The region in which to obtain the V1 KeyManager client.
     * A KeyManager client is needed to create a secret. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * V1 secret.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V1 KeyManager client.
     * A KeyManager client is needed to create a secret. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * V1 secret.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The secret reference / where to find the secret.
     * 
     */
    @Import(name="secretRef")
    private @Nullable Output<String> secretRef;

    /**
     * @return The secret reference / where to find the secret.
     * 
     */
    public Optional<Output<String>> secretRef() {
        return Optional.ofNullable(this.secretRef);
    }

    /**
     * Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
     * 
     */
    @Import(name="secretType")
    private @Nullable Output<String> secretType;

    /**
     * @return Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
     * 
     */
    public Optional<Output<String>> secretType() {
        return Optional.ofNullable(this.secretType);
    }

    /**
     * The status of the secret.
     * 
     */
    @Import(name="status")
    private @Nullable Output<String> status;

    /**
     * @return The status of the secret.
     * 
     */
    public Optional<Output<String>> status() {
        return Optional.ofNullable(this.status);
    }

    /**
     * The date the secret ACL was last updated.
     * 
     */
    @Import(name="updatedAt")
    private @Nullable Output<String> updatedAt;

    /**
     * @return The date the secret ACL was last updated.
     * 
     */
    public Optional<Output<String>> updatedAt() {
        return Optional.ofNullable(this.updatedAt);
    }

    private SecretV1State() {}

    private SecretV1State(SecretV1State $) {
        this.acl = $.acl;
        this.algorithm = $.algorithm;
        this.allMetadata = $.allMetadata;
        this.bitLength = $.bitLength;
        this.contentTypes = $.contentTypes;
        this.createdAt = $.createdAt;
        this.creatorId = $.creatorId;
        this.expiration = $.expiration;
        this.metadata = $.metadata;
        this.mode = $.mode;
        this.name = $.name;
        this.payload = $.payload;
        this.payloadContentEncoding = $.payloadContentEncoding;
        this.payloadContentType = $.payloadContentType;
        this.region = $.region;
        this.secretRef = $.secretRef;
        this.secretType = $.secretType;
        this.status = $.status;
        this.updatedAt = $.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(SecretV1State defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private SecretV1State $;

        public Builder() {
            $ = new SecretV1State();
        }

        public Builder(SecretV1State defaults) {
            $ = new SecretV1State(Objects.requireNonNull(defaults));
        }

        /**
         * @param acl Allows to control an access to a secret. Currently only the
         * `read` operation is supported. If not specified, the secret is accessible
         * project wide.
         * 
         * @return builder
         * 
         */
        public Builder acl(@Nullable Output<SecretV1AclArgs> acl) {
            $.acl = acl;
            return this;
        }

        /**
         * @param acl Allows to control an access to a secret. Currently only the
         * `read` operation is supported. If not specified, the secret is accessible
         * project wide.
         * 
         * @return builder
         * 
         */
        public Builder acl(SecretV1AclArgs acl) {
            return acl(Output.of(acl));
        }

        /**
         * @param algorithm Metadata provided by a user or system for informational purposes.
         * 
         * @return builder
         * 
         */
        public Builder algorithm(@Nullable Output<String> algorithm) {
            $.algorithm = algorithm;
            return this;
        }

        /**
         * @param algorithm Metadata provided by a user or system for informational purposes.
         * 
         * @return builder
         * 
         */
        public Builder algorithm(String algorithm) {
            return algorithm(Output.of(algorithm));
        }

        /**
         * @param allMetadata The map of metadata, assigned on the secret, which has been
         * explicitly and implicitly added.
         * 
         * @return builder
         * 
         */
        public Builder allMetadata(@Nullable Output<Map<String,Object>> allMetadata) {
            $.allMetadata = allMetadata;
            return this;
        }

        /**
         * @param allMetadata The map of metadata, assigned on the secret, which has been
         * explicitly and implicitly added.
         * 
         * @return builder
         * 
         */
        public Builder allMetadata(Map<String,Object> allMetadata) {
            return allMetadata(Output.of(allMetadata));
        }

        /**
         * @param bitLength Metadata provided by a user or system for informational purposes.
         * 
         * @return builder
         * 
         */
        public Builder bitLength(@Nullable Output<Integer> bitLength) {
            $.bitLength = bitLength;
            return this;
        }

        /**
         * @param bitLength Metadata provided by a user or system for informational purposes.
         * 
         * @return builder
         * 
         */
        public Builder bitLength(Integer bitLength) {
            return bitLength(Output.of(bitLength));
        }

        /**
         * @param contentTypes The map of the content types, assigned on the secret.
         * 
         * @return builder
         * 
         */
        public Builder contentTypes(@Nullable Output<Map<String,Object>> contentTypes) {
            $.contentTypes = contentTypes;
            return this;
        }

        /**
         * @param contentTypes The map of the content types, assigned on the secret.
         * 
         * @return builder
         * 
         */
        public Builder contentTypes(Map<String,Object> contentTypes) {
            return contentTypes(Output.of(contentTypes));
        }

        /**
         * @param createdAt The date the secret ACL was created.
         * 
         * @return builder
         * 
         */
        public Builder createdAt(@Nullable Output<String> createdAt) {
            $.createdAt = createdAt;
            return this;
        }

        /**
         * @param createdAt The date the secret ACL was created.
         * 
         * @return builder
         * 
         */
        public Builder createdAt(String createdAt) {
            return createdAt(Output.of(createdAt));
        }

        /**
         * @param creatorId The creator of the secret.
         * 
         * @return builder
         * 
         */
        public Builder creatorId(@Nullable Output<String> creatorId) {
            $.creatorId = creatorId;
            return this;
        }

        /**
         * @param creatorId The creator of the secret.
         * 
         * @return builder
         * 
         */
        public Builder creatorId(String creatorId) {
            return creatorId(Output.of(creatorId));
        }

        /**
         * @param expiration The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
         * 
         * @return builder
         * 
         */
        public Builder expiration(@Nullable Output<String> expiration) {
            $.expiration = expiration;
            return this;
        }

        /**
         * @param expiration The expiration time of the secret in the RFC3339 timestamp format (e.g. `2019-03-09T12:58:49Z`). If omitted, a secret will never expire. Changing this creates a new secret.
         * 
         * @return builder
         * 
         */
        public Builder expiration(String expiration) {
            return expiration(Output.of(expiration));
        }

        /**
         * @param metadata Additional Metadata for the secret.
         * 
         * @return builder
         * 
         */
        public Builder metadata(@Nullable Output<Map<String,Object>> metadata) {
            $.metadata = metadata;
            return this;
        }

        /**
         * @param metadata Additional Metadata for the secret.
         * 
         * @return builder
         * 
         */
        public Builder metadata(Map<String,Object> metadata) {
            return metadata(Output.of(metadata));
        }

        /**
         * @param mode Metadata provided by a user or system for informational purposes.
         * 
         * @return builder
         * 
         */
        public Builder mode(@Nullable Output<String> mode) {
            $.mode = mode;
            return this;
        }

        /**
         * @param mode Metadata provided by a user or system for informational purposes.
         * 
         * @return builder
         * 
         */
        public Builder mode(String mode) {
            return mode(Output.of(mode));
        }

        /**
         * @param name Human-readable name for the Secret. Does not have
         * to be unique.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Human-readable name for the Secret. Does not have
         * to be unique.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param payload The secret&#39;s data to be stored. **payload\_content\_type** must also be supplied if **payload** is included.
         * 
         * @return builder
         * 
         */
        public Builder payload(@Nullable Output<String> payload) {
            $.payload = payload;
            return this;
        }

        /**
         * @param payload The secret&#39;s data to be stored. **payload\_content\_type** must also be supplied if **payload** is included.
         * 
         * @return builder
         * 
         */
        public Builder payload(String payload) {
            return payload(Output.of(payload));
        }

        /**
         * @param payloadContentEncoding (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
         * 
         * @return builder
         * 
         */
        public Builder payloadContentEncoding(@Nullable Output<String> payloadContentEncoding) {
            $.payloadContentEncoding = payloadContentEncoding;
            return this;
        }

        /**
         * @param payloadContentEncoding (required if **payload** is encoded) The encoding used for the payload to be able to include it in the JSON request. Must be either `base64` or `binary`.
         * 
         * @return builder
         * 
         */
        public Builder payloadContentEncoding(String payloadContentEncoding) {
            return payloadContentEncoding(Output.of(payloadContentEncoding));
        }

        /**
         * @param payloadContentType (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
         * 
         * @return builder
         * 
         */
        public Builder payloadContentType(@Nullable Output<String> payloadContentType) {
            $.payloadContentType = payloadContentType;
            return this;
        }

        /**
         * @param payloadContentType (required if **payload** is included) The media type for the content of the payload. Must be one of `text/plain`, `text/plain;charset=utf-8`, `text/plain; charset=utf-8`, `application/octet-stream`, `application/pkcs8`.
         * 
         * @return builder
         * 
         */
        public Builder payloadContentType(String payloadContentType) {
            return payloadContentType(Output.of(payloadContentType));
        }

        /**
         * @param region The region in which to obtain the V1 KeyManager client.
         * A KeyManager client is needed to create a secret. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * V1 secret.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V1 KeyManager client.
         * A KeyManager client is needed to create a secret. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * V1 secret.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param secretRef The secret reference / where to find the secret.
         * 
         * @return builder
         * 
         */
        public Builder secretRef(@Nullable Output<String> secretRef) {
            $.secretRef = secretRef;
            return this;
        }

        /**
         * @param secretRef The secret reference / where to find the secret.
         * 
         * @return builder
         * 
         */
        public Builder secretRef(String secretRef) {
            return secretRef(Output.of(secretRef));
        }

        /**
         * @param secretType Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
         * 
         * @return builder
         * 
         */
        public Builder secretType(@Nullable Output<String> secretType) {
            $.secretType = secretType;
            return this;
        }

        /**
         * @param secretType Used to indicate the type of secret being stored. For more information see [Secret types](https://docs.openstack.org/barbican/latest/api/reference/secret_types.html).
         * 
         * @return builder
         * 
         */
        public Builder secretType(String secretType) {
            return secretType(Output.of(secretType));
        }

        /**
         * @param status The status of the secret.
         * 
         * @return builder
         * 
         */
        public Builder status(@Nullable Output<String> status) {
            $.status = status;
            return this;
        }

        /**
         * @param status The status of the secret.
         * 
         * @return builder
         * 
         */
        public Builder status(String status) {
            return status(Output.of(status));
        }

        /**
         * @param updatedAt The date the secret ACL was last updated.
         * 
         * @return builder
         * 
         */
        public Builder updatedAt(@Nullable Output<String> updatedAt) {
            $.updatedAt = updatedAt;
            return this;
        }

        /**
         * @param updatedAt The date the secret ACL was last updated.
         * 
         * @return builder
         * 
         */
        public Builder updatedAt(String updatedAt) {
            return updatedAt(Output.of(updatedAt));
        }

        public SecretV1State build() {
            return $;
        }
    }

}
