// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.loadbalancer;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.Boolean;
import java.lang.String;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class L7RuleV2Args extends com.pulumi.resources.ResourceArgs {

    public static final L7RuleV2Args Empty = new L7RuleV2Args();

    /**
     * The administrative state of the L7 Rule.
     * A valid value is true (UP) or false (DOWN).
     * 
     */
    @Import(name="adminStateUp")
    private @Nullable Output<Boolean> adminStateUp;

    /**
     * @return The administrative state of the L7 Rule.
     * A valid value is true (UP) or false (DOWN).
     * 
     */
    public Optional<Output<Boolean>> adminStateUp() {
        return Optional.ofNullable(this.adminStateUp);
    }

    /**
     * The comparison type for the L7 rule - can either be
     * CONTAINS, STARTS\_WITH, ENDS_WITH, EQUAL_TO or REGEX
     * 
     */
    @Import(name="compareType", required=true)
    private Output<String> compareType;

    /**
     * @return The comparison type for the L7 rule - can either be
     * CONTAINS, STARTS\_WITH, ENDS_WITH, EQUAL_TO or REGEX
     * 
     */
    public Output<String> compareType() {
        return this.compareType;
    }

    /**
     * When true the logic of the rule is inverted. For example, with invert
     * true, equal to would become not equal to. Default is false.
     * 
     */
    @Import(name="invert")
    private @Nullable Output<Boolean> invert;

    /**
     * @return When true the logic of the rule is inverted. For example, with invert
     * true, equal to would become not equal to. Default is false.
     * 
     */
    public Optional<Output<Boolean>> invert() {
        return Optional.ofNullable(this.invert);
    }

    /**
     * The key to use for the comparison. For example, the name of the cookie to
     * evaluate. Valid when `type` is set to COOKIE or HEADER.
     * 
     */
    @Import(name="key")
    private @Nullable Output<String> key;

    /**
     * @return The key to use for the comparison. For example, the name of the cookie to
     * evaluate. Valid when `type` is set to COOKIE or HEADER.
     * 
     */
    public Optional<Output<String>> key() {
        return Optional.ofNullable(this.key);
    }

    /**
     * The ID of the L7 Policy to query. Changing this creates a new
     * L7 Rule.
     * 
     */
    @Import(name="l7policyId", required=true)
    private Output<String> l7policyId;

    /**
     * @return The ID of the L7 Policy to query. Changing this creates a new
     * L7 Rule.
     * 
     */
    public Output<String> l7policyId() {
        return this.l7policyId;
    }

    /**
     * The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create an . If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * L7 Rule.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create an . If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * L7 Rule.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * Required for admins. The UUID of the tenant who owns
     * the L7 Rule.  Only administrative users can specify a tenant UUID
     * other than their own. Changing this creates a new L7 Rule.
     * 
     */
    @Import(name="tenantId")
    private @Nullable Output<String> tenantId;

    /**
     * @return Required for admins. The UUID of the tenant who owns
     * the L7 Rule.  Only administrative users can specify a tenant UUID
     * other than their own. Changing this creates a new L7 Rule.
     * 
     */
    public Optional<Output<String>> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    /**
     * The L7 Rule type - can either be COOKIE, FILE\_TYPE, HEADER,
     * HOST\_NAME or PATH.
     * 
     */
    @Import(name="type", required=true)
    private Output<String> type;

    /**
     * @return The L7 Rule type - can either be COOKIE, FILE\_TYPE, HEADER,
     * HOST\_NAME or PATH.
     * 
     */
    public Output<String> type() {
        return this.type;
    }

    /**
     * The value to use for the comparison. For example, the file type to
     * compare.
     * 
     */
    @Import(name="value", required=true)
    private Output<String> value;

    /**
     * @return The value to use for the comparison. For example, the file type to
     * compare.
     * 
     */
    public Output<String> value() {
        return this.value;
    }

    private L7RuleV2Args() {}

    private L7RuleV2Args(L7RuleV2Args $) {
        this.adminStateUp = $.adminStateUp;
        this.compareType = $.compareType;
        this.invert = $.invert;
        this.key = $.key;
        this.l7policyId = $.l7policyId;
        this.region = $.region;
        this.tenantId = $.tenantId;
        this.type = $.type;
        this.value = $.value;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(L7RuleV2Args defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private L7RuleV2Args $;

        public Builder() {
            $ = new L7RuleV2Args();
        }

        public Builder(L7RuleV2Args defaults) {
            $ = new L7RuleV2Args(Objects.requireNonNull(defaults));
        }

        /**
         * @param adminStateUp The administrative state of the L7 Rule.
         * A valid value is true (UP) or false (DOWN).
         * 
         * @return builder
         * 
         */
        public Builder adminStateUp(@Nullable Output<Boolean> adminStateUp) {
            $.adminStateUp = adminStateUp;
            return this;
        }

        /**
         * @param adminStateUp The administrative state of the L7 Rule.
         * A valid value is true (UP) or false (DOWN).
         * 
         * @return builder
         * 
         */
        public Builder adminStateUp(Boolean adminStateUp) {
            return adminStateUp(Output.of(adminStateUp));
        }

        /**
         * @param compareType The comparison type for the L7 rule - can either be
         * CONTAINS, STARTS\_WITH, ENDS_WITH, EQUAL_TO or REGEX
         * 
         * @return builder
         * 
         */
        public Builder compareType(Output<String> compareType) {
            $.compareType = compareType;
            return this;
        }

        /**
         * @param compareType The comparison type for the L7 rule - can either be
         * CONTAINS, STARTS\_WITH, ENDS_WITH, EQUAL_TO or REGEX
         * 
         * @return builder
         * 
         */
        public Builder compareType(String compareType) {
            return compareType(Output.of(compareType));
        }

        /**
         * @param invert When true the logic of the rule is inverted. For example, with invert
         * true, equal to would become not equal to. Default is false.
         * 
         * @return builder
         * 
         */
        public Builder invert(@Nullable Output<Boolean> invert) {
            $.invert = invert;
            return this;
        }

        /**
         * @param invert When true the logic of the rule is inverted. For example, with invert
         * true, equal to would become not equal to. Default is false.
         * 
         * @return builder
         * 
         */
        public Builder invert(Boolean invert) {
            return invert(Output.of(invert));
        }

        /**
         * @param key The key to use for the comparison. For example, the name of the cookie to
         * evaluate. Valid when `type` is set to COOKIE or HEADER.
         * 
         * @return builder
         * 
         */
        public Builder key(@Nullable Output<String> key) {
            $.key = key;
            return this;
        }

        /**
         * @param key The key to use for the comparison. For example, the name of the cookie to
         * evaluate. Valid when `type` is set to COOKIE or HEADER.
         * 
         * @return builder
         * 
         */
        public Builder key(String key) {
            return key(Output.of(key));
        }

        /**
         * @param l7policyId The ID of the L7 Policy to query. Changing this creates a new
         * L7 Rule.
         * 
         * @return builder
         * 
         */
        public Builder l7policyId(Output<String> l7policyId) {
            $.l7policyId = l7policyId;
            return this;
        }

        /**
         * @param l7policyId The ID of the L7 Policy to query. Changing this creates a new
         * L7 Rule.
         * 
         * @return builder
         * 
         */
        public Builder l7policyId(String l7policyId) {
            return l7policyId(Output.of(l7policyId));
        }

        /**
         * @param region The region in which to obtain the V2 Networking client.
         * A Networking client is needed to create an . If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * L7 Rule.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 Networking client.
         * A Networking client is needed to create an . If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * L7 Rule.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param tenantId Required for admins. The UUID of the tenant who owns
         * the L7 Rule.  Only administrative users can specify a tenant UUID
         * other than their own. Changing this creates a new L7 Rule.
         * 
         * @return builder
         * 
         */
        public Builder tenantId(@Nullable Output<String> tenantId) {
            $.tenantId = tenantId;
            return this;
        }

        /**
         * @param tenantId Required for admins. The UUID of the tenant who owns
         * the L7 Rule.  Only administrative users can specify a tenant UUID
         * other than their own. Changing this creates a new L7 Rule.
         * 
         * @return builder
         * 
         */
        public Builder tenantId(String tenantId) {
            return tenantId(Output.of(tenantId));
        }

        /**
         * @param type The L7 Rule type - can either be COOKIE, FILE\_TYPE, HEADER,
         * HOST\_NAME or PATH.
         * 
         * @return builder
         * 
         */
        public Builder type(Output<String> type) {
            $.type = type;
            return this;
        }

        /**
         * @param type The L7 Rule type - can either be COOKIE, FILE\_TYPE, HEADER,
         * HOST\_NAME or PATH.
         * 
         * @return builder
         * 
         */
        public Builder type(String type) {
            return type(Output.of(type));
        }

        /**
         * @param value The value to use for the comparison. For example, the file type to
         * compare.
         * 
         * @return builder
         * 
         */
        public Builder value(Output<String> value) {
            $.value = value;
            return this;
        }

        /**
         * @param value The value to use for the comparison. For example, the file type to
         * compare.
         * 
         * @return builder
         * 
         */
        public Builder value(String value) {
            return value(Output.of(value));
        }

        public L7RuleV2Args build() {
            if ($.compareType == null) {
                throw new MissingRequiredPropertyException("L7RuleV2Args", "compareType");
            }
            if ($.l7policyId == null) {
                throw new MissingRequiredPropertyException("L7RuleV2Args", "l7policyId");
            }
            if ($.type == null) {
                throw new MissingRequiredPropertyException("L7RuleV2Args", "type");
            }
            if ($.value == null) {
                throw new MissingRequiredPropertyException("L7RuleV2Args", "value");
            }
            return $;
        }
    }

}
