// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.loadbalancer;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class PoolV1Args extends com.pulumi.resources.ResourceArgs {

    public static final PoolV1Args Empty = new PoolV1Args();

    /**
     * The algorithm used to distribute load between the
     * members of the pool. The current specification supports &#39;ROUND_ROBIN&#39; and
     * &#39;LEAST_CONNECTIONS&#39; as valid values for this attribute.
     * 
     */
    @Import(name="lbMethod", required=true)
    private Output<String> lbMethod;

    /**
     * @return The algorithm used to distribute load between the
     * members of the pool. The current specification supports &#39;ROUND_ROBIN&#39; and
     * &#39;LEAST_CONNECTIONS&#39; as valid values for this attribute.
     * 
     */
    public Output<String> lbMethod() {
        return this.lbMethod;
    }

    /**
     * The backend load balancing provider. For example:
     * `haproxy`, `F5`, etc.
     * 
     */
    @Import(name="lbProvider")
    private @Nullable Output<String> lbProvider;

    /**
     * @return The backend load balancing provider. For example:
     * `haproxy`, `F5`, etc.
     * 
     */
    public Optional<Output<String>> lbProvider() {
        return Optional.ofNullable(this.lbProvider);
    }

    /**
     * An existing node to add to the pool. Changing this
     * updates the members of the pool. The member object structure is documented
     * below. Please note that the `member` block is deprecated in favor of the
     * `openstack.loadbalancer.MemberV1` resource.
     * 
     * @deprecated
     * Use openstack_lb_member_v1 instead
     * 
     */
    @Deprecated /* Use openstack_lb_member_v1 instead */
    @Import(name="members")
    private @Nullable Output<List<String>> members;

    /**
     * @return An existing node to add to the pool. Changing this
     * updates the members of the pool. The member object structure is documented
     * below. Please note that the `member` block is deprecated in favor of the
     * `openstack.loadbalancer.MemberV1` resource.
     * 
     * @deprecated
     * Use openstack_lb_member_v1 instead
     * 
     */
    @Deprecated /* Use openstack_lb_member_v1 instead */
    public Optional<Output<List<String>>> members() {
        return Optional.ofNullable(this.members);
    }

    /**
     * A list of IDs of monitors to associate with the
     * pool.
     * 
     */
    @Import(name="monitorIds")
    private @Nullable Output<List<String>> monitorIds;

    /**
     * @return A list of IDs of monitors to associate with the
     * pool.
     * 
     */
    public Optional<Output<List<String>>> monitorIds() {
        return Optional.ofNullable(this.monitorIds);
    }

    /**
     * The name of the pool. Changing this updates the name of
     * the existing pool.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return The name of the pool. Changing this updates the name of
     * the existing pool.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * The protocol used by the pool members, you can use
     * either &#39;TCP, &#39;HTTP&#39;, or &#39;HTTPS&#39;. Changing this creates a new pool.
     * 
     */
    @Import(name="protocol", required=true)
    private Output<String> protocol;

    /**
     * @return The protocol used by the pool members, you can use
     * either &#39;TCP, &#39;HTTP&#39;, or &#39;HTTPS&#39;. Changing this creates a new pool.
     * 
     */
    public Output<String> protocol() {
        return this.protocol;
    }

    /**
     * The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create an LB pool. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * LB pool.
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create an LB pool. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * LB pool.
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The network on which the members of the pool will be
     * located. Only members that are on this network can be added to the pool.
     * Changing this creates a new pool.
     * 
     */
    @Import(name="subnetId", required=true)
    private Output<String> subnetId;

    /**
     * @return The network on which the members of the pool will be
     * located. Only members that are on this network can be added to the pool.
     * Changing this creates a new pool.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }

    /**
     * The owner of the pool. Required if admin wants to
     * create a pool member for another tenant. Changing this creates a new pool.
     * 
     */
    @Import(name="tenantId")
    private @Nullable Output<String> tenantId;

    /**
     * @return The owner of the pool. Required if admin wants to
     * create a pool member for another tenant. Changing this creates a new pool.
     * 
     */
    public Optional<Output<String>> tenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    private PoolV1Args() {}

    private PoolV1Args(PoolV1Args $) {
        this.lbMethod = $.lbMethod;
        this.lbProvider = $.lbProvider;
        this.members = $.members;
        this.monitorIds = $.monitorIds;
        this.name = $.name;
        this.protocol = $.protocol;
        this.region = $.region;
        this.subnetId = $.subnetId;
        this.tenantId = $.tenantId;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(PoolV1Args defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private PoolV1Args $;

        public Builder() {
            $ = new PoolV1Args();
        }

        public Builder(PoolV1Args defaults) {
            $ = new PoolV1Args(Objects.requireNonNull(defaults));
        }

        /**
         * @param lbMethod The algorithm used to distribute load between the
         * members of the pool. The current specification supports &#39;ROUND_ROBIN&#39; and
         * &#39;LEAST_CONNECTIONS&#39; as valid values for this attribute.
         * 
         * @return builder
         * 
         */
        public Builder lbMethod(Output<String> lbMethod) {
            $.lbMethod = lbMethod;
            return this;
        }

        /**
         * @param lbMethod The algorithm used to distribute load between the
         * members of the pool. The current specification supports &#39;ROUND_ROBIN&#39; and
         * &#39;LEAST_CONNECTIONS&#39; as valid values for this attribute.
         * 
         * @return builder
         * 
         */
        public Builder lbMethod(String lbMethod) {
            return lbMethod(Output.of(lbMethod));
        }

        /**
         * @param lbProvider The backend load balancing provider. For example:
         * `haproxy`, `F5`, etc.
         * 
         * @return builder
         * 
         */
        public Builder lbProvider(@Nullable Output<String> lbProvider) {
            $.lbProvider = lbProvider;
            return this;
        }

        /**
         * @param lbProvider The backend load balancing provider. For example:
         * `haproxy`, `F5`, etc.
         * 
         * @return builder
         * 
         */
        public Builder lbProvider(String lbProvider) {
            return lbProvider(Output.of(lbProvider));
        }

        /**
         * @param members An existing node to add to the pool. Changing this
         * updates the members of the pool. The member object structure is documented
         * below. Please note that the `member` block is deprecated in favor of the
         * `openstack.loadbalancer.MemberV1` resource.
         * 
         * @return builder
         * 
         * @deprecated
         * Use openstack_lb_member_v1 instead
         * 
         */
        @Deprecated /* Use openstack_lb_member_v1 instead */
        public Builder members(@Nullable Output<List<String>> members) {
            $.members = members;
            return this;
        }

        /**
         * @param members An existing node to add to the pool. Changing this
         * updates the members of the pool. The member object structure is documented
         * below. Please note that the `member` block is deprecated in favor of the
         * `openstack.loadbalancer.MemberV1` resource.
         * 
         * @return builder
         * 
         * @deprecated
         * Use openstack_lb_member_v1 instead
         * 
         */
        @Deprecated /* Use openstack_lb_member_v1 instead */
        public Builder members(List<String> members) {
            return members(Output.of(members));
        }

        /**
         * @param members An existing node to add to the pool. Changing this
         * updates the members of the pool. The member object structure is documented
         * below. Please note that the `member` block is deprecated in favor of the
         * `openstack.loadbalancer.MemberV1` resource.
         * 
         * @return builder
         * 
         * @deprecated
         * Use openstack_lb_member_v1 instead
         * 
         */
        @Deprecated /* Use openstack_lb_member_v1 instead */
        public Builder members(String... members) {
            return members(List.of(members));
        }

        /**
         * @param monitorIds A list of IDs of monitors to associate with the
         * pool.
         * 
         * @return builder
         * 
         */
        public Builder monitorIds(@Nullable Output<List<String>> monitorIds) {
            $.monitorIds = monitorIds;
            return this;
        }

        /**
         * @param monitorIds A list of IDs of monitors to associate with the
         * pool.
         * 
         * @return builder
         * 
         */
        public Builder monitorIds(List<String> monitorIds) {
            return monitorIds(Output.of(monitorIds));
        }

        /**
         * @param monitorIds A list of IDs of monitors to associate with the
         * pool.
         * 
         * @return builder
         * 
         */
        public Builder monitorIds(String... monitorIds) {
            return monitorIds(List.of(monitorIds));
        }

        /**
         * @param name The name of the pool. Changing this updates the name of
         * the existing pool.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name The name of the pool. Changing this updates the name of
         * the existing pool.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param protocol The protocol used by the pool members, you can use
         * either &#39;TCP, &#39;HTTP&#39;, or &#39;HTTPS&#39;. Changing this creates a new pool.
         * 
         * @return builder
         * 
         */
        public Builder protocol(Output<String> protocol) {
            $.protocol = protocol;
            return this;
        }

        /**
         * @param protocol The protocol used by the pool members, you can use
         * either &#39;TCP, &#39;HTTP&#39;, or &#39;HTTPS&#39;. Changing this creates a new pool.
         * 
         * @return builder
         * 
         */
        public Builder protocol(String protocol) {
            return protocol(Output.of(protocol));
        }

        /**
         * @param region The region in which to obtain the V2 Networking client.
         * A Networking client is needed to create an LB pool. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * LB pool.
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region in which to obtain the V2 Networking client.
         * A Networking client is needed to create an LB pool. If omitted, the
         * `region` argument of the provider is used. Changing this creates a new
         * LB pool.
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param subnetId The network on which the members of the pool will be
         * located. Only members that are on this network can be added to the pool.
         * Changing this creates a new pool.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(Output<String> subnetId) {
            $.subnetId = subnetId;
            return this;
        }

        /**
         * @param subnetId The network on which the members of the pool will be
         * located. Only members that are on this network can be added to the pool.
         * Changing this creates a new pool.
         * 
         * @return builder
         * 
         */
        public Builder subnetId(String subnetId) {
            return subnetId(Output.of(subnetId));
        }

        /**
         * @param tenantId The owner of the pool. Required if admin wants to
         * create a pool member for another tenant. Changing this creates a new pool.
         * 
         * @return builder
         * 
         */
        public Builder tenantId(@Nullable Output<String> tenantId) {
            $.tenantId = tenantId;
            return this;
        }

        /**
         * @param tenantId The owner of the pool. Required if admin wants to
         * create a pool member for another tenant. Changing this creates a new pool.
         * 
         * @return builder
         * 
         */
        public Builder tenantId(String tenantId) {
            return tenantId(Output.of(tenantId));
        }

        public PoolV1Args build() {
            if ($.lbMethod == null) {
                throw new MissingRequiredPropertyException("PoolV1Args", "lbMethod");
            }
            if ($.protocol == null) {
                throw new MissingRequiredPropertyException("PoolV1Args", "protocol");
            }
            if ($.subnetId == null) {
                throw new MissingRequiredPropertyException("PoolV1Args", "subnetId");
            }
            return $;
        }
    }

}
