// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.openstack.loadbalancer;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.openstack.Utilities;
import com.pulumi.openstack.loadbalancer.VipArgs;
import com.pulumi.openstack.loadbalancer.inputs.VipState;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * Manages a V1 load balancer vip resource within OpenStack.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.openstack.loadbalancer.Vip;
 * import com.pulumi.openstack.loadbalancer.VipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var vip1 = new Vip(&#34;vip1&#34;, VipArgs.builder()        
 *             .poolId(&#34;67890&#34;)
 *             .port(80)
 *             .protocol(&#34;HTTP&#34;)
 *             .subnetId(&#34;12345&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * ## Import
 * 
 * Load Balancer VIPs can be imported using the `id`, e.g.
 * 
 * ```sh
 *  $ pulumi import openstack:loadbalancer/vip:Vip vip_1 50e16b26-89c1-475e-a492-76167182511e
 * ```
 * 
 */
@ResourceType(type="openstack:loadbalancer/vip:Vip")
public class Vip extends com.pulumi.resources.CustomResource {
    /**
     * The IP address of the vip. Changing this creates a new
     * vip.
     * 
     */
    @Export(name="address", refs={String.class}, tree="[0]")
    private Output<String> address;

    /**
     * @return The IP address of the vip. Changing this creates a new
     * vip.
     * 
     */
    public Output<String> address() {
        return this.address;
    }
    /**
     * The administrative state of the vip.
     * Acceptable values are &#34;true&#34; and &#34;false&#34;. Changing this value updates the
     * state of the existing vip.
     * 
     */
    @Export(name="adminStateUp", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> adminStateUp;

    /**
     * @return The administrative state of the vip.
     * Acceptable values are &#34;true&#34; and &#34;false&#34;. Changing this value updates the
     * state of the existing vip.
     * 
     */
    public Output<Boolean> adminStateUp() {
        return this.adminStateUp;
    }
    /**
     * The maximum number of connections allowed for the
     * vip. Default is -1, meaning no limit. Changing this updates the conn_limit
     * of the existing vip.
     * 
     */
    @Export(name="connLimit", refs={Integer.class}, tree="[0]")
    private Output<Integer> connLimit;

    /**
     * @return The maximum number of connections allowed for the
     * vip. Default is -1, meaning no limit. Changing this updates the conn_limit
     * of the existing vip.
     * 
     */
    public Output<Integer> connLimit() {
        return this.connLimit;
    }
    /**
     * Human-readable description for the vip. Changing
     * this updates the description of the existing vip.
     * 
     */
    @Export(name="description", refs={String.class}, tree="[0]")
    private Output<String> description;

    /**
     * @return Human-readable description for the vip. Changing
     * this updates the description of the existing vip.
     * 
     */
    public Output<String> description() {
        return this.description;
    }
    /**
     * A *Networking* Floating IP that will be associated
     * with the vip. The Floating IP must be provisioned already.
     * 
     */
    @Export(name="floatingIp", refs={String.class}, tree="[0]")
    private Output</* @Nullable */ String> floatingIp;

    /**
     * @return A *Networking* Floating IP that will be associated
     * with the vip. The Floating IP must be provisioned already.
     * 
     */
    public Output<Optional<String>> floatingIp() {
        return Codegen.optional(this.floatingIp);
    }
    /**
     * The name of the vip. Changing this updates the name of
     * the existing vip.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return The name of the vip. Changing this updates the name of
     * the existing vip.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Omit this field to prevent session persistence.
     * The persistence object structure is documented below. Changing this updates
     * the persistence of the existing vip.
     * 
     */
    @Export(name="persistence", refs={Map.class,String.class,Object.class}, tree="[0,1,2]")
    private Output</* @Nullable */ Map<String,Object>> persistence;

    /**
     * @return Omit this field to prevent session persistence.
     * The persistence object structure is documented below. Changing this updates
     * the persistence of the existing vip.
     * 
     */
    public Output<Optional<Map<String,Object>>> persistence() {
        return Codegen.optional(this.persistence);
    }
    /**
     * The ID of the pool with which the vip is associated.
     * Changing this updates the pool_id of the existing vip.
     * 
     */
    @Export(name="poolId", refs={String.class}, tree="[0]")
    private Output<String> poolId;

    /**
     * @return The ID of the pool with which the vip is associated.
     * Changing this updates the pool_id of the existing vip.
     * 
     */
    public Output<String> poolId() {
        return this.poolId;
    }
    /**
     * The port on which to listen for client traffic. Changing
     * this creates a new vip.
     * 
     */
    @Export(name="port", refs={Integer.class}, tree="[0]")
    private Output<Integer> port;

    /**
     * @return The port on which to listen for client traffic. Changing
     * this creates a new vip.
     * 
     */
    public Output<Integer> port() {
        return this.port;
    }
    /**
     * Port UUID for this VIP at associated floating IP (if any).
     * 
     */
    @Export(name="portId", refs={String.class}, tree="[0]")
    private Output<String> portId;

    /**
     * @return Port UUID for this VIP at associated floating IP (if any).
     * 
     */
    public Output<String> portId() {
        return this.portId;
    }
    /**
     * The protocol - can be either &#39;TCP, &#39;HTTP&#39;, or
     * HTTPS&#39;. Changing this creates a new vip.
     * 
     */
    @Export(name="protocol", refs={String.class}, tree="[0]")
    private Output<String> protocol;

    /**
     * @return The protocol - can be either &#39;TCP, &#39;HTTP&#39;, or
     * HTTPS&#39;. Changing this creates a new vip.
     * 
     */
    public Output<String> protocol() {
        return this.protocol;
    }
    /**
     * The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a VIP. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * VIP.
     * 
     */
    @Export(name="region", refs={String.class}, tree="[0]")
    private Output<String> region;

    /**
     * @return The region in which to obtain the V2 Networking client.
     * A Networking client is needed to create a VIP. If omitted, the
     * `region` argument of the provider is used. Changing this creates a new
     * VIP.
     * 
     */
    public Output<String> region() {
        return this.region;
    }
    /**
     * The network on which to allocate the vip&#39;s address. A
     * tenant can only create vips on networks authorized by policy (e.g. networks
     * that belong to them or networks that are shared). Changing this creates a
     * new vip.
     * 
     */
    @Export(name="subnetId", refs={String.class}, tree="[0]")
    private Output<String> subnetId;

    /**
     * @return The network on which to allocate the vip&#39;s address. A
     * tenant can only create vips on networks authorized by policy (e.g. networks
     * that belong to them or networks that are shared). Changing this creates a
     * new vip.
     * 
     */
    public Output<String> subnetId() {
        return this.subnetId;
    }
    /**
     * The owner of the vip. Required if admin wants to
     * create a vip member for another tenant. Changing this creates a new vip.
     * 
     */
    @Export(name="tenantId", refs={String.class}, tree="[0]")
    private Output<String> tenantId;

    /**
     * @return The owner of the vip. Required if admin wants to
     * create a vip member for another tenant. Changing this creates a new vip.
     * 
     */
    public Output<String> tenantId() {
        return this.tenantId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Vip(String name) {
        this(name, VipArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Vip(String name, VipArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Vip(String name, VipArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:loadbalancer/vip:Vip", name, args == null ? VipArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Vip(String name, Output<String> id, @Nullable VipState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("openstack:loadbalancer/vip:Vip", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Vip get(String name, Output<String> id, @Nullable VipState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Vip(name, id, state, options);
    }
}
